package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.share.bean.BrandEntity;
import com.ejianc.foundation.share.bean.CategoryBrandEntity;
import com.ejianc.foundation.share.bean.MaterialCategoryEntity;
import com.ejianc.foundation.share.controller.api.MaterialApi;
import com.ejianc.foundation.share.service.IBrandService;
import com.ejianc.foundation.share.service.ICategoryBrandService;
import com.ejianc.foundation.share.service.IMaterialCategoryService;
import com.ejianc.foundation.share.vo.CategoryBrandVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 品牌分类
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("categoryBrand")
public class CategoryBrandController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private ICategoryBrandService service;

    @Autowired
    private IMaterialCategoryService materialCategoryService;

    @Autowired
    private IBrandService brandService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CategoryBrandVO> saveOrUpdate(@RequestBody CategoryBrandVO saveOrUpdateVO) {
        CategoryBrandEntity entity = BeanMapper.map(saveOrUpdateVO, CategoryBrandEntity.class);
        service.saveOrUpdate(entity, false);
        CategoryBrandVO vo = BeanMapper.map(entity, CategoryBrandVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @Description saveOrUpdateBatch 批量新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdateBatch", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<CategoryBrandVO>> saveOrUpdateBatch(@RequestBody List<CategoryBrandVO> saveOrUpdateVOS) {
        List<CategoryBrandEntity> entities = new ArrayList<>();
        for (CategoryBrandVO saveOrUpdateVO : saveOrUpdateVOS) {
            LambdaQueryWrapper<CategoryBrandEntity> categoryBrandLambdaQueryWrapper = Wrappers.lambdaQuery();
            categoryBrandLambdaQueryWrapper.eq(CategoryBrandEntity::getTenantId, InvocationInfoProxy.getTenantid());
            categoryBrandLambdaQueryWrapper.eq(CategoryBrandEntity::getCategoryId, saveOrUpdateVO.getCategoryId());
            categoryBrandLambdaQueryWrapper.eq(CategoryBrandEntity::getBrandId, saveOrUpdateVO.getBrandId());
            int count = service.count(categoryBrandLambdaQueryWrapper);
            if (count == 0) {
                CategoryBrandEntity entity = BeanMapper.map(saveOrUpdateVO, CategoryBrandEntity.class);
                entities.add(entity);
            }
        }
        if (CollectionUtils.isNotEmpty(entities)) {
            service.saveBatch(entities);
        }
        // 将实体列表转换回VO列表
        List<CategoryBrandVO> vos = BeanMapper.mapList(entities, CategoryBrandVO.class);
        return CommonResponse.success("批量保存或修改单据成功！", vos);
    }


    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CategoryBrandVO> queryDetail(Long id) {
        CategoryBrandEntity entity = service.selectById(id);
        CategoryBrandVO vo = BeanMapper.map(entity, CategoryBrandVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CategoryBrandVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            List<Long> ids = vos.stream().map(CategoryBrandVO::getId).collect(Collectors.toList());
            LambdaQueryWrapper<CategoryBrandEntity> queryWrapper = Wrappers.lambdaQuery();
            queryWrapper.in(CategoryBrandEntity::getId, ids);
            queryWrapper.eq(CategoryBrandEntity::getWhether, 1);
            int cout = service.count(queryWrapper);
            if (cout > 0) {
                return CommonResponse.error("只能删除非常用品牌，如需删除请取消常用后操作！");
            }
            service.removeByIds(ids);
        }
        return CommonResponse.success("删除成功！");
    }


    @RequestMapping(value = "/updateWhether", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CategoryBrandVO> updateWhether(Long id, Integer whether) {
        if (id != null) {
            CategoryBrandEntity categoryBrandEntity = service.selectById(id);
            if (whether == 1) {
                LambdaQueryWrapper<CategoryBrandEntity> categoryBrandLambdaQueryWrapper = Wrappers.lambdaQuery();
                categoryBrandLambdaQueryWrapper.eq(CategoryBrandEntity::getTenantId, InvocationInfoProxy.getTenantid());
                categoryBrandLambdaQueryWrapper.eq(CategoryBrandEntity::getCategoryId, categoryBrandEntity.getCategoryId());
                categoryBrandLambdaQueryWrapper.eq(CategoryBrandEntity::getWhether, 1);
                categoryBrandLambdaQueryWrapper.ne(CategoryBrandEntity::getId, id);
                List<CategoryBrandEntity> list = service.list(categoryBrandLambdaQueryWrapper);
                if (CollectionUtils.isNotEmpty(list)) {
                    return CommonResponse.error("该分类已设置常用品牌！");
                }
                materialCategoryService.updateCategoryBrand(categoryBrandEntity.getCategoryId(), categoryBrandEntity.getBrandId(), categoryBrandEntity.getBrandName());
            } else {
                materialCategoryService.updateCategoryBrand(categoryBrandEntity.getCategoryId(), null, null);
            }
            LambdaUpdateWrapper<CategoryBrandEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(CategoryBrandEntity::getId, id);
            updateWrapper.set(CategoryBrandEntity::getWhether, whether);
            service.update(updateWrapper);
        }

        return CommonResponse.success("操作成功！");
    }


    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CategoryBrandVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("whether", QueryParam.DESC);
        param.getOrderMap().put("categoryId", QueryParam.ASC);
        IPage<CategoryBrandEntity> page = service.queryPage(param, false);
        IPage<CategoryBrandVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CategoryBrandVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    /**
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryListByCategoryId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<CategoryBrandVO>> queryListByCategoryId(Long categoryId) {
        LambdaQueryWrapper<CategoryBrandEntity> categoryBrandLambdaQueryWrapper = Wrappers.lambdaQuery();
        categoryBrandLambdaQueryWrapper.eq(CategoryBrandEntity::getTenantId, InvocationInfoProxy.getTenantid());
        categoryBrandLambdaQueryWrapper.eq(CategoryBrandEntity::getCategoryId, categoryId);
        categoryBrandLambdaQueryWrapper.orderByDesc(CategoryBrandEntity::getWhether);
        List<CategoryBrandEntity> list = service.list(categoryBrandLambdaQueryWrapper);
        if (CollectionUtils.isNotEmpty(list)) {
            for (CategoryBrandEntity categoryBrandEntity : list) {
                categoryBrandEntity.setId(categoryBrandEntity.getBrandId());
            }
        }
        List<CategoryBrandVO> vos = BeanMapper.mapList(list, CategoryBrandVO.class);
        return CommonResponse.success("查询详情数据成功！", vos);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getOrderMap().put("whether", QueryParam.DESC);
        param.getOrderMap().put("categoryId", QueryParam.ASC);
        List<CategoryBrandEntity> list = service.queryList(param);
        List<CategoryBrandVO> categoryBrandVOS = BeanMapper.mapList(list, CategoryBrandVO.class);
        for (CategoryBrandVO vo : categoryBrandVOS) {
            switch (vo.getWhether()) {
                case 0:
                    vo.setWhetherName("否");
                    break;
                case 1:
                    vo.setWhetherName("是");
                    break;
            }
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", categoryBrandVOS);
        ExcelExport.getInstance().export("CategoryBrand-export.xlsx", beans, response);
    }

    /**
     * 导入模板下载
     */
    @RequestMapping(value = "/downloadTemplet")
    @ResponseBody
    public void downloadTemplet(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "CategoryBrand-import.xlsx", "导入分类品牌关系");
    }

    /**
     * 导入校验
     *
     */
    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            List<CategoryBrandVO> successList = new ArrayList<>();
            List<CategoryBrandVO> errorList = new ArrayList<>();
            if (result != null && result.size() > 0) {
                if (result.get(0).size() != 4) {
                    throw new BusinessException("请按照导入模板导入数据");
                }
            }

            // 导入excel里每个分类只能有一个常用校验
            Map<Long, Long> useBrandMap = new HashMap<>();

            for (int i = 0; i < result.size(); i++) {
                List<String> row = result.get(i);
                StringBuilder errMsg = new StringBuilder();
                CategoryBrandVO categoryBrandVO = new CategoryBrandVO();
                String categoryCode = row.get(0).trim();

                if (StringUtils.isNotBlank(categoryCode)) {
                    List<MaterialCategoryEntity> materialCategoryEntities = materialCategoryService.queryByCode(categoryCode);
                    if (CollectionUtils.isEmpty(materialCategoryEntities)) {
                        errMsg.append("`分类编码不存在`");
                    } else {
                        MaterialCategoryEntity categoryEntity = materialCategoryEntities.get(0);
                        categoryBrandVO.setCategoryId(categoryEntity.getId());
                        categoryBrandVO.setInnerCode(categoryEntity.getInnerCode());
                        categoryBrandVO.setCategoryName(categoryEntity.getName());
                    }
                    categoryBrandVO.setCategoryCode(categoryCode);
                } else {
                    errMsg.append("`分类编码未填写`");
                }

                //品牌名称
                String brandName = row.get(2).trim();
                if (StringUtils.isNotBlank(brandName)) {
                    categoryBrandVO.setBrandName(brandName);
                }

                //品牌编码
                String brandCode = row.get(1).trim();
                if (StringUtils.isNotBlank(brandCode)) {
                    LambdaQueryWrapper<BrandEntity> brandLambdaQueryWrapper = Wrappers.lambdaQuery();
                    brandLambdaQueryWrapper.eq(BrandEntity::getTenantId, InvocationInfoProxy.getTenantid());
                    brandLambdaQueryWrapper.eq(BrandEntity::getBrandCode, brandCode);
                    List<BrandEntity> list = brandService.list(brandLambdaQueryWrapper);
                    if (CollectionUtils.isEmpty(list)) {
                        errMsg.append("`品牌编码不存在`");
                    } else {
                        BrandEntity brandEntity = list.get(0);
                        categoryBrandVO.setBrandId(brandEntity.getId());
                        categoryBrandVO.setBrandName(brandEntity.getBrandName());
                    }
                    categoryBrandVO.setBrandCode(brandCode);
                } else {
                    errMsg.append("`品牌编码未填写`");
                }

                // 是否常用
                String whetherName = row.get(3).trim();
                Long categoryId = categoryBrandVO.getCategoryId();
                Long brandId = categoryBrandVO.getBrandId();

                if (StringUtils.isNotBlank(whetherName)) {
                    if ("是".equals(whetherName)) {
                        categoryBrandVO.setWhether(1);
                        if (categoryId != null && brandId != null) {
                            if (useBrandMap.containsKey(categoryId)) {
                                errMsg.append("`分类只能设置一个常用品牌`");
                            } else {
                                useBrandMap.put(categoryId, brandId);
                            }

                            LambdaQueryWrapper<CategoryBrandEntity> categoryBrandLambdaQueryWrapper = Wrappers.lambdaQuery();
                            categoryBrandLambdaQueryWrapper.eq(CategoryBrandEntity::getTenantId, InvocationInfoProxy.getTenantid());
                            categoryBrandLambdaQueryWrapper.eq(CategoryBrandEntity::getCategoryId, categoryId);
                            categoryBrandLambdaQueryWrapper.ne(CategoryBrandEntity::getBrandId, brandId);
                            categoryBrandLambdaQueryWrapper.eq(CategoryBrandEntity::getWhether, 1);
                            int count = service.count(categoryBrandLambdaQueryWrapper);
                            if (count > 0) {
                                errMsg.append("`该分类已设置常用品牌`");
                            }
                        }
                    } else {
                        categoryBrandVO.setWhether(0);
                    }
                    categoryBrandVO.setWhetherName(whetherName);
                } else {
                    errMsg.append("`是否常用品牌未填写`");
                }

                if (categoryId != null && brandId != null) {
                    LambdaQueryWrapper<CategoryBrandEntity> lambdaQueryWrapper = Wrappers.lambdaQuery();
                    lambdaQueryWrapper.eq(CategoryBrandEntity::getTenantId, InvocationInfoProxy.getTenantid());
                    lambdaQueryWrapper.eq(CategoryBrandEntity::getCategoryId, categoryId);
                    lambdaQueryWrapper.eq(CategoryBrandEntity::getBrandId, brandId);
                    int count = service.count(lambdaQueryWrapper);
                    if (count > 0) {
                        errMsg.append("`该分类品牌关系已存在`");
                    }
                }

                categoryBrandVO.setErrMsg(errMsg.toString());
                if (StringUtils.isNotBlank(categoryBrandVO.getErrMsg())) {
                    errorList.add(categoryBrandVO);
                } else {
                    successList.add(categoryBrandVO);
                }
            }


            JSONObject json = new JSONObject();
            json.put("successList", BeanMapper.mapList(successList, CategoryBrandVO.class));
            json.put("errorList", errorList);
            return CommonResponse.success(json);
        }
    }

    /**
     * @description: 保存导入
     */
    @RequestMapping(value = "/saveImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> saveImport(@RequestBody List<CategoryBrandVO> accbookVOS) {
        List<CategoryBrandEntity> categoryBrandEntityList = BeanMapper.mapList(accbookVOS, CategoryBrandEntity.class);
        boolean b = service.saveBatch(categoryBrandEntityList);
        if (b) {
            List<CategoryBrandEntity> entityList = categoryBrandEntityList.stream().filter(t -> t.getWhether().equals(1)).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(entityList)) {
                for (CategoryBrandEntity categoryBrand : entityList) {
                    materialCategoryService.updateCategoryBrand(categoryBrand.getCategoryId(), categoryBrand.getBrandId(), categoryBrand.getBrandName());
                }
            }
        }
        return CommonResponse.success("导入成功");
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refCategoryBrandData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<CategoryBrandVO>> refCategoryBrandData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                       String condition,
                                                                       String searchObject,
                                                                       String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<CategoryBrandEntity> page = service.queryPage(param, false);
        IPage<CategoryBrandVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CategoryBrandVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }
}
