package com.ejianc.foundation.share.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.share.bean.SupplierEntity;
import com.ejianc.foundation.share.service.ISupplierService;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

/**
 * @author CJ
 * @Description:
 * @date 2020/6/30 15:03
 */
@RestController
@RequestMapping("/api/supplierApi/")
public class SupplierApi {

    @Autowired
    private ISupplierService supplierService;

    /**
     * 根据供应商Id查询供应商信息
     *
     * @param id 供应商Id
     * @return
     */
    @GetMapping("queryById")
    CommonResponse<SupplierVO> queryById(@RequestParam(value = "id") Long id) {
        SupplierVO vo = supplierService.queryDetail(id);

        return CommonResponse.success("查询成功！", vo);
    }

    /**
     * 根据供应商Ids查询供应商信息
     *
     * @param ids 供应商Id
     * @return
     */
    @GetMapping("querySupplierByIds")
    CommonResponse<List<SupplierVO>> querySupplierByIds(@RequestParam(value = "ids") List<Long> ids) {
        List<SupplierVO> vos = new ArrayList<>();
        QueryWrapper<SupplierEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr", 0);
        queryWrapper.in("id", ids);
        List<SupplierEntity> entitys = supplierService.list(queryWrapper);
        if(entitys != null){
            vos = BeanMapper.mapList(entitys, SupplierVO.class);
        }
        return CommonResponse.success("查询成功！", vos);
    }

    /**
     * 根据供应商来源Id查询供应商信息
     *
     * @param sourceId 供应商Id
     * @return
     */
    @GetMapping("queryBySourceId")
    CommonResponse<SupplierVO> queryBySourceId(@RequestParam(value = "sourceId") String sourceId){
        QueryWrapper<SupplierEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr", 0);
        queryWrapper.eq("source_id", sourceId);
        List<SupplierEntity> entitys = supplierService.list(queryWrapper);
        if(entitys != null){
            return CommonResponse.success("查询成功！", BeanMapper.map(entitys.get(0), SupplierVO.class));
        }
        return CommonResponse.error("根据来源ID查询供应商失败！");
    }
}
