/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.support.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.support.bean.BillCodeRuleEntity;
import com.ejianc.foundation.support.mapper.BillCodeRuleMapper;
import com.ejianc.foundation.support.service.IBillCodeRuleAttrService;
import com.ejianc.foundation.support.service.IBillCodeRuleService;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillCodeRuleAttrVO;
import com.ejianc.foundation.support.vo.BillCodeRuleVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="billTypeRuleService")
public class BillCodeRuleServiceImpl
extends BaseServiceImpl<BillCodeRuleMapper, BillCodeRuleEntity>
implements IBillCodeRuleService {
    @Autowired
    private IBillCodeRuleAttrService billCodeRuleAttrService;
    @Value(value="${oms.tenantid}")
    private String BASE_TNANT_ID;

    @Override
    public void delete(List<Long> ids) {
        ((BillCodeRuleMapper)this.baseMapper).deleteBatchIds(ids);
    }

    @Override
    public BillCodeRuleVO queryDetail(Long id) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        BillCodeRuleVO vo = null;
        BillCodeRuleEntity entity = (BillCodeRuleEntity)((Object)((BillCodeRuleMapper)this.baseMapper).selectById(id));
        if (entity != null) {
            vo = (BillCodeRuleVO)BeanMapper.map((Object)((Object)entity), BillCodeRuleVO.class);
            this.queryAttrDetail(vo, tenantId);
        }
        return vo;
    }

    private void queryAttrDetail(BillCodeRuleVO vo, Long tenantId) {
        QueryParam q = new QueryParam();
        q.getParams().put("billcode_rule_id", new Parameter("eq", (Object)vo.getId()));
        q.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
        q.getOrderMap().put("elem_order", "asc");
        List<BillCodeRuleAttrVO> attrs = this.billCodeRuleAttrService.getListByProperties(q, false);
        if (CollectionUtils.isEmpty(attrs)) {
            q.getParams().put("tenant_id", new Parameter("eq", (Object)this.BASE_TNANT_ID));
            attrs = this.billCodeRuleAttrService.getListByProperties(q, false);
        }
        vo.setAttrs(attrs);
    }

    private void queryAttrDetail(BillCodeRuleVO vo, BillCodeParam billCodeParam) {
        JSONObject billDetail;
        QueryParam q = new QueryParam();
        q.getParams().put("billcode_rule_id", new Parameter("eq", (Object)vo.getId()));
        q.getParams().put("tenant_id", new Parameter("eq", (Object)billCodeParam.getTenantId()));
        q.getOrderMap().put("elem_order", "asc");
        List<BillCodeRuleAttrVO> attrs = this.billCodeRuleAttrService.getListByProperties(q, false);
        if (CollectionUtils.isEmpty(attrs)) {
            q.getParams().put("tenant_id", new Parameter("eq", (Object)this.BASE_TNANT_ID));
            attrs = this.billCodeRuleAttrService.getListByProperties(q, false);
        }
        if (attrs != null && attrs.size() > 0 && (billDetail = billCodeParam.getBillDetail()) != null) {
            for (BillCodeRuleAttrVO billCodeRuleAttrVO : attrs) {
                String key = billCodeRuleAttrVO.getElemValue().trim();
                String billValue = billDetail.getString(key);
                if (!StringUtils.isNotBlank((CharSequence)billValue)) continue;
                billCodeRuleAttrVO.setBillValue(billValue);
            }
        }
        vo.setAttrs(attrs);
    }

    @Override
    public void save(BillCodeRuleVO billCodeRuleVo) {
        BillCodeRuleEntity saveEntity = null;
        ArrayList<BillCodeRuleAttrVO> attrs = new ArrayList();
        if (null != billCodeRuleVo.getId()) {
            attrs = billCodeRuleVo.getAttrs();
            saveEntity = (BillCodeRuleEntity)((Object)((BillCodeRuleMapper)this.baseMapper).selectById(billCodeRuleVo.getId()));
            saveEntity.setRuleName(billCodeRuleVo.getRuleName());
            super.saveOrUpdate((Object)saveEntity);
        } else {
            billCodeRuleVo.setDr(BaseVO.DR_UNDELETE);
            billCodeRuleVo.setTenantId(InvocationInfoProxy.getTenantid());
            saveEntity = (BillCodeRuleEntity)((Object)BeanMapper.map((Object)billCodeRuleVo, BillCodeRuleEntity.class));
            super.saveOrUpdate((Object)saveEntity);
            attrs = billCodeRuleVo.getAttrs();
        }
        if (CollectionUtils.isNotEmpty(attrs)) {
            this.billCodeRuleAttrService.save(attrs, saveEntity.getId(), true);
        }
    }

    @Override
    public BillCodeRuleVO queryDetail(String ruleCode) {
        BillCodeRuleVO vo = null;
        Long tenantId = InvocationInfoProxy.getTenantid();
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.eq((Object)"rule_code", (Object)ruleCode);
        query.eq((Object)"tenant_id", (Object)this.BASE_TNANT_ID);
        BillCodeRuleEntity entity = (BillCodeRuleEntity)((Object)((BillCodeRuleMapper)this.baseMapper).selectOne((Wrapper)query));
        if (null != entity) {
            vo = (BillCodeRuleVO)BeanMapper.map((Object)((Object)entity), BillCodeRuleVO.class);
            this.queryAttrDetail(vo, tenantId);
        }
        return vo;
    }

    @Override
    public BillCodeRuleVO queryDetailByCodeAndTenantId(String code, Long tenantId) {
        BillCodeRuleVO vo = null;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.eq((Object)"rule_code", (Object)code);
        query.eq((Object)"tenant_id", (Object)this.BASE_TNANT_ID);
        BillCodeRuleEntity entity = (BillCodeRuleEntity)((Object)((BillCodeRuleMapper)this.baseMapper).selectOne((Wrapper)query));
        if (entity != null) {
            vo = (BillCodeRuleVO)BeanMapper.map((Object)((Object)entity), BillCodeRuleVO.class);
            this.queryAttrDetail(vo, tenantId);
        }
        return vo;
    }

    @Override
    public BillCodeRuleVO queryBillCodeDetail(BillCodeParam billCodeParam) {
        BillCodeRuleVO vo = null;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.eq((Object)"rule_code", (Object)billCodeParam.getRuleCode());
        query.eq((Object)"tenant_id", (Object)this.BASE_TNANT_ID);
        BillCodeRuleEntity entity = (BillCodeRuleEntity)((Object)((BillCodeRuleMapper)this.baseMapper).selectOne((Wrapper)query));
        if (entity != null) {
            vo = (BillCodeRuleVO)BeanMapper.map((Object)((Object)entity), BillCodeRuleVO.class);
            this.queryAttrDetail(vo, billCodeParam);
        }
        return vo;
    }
}

