package com.ejianc.foundation.share.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.share.bean.SupplierEntity;
import com.ejianc.foundation.share.service.ISupplierService;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.service.IBillTypeService;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * @author CJ
 * @Description:
 * @date 2020/6/30 15:03
 */
@RestController
@RequestMapping("/api/supplierApi/")
public class SupplierApi {

    @Autowired
    private ISupplierService supplierService;

    @Autowired
    private IBillTypeService billTypeService;

    /**
     * 根据供应商Id查询供应商信息
     *
     * @param id 供应商Id
     * @return
     */
    @GetMapping("queryById")
    CommonResponse<SupplierVO> queryById(@RequestParam(value = "id") Long id) {
        SupplierVO vo = supplierService.queryDetail(id);

        return CommonResponse.success("查询成功！", vo);
    }

    /**
     * 根据供应商Ids查询供应商信息
     *
     * @param ids 供应商Id
     * @return
     */
    @GetMapping("querySupplierByIds")
    CommonResponse<List<SupplierVO>> querySupplierByIds(@RequestParam(value = "ids") List<Long> ids) {
        List<SupplierVO> vos = new ArrayList<>();
        QueryWrapper<SupplierEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr", 0);
        queryWrapper.in("id", ids);
        List<SupplierEntity> entitys = supplierService.list(queryWrapper);
        if(entitys != null){
            vos = BeanMapper.mapList(entitys, SupplierVO.class);
        }
        return CommonResponse.success("查询成功！", vos);
    }

    /**
     * 根据供应商来源Id查询供应商信息
     *
     * @param sourceId 供应商Id
     * @return
     */
    @GetMapping("queryBySourceId")
    CommonResponse<SupplierVO> queryBySourceId(@RequestParam(value = "sourceId") String sourceId){
        QueryWrapper<SupplierEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr", 0);
        queryWrapper.eq("source_id", sourceId);
        List<SupplierEntity> entitys = supplierService.list(queryWrapper);
        if(entitys != null){
            return CommonResponse.success("查询成功！", BeanMapper.map(entitys.get(0), SupplierVO.class));
        }
        return CommonResponse.error("根据来源ID查询供应商失败！");
    }

    /**
     * 新增或者修改
     *
     * @param supplierVo
     * @return
     */
    @RequestMapping(value = "saveOrUpdate", method = RequestMethod.POST)
    public CommonResponse<SupplierVO> saveOrUpdate(@RequestBody SupplierVO supplierVo) {
        if(supplierVo.getCategoryId() == null){
            return CommonResponse.error("供方分类不能为空！");
        }
        JSONObject parent = supplierVo.getParent();
        CommonResponse<SupplierVO> response = supplierService.saveOrUpdate(supplierVo);
        supplierVo = supplierService.queryDetail(response.getData().getId());
        supplierVo.setParent(parent);
        response.setData(supplierVo);
        response.getData().setCategoryName(parent.getString("name"));
        return response;
    }

    /**
     * 删除
     *
     * @param ids
     * @return
     */
    @RequestMapping(value = "delete", method = RequestMethod.POST)
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        if(ListUtil.isNotEmpty(ids)){
            for (Long id : ids) {
                CommonResponse<String>  response = billTypeService.checkQuote("BT200422000000028",id);
                if(!response.isSuccess()){
                    return CommonResponse.error("删除失败："+response.getMsg());
                }
            }
        }else {
            return CommonResponse.error("删除失败：主键为空!");
        }
        supplierService.deleteSupplier(ids);
        return CommonResponse.success("删除成功");
    }
}
