/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.share.service.ISupplierService;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.service.IBillTypeService;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/supplierApi/"})
public class SupplierApi {
    @Autowired
    private ISupplierService supplierService;
    @Autowired
    private IBillTypeService billTypeService;

    @GetMapping(value={"queryById"})
    CommonResponse<SupplierVO> queryById(@RequestParam(value="id") Long id) {
        SupplierVO vo = this.supplierService.queryDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)vo);
    }

    @GetMapping(value={"querySupplierByIds"})
    CommonResponse<List<SupplierVO>> querySupplierByIds(@RequestParam(value="ids") List<Long> ids) {
        List vos = new ArrayList();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.in((Object)"id", ids);
        List entitys = this.supplierService.list((Wrapper)queryWrapper);
        if (entitys != null) {
            vos = BeanMapper.mapList((Iterable)entitys, SupplierVO.class);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", vos);
    }

    @GetMapping(value={"queryBySourceId"})
    CommonResponse<SupplierVO> queryBySourceId(@RequestParam(value="sourceId") String sourceId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.eq((Object)"source_id", (Object)sourceId);
        List entitys = this.supplierService.list((Wrapper)queryWrapper);
        if (entitys != null) {
            return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)BeanMapper.map(entitys.get(0), SupplierVO.class));
        }
        return CommonResponse.error((String)"\u6839\u636e\u6765\u6e90ID\u67e5\u8be2\u4f9b\u5e94\u5546\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"saveOrUpdate"}, method={RequestMethod.POST})
    public CommonResponse<SupplierVO> saveOrUpdate(@RequestBody SupplierVO supplierVo) {
        if (supplierVo.getCategoryId() == null) {
            return CommonResponse.error((String)"\u4f9b\u65b9\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        JSONObject parent = supplierVo.getParent();
        CommonResponse<SupplierVO> response = this.supplierService.saveOrUpdate(supplierVo);
        supplierVo = this.supplierService.queryDetail(((SupplierVO)response.getData()).getId());
        supplierVo.setParent(parent);
        response.setData((Object)supplierVo);
        ((SupplierVO)response.getData()).setCategoryName(parent.getString("name"));
        return response;
    }

    @RequestMapping(value={"delete"}, method={RequestMethod.POST})
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        if (ListUtil.isNotEmpty(ids)) {
            for (Long id : ids) {
                CommonResponse<String> response = this.billTypeService.checkQuote("BT200422000000028", id);
                if (response.isSuccess()) continue;
                return CommonResponse.error((String)("\u5220\u9664\u5931\u8d25\uff1a" + response.getMsg()));
            }
        } else {
            return CommonResponse.error((String)"\u5220\u9664\u5931\u8d25\uff1a\u4e3b\u952e\u4e3a\u7a7a!");
        }
        this.supplierService.deleteSupplier(ids);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }
}

