/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.share.bean.BrandEntity;
import com.ejianc.foundation.share.bean.CategoryBrandEntity;
import com.ejianc.foundation.share.bean.MaterialCategoryEntity;
import com.ejianc.foundation.share.service.IBrandService;
import com.ejianc.foundation.share.service.ICategoryBrandService;
import com.ejianc.foundation.share.service.IMaterialCategoryService;
import com.ejianc.foundation.share.vo.CategoryBrandVO;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"categoryBrand"})
public class CategoryBrandController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICategoryBrandService service;
    @Autowired
    private IMaterialCategoryService materialCategoryService;
    @Autowired
    private IBrandService brandService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CategoryBrandVO> saveOrUpdate(@RequestBody CategoryBrandVO saveOrUpdateVO) {
        CategoryBrandEntity entity = (CategoryBrandEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, CategoryBrandEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        CategoryBrandVO vo = (CategoryBrandVO)BeanMapper.map((Object)((Object)entity), CategoryBrandVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/saveOrUpdateBatch"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<CategoryBrandVO>> saveOrUpdateBatch(@RequestBody List<CategoryBrandVO> saveOrUpdateVOS) {
        ArrayList<CategoryBrandEntity> entities = new ArrayList<CategoryBrandEntity>();
        for (CategoryBrandVO saveOrUpdateVO : saveOrUpdateVOS) {
            LambdaQueryWrapper categoryBrandLambdaQueryWrapper = Wrappers.lambdaQuery();
            categoryBrandLambdaQueryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
            categoryBrandLambdaQueryWrapper.eq(CategoryBrandEntity::getCategoryId, (Object)saveOrUpdateVO.getCategoryId());
            categoryBrandLambdaQueryWrapper.eq(CategoryBrandEntity::getBrandId, (Object)saveOrUpdateVO.getBrandId());
            int count = this.service.count((Wrapper)categoryBrandLambdaQueryWrapper);
            if (count != 0) continue;
            CategoryBrandEntity entity = (CategoryBrandEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, CategoryBrandEntity.class));
            entities.add(entity);
        }
        if (CollectionUtils.isNotEmpty(entities)) {
            this.service.saveBatch(entities);
        }
        List vos = BeanMapper.mapList(entities, CategoryBrandVO.class);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)vos);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CategoryBrandVO> queryDetail(Long id) {
        CategoryBrandEntity entity = (CategoryBrandEntity)((Object)this.service.selectById(id));
        CategoryBrandVO vo = (CategoryBrandVO)BeanMapper.map((Object)((Object)entity), CategoryBrandVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CategoryBrandVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
            LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
            queryWrapper.in(BaseEntity::getId, ids);
            queryWrapper.eq(CategoryBrandEntity::getWhether, (Object)1);
            int cout = this.service.count((Wrapper)queryWrapper);
            if (cout > 0) {
                return CommonResponse.error((String)"\u53ea\u80fd\u5220\u9664\u975e\u5e38\u7528\u54c1\u724c\uff0c\u5982\u9700\u5220\u9664\u8bf7\u53d6\u6d88\u5e38\u7528\u540e\u64cd\u4f5c\uff01");
            }
            this.service.removeByIds(ids);
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/updateWhether"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CategoryBrandVO> updateWhether(Long id, Integer whether) {
        if (id != null) {
            CategoryBrandEntity categoryBrandEntity = (CategoryBrandEntity)((Object)this.service.selectById(id));
            if (whether == 1) {
                LambdaQueryWrapper categoryBrandLambdaQueryWrapper = Wrappers.lambdaQuery();
                categoryBrandLambdaQueryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
                categoryBrandLambdaQueryWrapper.eq(CategoryBrandEntity::getCategoryId, (Object)categoryBrandEntity.getCategoryId());
                categoryBrandLambdaQueryWrapper.eq(CategoryBrandEntity::getWhether, (Object)1);
                categoryBrandLambdaQueryWrapper.ne(BaseEntity::getId, (Object)id);
                List list = this.service.list((Wrapper)categoryBrandLambdaQueryWrapper);
                if (CollectionUtils.isNotEmpty((Collection)list)) {
                    return CommonResponse.error((String)"\u8be5\u5206\u7c7b\u5df2\u8bbe\u7f6e\u5e38\u7528\u54c1\u724c\uff01");
                }
                this.materialCategoryService.updateCategoryBrand(categoryBrandEntity.getCategoryId(), categoryBrandEntity.getBrandId(), categoryBrandEntity.getBrandName());
            } else {
                this.materialCategoryService.updateCategoryBrand(categoryBrandEntity.getCategoryId(), null, null);
            }
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)id);
            updateWrapper.set(CategoryBrandEntity::getWhether, (Object)whether);
            this.service.update((Wrapper)updateWrapper);
        }
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<CategoryBrandVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("whether", "desc");
        param.getOrderMap().put("categoryId", "asc");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CategoryBrandVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryListByCategoryId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<CategoryBrandVO>> queryListByCategoryId(Long categoryId) {
        MaterialCategoryVO categoryVO;
        List vos = new ArrayList();
        if (categoryId != null && (categoryVO = this.materialCategoryService.queryDetail(categoryId)) != null) {
            String innerCode = categoryVO.getInnerCode();
            String[] innerCodes = innerCode.split("\\|");
            List categoryIds = Arrays.stream(innerCodes).map(Long::valueOf).collect(Collectors.toList());
            LambdaQueryWrapper categoryBrandLambdaQueryWrapper = Wrappers.lambdaQuery();
            categoryBrandLambdaQueryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
            categoryBrandLambdaQueryWrapper.in(CategoryBrandEntity::getCategoryId, categoryIds);
            categoryBrandLambdaQueryWrapper.orderByDesc(CategoryBrandEntity::getWhether);
            List list = this.service.list((Wrapper)categoryBrandLambdaQueryWrapper);
            vos = BeanMapper.mapList((Iterable)list, CategoryBrandVO.class);
            if (CollectionUtils.isNotEmpty(vos)) {
                for (CategoryBrandVO categoryBrandVO : vos) {
                    categoryBrandVO.setId(categoryBrandVO.getBrandId());
                    categoryBrandVO.setName(categoryBrandVO.getBrandName());
                }
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", vos);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getOrderMap().put("whether", "desc");
        param.getOrderMap().put("categoryId", "asc");
        List list = this.service.queryList(param);
        List categoryBrandVOS = BeanMapper.mapList((Iterable)list, CategoryBrandVO.class);
        for (CategoryBrandVO vo : categoryBrandVOS) {
            switch (vo.getWhether()) {
                case 0: {
                    vo.setWhetherName("\u5426");
                    break;
                }
                case 1: {
                    vo.setWhetherName("\u662f");
                }
            }
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", categoryBrandVOS);
        ExcelExport.getInstance().export("CategoryBrand-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/downloadTemplet"})
    @ResponseBody
    public void downloadTemplet(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"CategoryBrand-import.xlsx", (String)"\u5bfc\u5165\u5206\u7c7b\u54c1\u724c\u5173\u7cfb");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        ArrayList<CategoryBrandVO> successList = new ArrayList<CategoryBrandVO>();
        ArrayList<CategoryBrandVO> errorList = new ArrayList<CategoryBrandVO>();
        if (result != null && result.size() > 0 && ((List)result.get(0)).size() != 4) {
            throw new BusinessException("\u8bf7\u6309\u7167\u5bfc\u5165\u6a21\u677f\u5bfc\u5165\u6570\u636e");
        }
        HashMap<Long, Long> useBrandMap = new HashMap<Long, Long>();
        for (int i = 0; i < result.size(); ++i) {
            int count;
            String brandCode;
            List row = (List)result.get(i);
            StringBuilder errMsg = new StringBuilder();
            CategoryBrandVO categoryBrandVO = new CategoryBrandVO();
            String categoryCode = ((String)row.get(0)).trim();
            if (StringUtils.isNotBlank((CharSequence)categoryCode)) {
                List<MaterialCategoryEntity> materialCategoryEntities = this.materialCategoryService.queryByCode(categoryCode);
                if (CollectionUtils.isEmpty(materialCategoryEntities)) {
                    errMsg.append("`\u5206\u7c7b\u7f16\u7801\u4e0d\u5b58\u5728`");
                } else {
                    MaterialCategoryEntity categoryEntity = materialCategoryEntities.get(0);
                    categoryBrandVO.setCategoryId(categoryEntity.getId());
                    categoryBrandVO.setInnerCode(categoryEntity.getInnerCode());
                    categoryBrandVO.setCategoryName(categoryEntity.getName());
                }
                categoryBrandVO.setCategoryCode(categoryCode);
            } else {
                errMsg.append("`\u5206\u7c7b\u7f16\u7801\u672a\u586b\u5199`");
            }
            String brandName = ((String)row.get(2)).trim();
            if (StringUtils.isNotBlank((CharSequence)brandName)) {
                categoryBrandVO.setBrandName(brandName);
            }
            if (StringUtils.isNotBlank((CharSequence)(brandCode = ((String)row.get(1)).trim()))) {
                LambdaQueryWrapper brandLambdaQueryWrapper = Wrappers.lambdaQuery();
                brandLambdaQueryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
                brandLambdaQueryWrapper.eq(BrandEntity::getBrandCode, (Object)brandCode);
                List list = this.brandService.list((Wrapper)brandLambdaQueryWrapper);
                if (CollectionUtils.isEmpty((Collection)list)) {
                    errMsg.append("`\u54c1\u724c\u7f16\u7801\u4e0d\u5b58\u5728`");
                } else {
                    BrandEntity brandEntity = (BrandEntity)((Object)list.get(0));
                    categoryBrandVO.setBrandId(brandEntity.getId());
                    categoryBrandVO.setBrandName(brandEntity.getBrandName());
                }
                categoryBrandVO.setBrandCode(brandCode);
            } else {
                errMsg.append("`\u54c1\u724c\u7f16\u7801\u672a\u586b\u5199`");
            }
            String whetherName = ((String)row.get(3)).trim();
            Long categoryId = categoryBrandVO.getCategoryId();
            Long brandId = categoryBrandVO.getBrandId();
            if (StringUtils.isNotBlank((CharSequence)whetherName)) {
                if ("\u662f".equals(whetherName)) {
                    categoryBrandVO.setWhether(Integer.valueOf(1));
                    if (categoryId != null && brandId != null) {
                        if (useBrandMap.containsKey(categoryId)) {
                            errMsg.append("`\u5206\u7c7b\u53ea\u80fd\u8bbe\u7f6e\u4e00\u4e2a\u5e38\u7528\u54c1\u724c`");
                        } else {
                            useBrandMap.put(categoryId, brandId);
                        }
                        LambdaQueryWrapper categoryBrandLambdaQueryWrapper = Wrappers.lambdaQuery();
                        categoryBrandLambdaQueryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
                        categoryBrandLambdaQueryWrapper.eq(CategoryBrandEntity::getCategoryId, (Object)categoryId);
                        categoryBrandLambdaQueryWrapper.ne(CategoryBrandEntity::getBrandId, (Object)brandId);
                        categoryBrandLambdaQueryWrapper.eq(CategoryBrandEntity::getWhether, (Object)1);
                        count = this.service.count((Wrapper)categoryBrandLambdaQueryWrapper);
                        if (count > 0) {
                            errMsg.append("`\u8be5\u5206\u7c7b\u5df2\u8bbe\u7f6e\u5e38\u7528\u54c1\u724c`");
                        }
                    }
                } else {
                    categoryBrandVO.setWhether(Integer.valueOf(0));
                }
                categoryBrandVO.setWhetherName(whetherName);
            } else {
                errMsg.append("`\u662f\u5426\u5e38\u7528\u54c1\u724c\u672a\u586b\u5199`");
            }
            if (categoryId != null && brandId != null) {
                LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
                lambdaQueryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
                lambdaQueryWrapper.eq(CategoryBrandEntity::getCategoryId, (Object)categoryId);
                lambdaQueryWrapper.eq(CategoryBrandEntity::getBrandId, (Object)brandId);
                count = this.service.count((Wrapper)lambdaQueryWrapper);
                if (count > 0) {
                    errMsg.append("`\u8be5\u5206\u7c7b\u54c1\u724c\u5173\u7cfb\u5df2\u5b58\u5728`");
                }
            }
            categoryBrandVO.setErrMsg(errMsg.toString());
            if (StringUtils.isNotBlank((CharSequence)categoryBrandVO.getErrMsg())) {
                categoryBrandVO.setId(Long.valueOf(i));
                errorList.add(categoryBrandVO);
                continue;
            }
            successList.add(categoryBrandVO);
        }
        JSONObject json = new JSONObject();
        json.put("successList", (Object)BeanMapper.mapList(successList, CategoryBrandVO.class));
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/saveImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveImport(@RequestBody List<CategoryBrandVO> accbookVOS) {
        List entityList;
        List categoryBrandEntityList = BeanMapper.mapList(accbookVOS, CategoryBrandEntity.class);
        boolean b = this.service.saveBatch(categoryBrandEntityList);
        if (b && CollectionUtils.isNotEmpty(entityList = categoryBrandEntityList.stream().filter(t -> t.getWhether().equals(1)).collect(Collectors.toList()))) {
            for (CategoryBrandEntity categoryBrand : entityList) {
                this.materialCategoryService.updateCategoryBrand(categoryBrand.getCategoryId(), categoryBrand.getBrandId(), categoryBrand.getBrandName());
            }
        }
        return CommonResponse.success((String)"\u5bfc\u5165\u6210\u529f");
    }

    @RequestMapping(value={"/refCategoryBrandData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<CategoryBrandVO>> refCategoryBrandData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CategoryBrandVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

