/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.billcode;

import com.ejianc.foundation.billcode.BillCodeException;
import com.ejianc.foundation.billcode.BillCodeGeneratorNeedAddTransaction;
import com.ejianc.foundation.billcode.elemproc.BillCodeElemProcEngine;
import com.ejianc.foundation.billcode.elemproc.result.BillCodeElemInfo;
import com.ejianc.foundation.billcode.elemproc.result.BillCodeInfo;
import com.ejianc.foundation.billcode.engine.BillCodeEngine;
import com.ejianc.foundation.billcode.engine.BillcodeSNReferProducer;
import com.ejianc.foundation.billcode.engine.persistence.IBillCodeEngineService;
import com.ejianc.foundation.billcode.lock.IBillCodeEngineLock;
import com.ejianc.foundation.billcode.model.BillCodeBillVO;
import com.ejianc.foundation.support.vo.BillCodeRuleVO;
import com.ejianc.framework.cache.redis.CacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public abstract class AbstractBillCodeProvider {
    private Logger logger = LoggerFactory.getLogger(AbstractBillCodeProvider.class);
    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private BillcodeSNReferProducer billcodeSNReferProducer;

    protected abstract IBillCodeEngineLock getBillCodeEngineLock();

    protected abstract IBillCodeEngineService getBillcodePesisServ();

    protected abstract BillCodeGeneratorNeedAddTransaction getBillCodeGenerator();

    public String getBillCode(BillCodeRuleVO rulevo, BillCodeBillVO billvo, BillCodeElemInfo externalElemInfo, Object randomCodePara, Long tenantId) throws BillCodeException {
        return this.getBatchBillCodes(rulevo, billvo, externalElemInfo, randomCodePara, 1, tenantId)[0];
    }

    public String[] getBillCode(BillCodeRuleVO rulevo, BillCodeBillVO billvo, BillCodeElemInfo externalElemInfo, Object randomCodePara, int count, Long tenantId) throws BillCodeException {
        return this.getBatchBillCodes(rulevo, billvo, externalElemInfo, randomCodePara, count, tenantId);
    }

    private String[] getBatchBillCodes(BillCodeRuleVO rulevo, BillCodeBillVO billvo, BillCodeElemInfo externalElemInfo, Object randomCodePara, int num, Long tenantId) throws BillCodeException {
        String[] billCode;
        block9: {
            if (null == rulevo) {
                return null;
            }
            billCode = null;
            BillCodeEngine engine = this.getBillcodeEngine(rulevo, billvo, externalElemInfo);
            IBillCodeEngineLock lock = this.getBillCodeEngineLock();
            boolean locked = false;
            if (2 == lock.getEngineLockType()) {
                try {
                    long start = System.currentTimeMillis();
                    locked = lock.lock(engine.getInfo().getPk_bilcodebase(), engine.getInfo().getBillCodeSNRefer(), tenantId);
                    long end = System.currentTimeMillis();
                    this.logger.info(Thread.currentThread().getId() + "xxxxxx\u52a0\u9501\u8017\u65f6" + (end - start));
                    if (locked) {
                        billCode = this.getBillCodeGenerator().getBillCode(engine, lock, num, false, tenantId);
                        this.logger.info(Thread.currentThread().getId() + "xxxxxxx\u5355\u636e\u53f7\u83b7\u53d6" + (System.currentTimeMillis() - end));
                        break block9;
                    }
                    this.logger.info(Thread.currentThread().getId() + "\u5355\u636e\u53f7\u52a0\u9501\u5931\u8d25\uff0c\u53ef\u80fd\u662f\u5e76\u53d1\u8fc7\u5927");
                    throw new BillCodeException(Thread.currentThread().getId() + "\u5355\u636e\u53f7\u52a0\u9501\u5931\u8d25\uff0c\u53ef\u80fd\u662f\u5e76\u53d1\u8fc7\u5927\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
                }
                catch (BillCodeException e) {
                    this.logger.error("\u751f\u6210\u5355\u636e\u7f16\u7801\u51fa\u9519", (Throwable)e);
                    throw new BillCodeException(e.getMessage());
                }
                finally {
                    if (locked) {
                        long start = System.currentTimeMillis();
                        lock.unlock(engine.getInfo().getPk_bilcodebase(), engine.getInfo().getBillCodeSNRefer(), tenantId);
                        long end = System.currentTimeMillis();
                        this.logger.info(Thread.currentThread().getId() + "xxxxxx\u89e3\u9501\u8017\u65f6" + (end - start));
                    }
                }
            }
            billCode = this.getBillCodeGenerator().getBillCode(engine, lock, num, false, tenantId);
        }
        return billCode;
    }

    private BillCodeEngine getBillcodeEngine(BillCodeRuleVO rulevo, BillCodeBillVO billvo, BillCodeElemInfo externalElemInfo) throws BillCodeException {
        BillCodeInfo info = new BillCodeInfo(externalElemInfo);
        BillCodeElemProcEngine elemEngine = BillCodeElemProcEngine.getInstance();
        BillCodeInfo innerInfo = elemEngine.procElems(rulevo, billvo);
        info.addBillCodeInfo(innerInfo);
        info.setSerialNumInfo(innerInfo.getSerialNumInfo());
        info.setSysDateRefInfos(innerInfo.getSysDateRefInfos());
        info.setPk_bilcodebase(rulevo.getId().toString());
        info.setIsautofill(true);
        info.getSerialNumInfo().setAppendZero(true);
        return new BillCodeEngine(info, this.getBillcodePesisServ(), this.cacheManager, this.billcodeSNReferProducer);
    }
}

