/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.support.controller.api;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.support.bean.BillTypeEntity;
import com.ejianc.foundation.support.bean.ModuleEntity;
import com.ejianc.foundation.support.service.IBillTypeService;
import com.ejianc.foundation.support.service.IModuleService;
import com.ejianc.foundation.support.vo.ModuleVO;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.cache.serializer.Serializer;
import com.ejianc.framework.cache.serializer.impl.DefaultJDKSerializer;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/module/"})
public class ModuleApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String MODEL_CACHE_KEY = "model_cache_key:";
    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private IModuleService moduleService;
    @Autowired
    private IBillTypeService billTypeService;
    public static final String DEFAULT_CHARSET = "UTF-8";
    @Value(value="${oms.tenantid}")
    private Long omsTenantId;
    private Serializer serializer = new DefaultJDKSerializer();

    @RequestMapping(value={"getListByPid"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<ModuleVO>> queryModuleListByPid(@RequestParam(value="moduleId", required=true) Long moduleId) {
        try {
            List<ModuleVO> moduleList = this.moduleService.queryAllChildrenByPid(moduleId);
            return CommonResponse.success(moduleList);
        }
        catch (Exception e) {
            this.logger.error("\u7cfb\u7edf\u5f02\u5e38\uff1a" + e.getMessage());
            e.printStackTrace();
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25");
        }
    }

    @RequestMapping(value={"getModuleById"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ModuleVO> getModuleById(@RequestParam(value="moduleId", required=true) Long moduleId) {
        try {
            ModuleEntity moduleEntity = (ModuleEntity)((Object)this.moduleService.selectById(moduleId));
            if (moduleEntity != null) {
                ModuleVO moduleVO = (ModuleVO)BeanMapper.map((Object)((Object)moduleEntity), ModuleVO.class);
                return CommonResponse.success((Object)moduleVO);
            }
        }
        catch (Exception e) {
            this.logger.error("\u7cfb\u7edf\u5f02\u5e38\uff1a" + e.getMessage());
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25");
        }
        return CommonResponse.success();
    }

    @PostMapping(value={"refreshModuleCache"})
    public CommonResponse<String> refreshModuleCache() {
        try {
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)this.omsTenantId));
            queryParam.getParams().put("dr", new Parameter("eq", (Object)BaseVO.DR_UNDELETE));
            queryParam.getOrderMap().put("sequence", "asc");
            List moduleList = this.moduleService.queryList(queryParam, false);
            if (!moduleList.isEmpty()) {
                this.cacheManager.piplineExecute(pipeline -> {
                    String key = MODEL_CACHE_KEY + this.omsTenantId;
                    pipeline.multi();
                    for (ModuleEntity m : moduleList) {
                        byte[] keyBytes = key.getBytes(Charset.forName(DEFAULT_CHARSET));
                        byte[] fieldBytes = m.getId().toString().getBytes(Charset.forName(DEFAULT_CHARSET));
                        byte[] contentBytes = this.serializer.marshalToByte((Serializable)((Object)JSON.toJSONString((Object)((Object)m))));
                        pipeline.hset(keyBytes, fieldBytes, contentBytes);
                    }
                    pipeline.exec();
                });
            }
            return CommonResponse.success((String)"\u6a21\u5757\u7f13\u5b58\u5237\u65b0\u6210\u529f\uff01");
        }
        catch (Exception e) {
            this.logger.error("\u7cfb\u7edf\u5f02\u5e38\uff1a", (Throwable)e);
            return CommonResponse.error((String)"\u6a21\u5757\u7f13\u5b58\u5237\u65b0\u5931\u8d25");
        }
    }

    @RequestMapping(value={"queryModuleTree"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<ModuleVO>> queryModuleTree() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"tenant_id", (Object)999999L);
        List moduleList = this.moduleService.list((Wrapper)queryWrapper);
        List<BillTypeEntity> billTypeEntities = this.billTypeService.queryAllBillTypeList();
        if (billTypeEntities != null && billTypeEntities.size() > 0) {
            for (BillTypeEntity billTypeEntity : billTypeEntities) {
                ModuleEntity moduleEntity = new ModuleEntity();
                moduleEntity.setId(billTypeEntity.getId());
                moduleEntity.setModuleCode(billTypeEntity.getBillCode());
                moduleEntity.setModuleName(billTypeEntity.getBillName());
                moduleEntity.setParentId(billTypeEntity.getModuleId());
                moduleList.add(moduleEntity);
            }
        }
        List moduleVoList = BeanMapper.mapList((Iterable)moduleList, ModuleVO.class);
        return CommonResponse.success((Object)moduleVoList);
    }

    @RequestMapping(value={"queryAllTopModuleList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<ModuleVO>> queryAllTopModuleList() {
        List<ModuleVO> moduleList = this.moduleService.queryAllTopModuleList();
        return CommonResponse.success(moduleList);
    }

    @GetMapping(value={"queryModuleListByName"})
    @ResponseBody
    public CommonResponse<List<ModuleVO>> queryModuleListByName(@RequestParam(value="name", required=true) String name) {
        QueryParam param = new QueryParam();
        param.setSearchText(name);
        param.getFuzzyFields().add("moduleName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)999999L));
        List moduleList = this.moduleService.queryList(param, false);
        if (ListUtil.isEmpty((List)moduleList)) {
            return CommonResponse.success(new ArrayList());
        }
        return CommonResponse.success((Object)BeanMapper.mapList((Iterable)moduleList, ModuleVO.class));
    }
}

