package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.share.bean.CustomerCategoryEntity;
import com.ejianc.foundation.share.bean.CustomerEntity;
import com.ejianc.foundation.share.bean.SupplierCategoryEntity;
import com.ejianc.foundation.share.bean.SupplierEntity;
import com.ejianc.foundation.share.service.ICustomerCategoryService;
import com.ejianc.foundation.share.service.ICustomerService;
import com.ejianc.foundation.share.service.ISupplierCategoryService;
import com.ejianc.foundation.share.service.ISupplierService;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.kit.time.DateUtil;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import java.util.*;

/**
 *
 * 南昌中奥，客户供应商主数据同步接口
 *
 * */


@RestController
@RequestMapping("/zatop/mdm/")
public class ZatopMdmController {
	private final Logger logger = LoggerFactory.getLogger(getClass());

	@Autowired
	private ISupplierCategoryService supplierCategoryService;
	@Autowired
	private ISupplierService supplierService;
	@Autowired
	private ICustomerCategoryService customerCategoryService;
	@Autowired
	private ICustomerService customerService;

	@Value("${zatop.cn.url:http://md.zatop.cn/service/datapub}")
	private String zatopMdmUrl;
	@Value("${zatop.cn.appKey:web}")
	private String appKey;
	@Value("${zatop.cn.appSecret:web}")
	private String appSecret;

	private static Map<String,String> header = null;

	/**
	 * 法人组织同步--->生成内部客户和内部供应商
	 *
	 * {
	 *     "code": "2000",
	 *     "data": {
	 *         "content": [
	 *             {
	 *                 "id": "DQAbwfAJxJQawnMoMsxBnF",
	 *                 "legalorg_code": "ZLC000001",
	 *                 "legalorg_name": "无锡奥卓置业有限公司",
	 *                 "adm_org_code": "ZA000236",
	 *                 "adm_org_name": "苏南区域",
	 *                 "unified_social_credit_code": "91320281MA20UT6W39",
	 *                 "current_legal_representative": "任玉玲",
	 *                 "director": "任玉玲",
	 *                 "general_manager": "任玉玲",
	 *                 "supervisor": "黄美英",
	 *                 "registered_date": "2020-01-21",
	 *                 "registered_capital": "10102万元人民币",
	 *                 "registered_address": "江阴市徐霞客镇璜塘环东路275号",
	 *                 "legal_right": "100.00",
	 *                 "ownership_ratio": "",
	 *                 "business_term": "",
	 *                 "business_scope": "房地产开发经营；建筑装修装饰工程、园林绿化工程的设计、施工；物业管理。",
	 *                 "correspondence": "天悦湾项目",
	 *                 "other": "{\"stringValue\":\"\",\"value\":\"\"}",
	 *                 "seal_zhongao": "顾燕",
	 *                 "seal_code_zhongao": "guy",
	 *                 "seal_cooperation": "",
	 *                 "seal_code_cooperation": "",
	 *                 "legalorg_status": "有效",
	 *                 "legalorg_status_name": "",
	 *                 "check_computation": "",
	 *                 "check_computation_name": "",
	 *                 "approval_document": "{\"stringValue\":\"\",\"value\":\"\"}",
	 *                 "adm_org": "ZA000236",
	 *                 "dver_type": "2",
	 *                 "data_status": "0",
	 *                 "created_date": "2021-12-13 10:23:46",
	 *                 "updated_date": "2022-01-06 16:53:31",
	 *                 "data_version": "3"
	 *             }
	 *         ],
	 *         "pageNum": 1,
	 *         "pageSize": 1,
	 *         "totalElements": 262,
	 *         "pages": 262
	 *     }
	 * }
	 *
	 * */
	@GetMapping(value = "/innerSupplierAndCustomer/sync")
	@ResponseBody
	public String syncInnerSupplierAndCustomer(){
		String host = zatopMdmUrl+"/rest/api/v1/hcm/legalcompList";
		JSONObject params = new JSONObject();
		try {
			Integer pageNum = 1;
			params.put("dver_type",2);//最新版本
			params.put("pageNum",pageNum);//页码
			params.put("pageSize",100);//每页条数
			/** 最近三天更新的数据 */
//			params.put("updated_date", DateFormatUtil.formatDate(DateFormatUtil.PATTERN_DEFAULT_ON_SECOND,DateUtil.subDays(new Date(),7)));
			boolean has = true;
			String resStr;
			Integer pages;
			JSONObject resJson;
			JSONObject data;
			JSONArray content;
			while (has){
				resStr = HttpTookit.postByJson(host,params.toJSONString(),getHeader(),50,50);
				if(StringUtils.isEmpty(resStr)){
					logger.info("南昌中奥，法人组织同步，while请求--{}，参数--{}，响应为空！",host,JSONObject.toJSONString(params));
					has = false;
				}else {
					resJson = JSONObject.parseObject(resStr);
					if(resJson.getInteger("code") == 2000){
						data = resJson.getJSONObject("data");
						pages = data.getInteger("pages");
						content = data.getJSONArray("content");
						if(pageNum>=pages){
							has=false;
						}else {
							pageNum++;
							params.put("pageNum",pageNum);//页码
						}
						saveOrUpdateSupplierAndCustomer(content);
					}else {
						has = false;
						logger.info("南昌中奥，法人组织同步，while请求--{}，参数--{}，响应失败--{}",host,JSONObject.toJSONString(params),resStr);
					}
				}
			}
		}catch (Exception e){
			logger.info("南昌中奥，法人组织同步，请求--{},参数--{}，出错--{}",host,params.toJSONString(),e.getMessage());
		}
		return "同步成功！";
	}


	private void saveOrUpdateSupplierAndCustomer(JSONArray positionArr){
		if(positionArr!=null && positionArr.size()>0){
			QueryParam param = new QueryParam();

			/** 先查询内部供应商分类是否存在 ，不存在则新增一个内部供应商分类*/
			param.getParams().put("code",new Parameter(QueryParam.EQ,"Inner-Supplier"));
			param.getParams().put("tenantId",new Parameter(QueryParam.EQ,888888L));
			List<SupplierCategoryEntity> supplierCategoryEntities = supplierCategoryService.queryList(param,false);
			SupplierCategoryEntity supplierCategoryEntity ;
			if(ListUtil.isEmpty(supplierCategoryEntities)){
				supplierCategoryEntity = new SupplierCategoryEntity();
				supplierCategoryEntity.setId(IdWorker.getId());
				supplierCategoryEntity.setCode("Inner-Supplier");
				supplierCategoryEntity.setTenantId(888888L);
				supplierCategoryEntity.setDescription("内部供应商分类，系统自动生成！");
				supplierCategoryEntity.setName("内部供应商");
				supplierCategoryEntity.setInnerCode(supplierCategoryEntity.getId().toString());
				supplierCategoryEntity.setSequence(0);
				supplierCategoryService.saveOrUpdate(supplierCategoryEntity);
			}else {
				supplierCategoryEntity = supplierCategoryEntities.get(0);
			}
			/** 再查询内部客户分类是否存在 ，不存在则新增一个内部客户分类*/
			param.getParams().put("code",new Parameter(QueryParam.EQ,"Inner-Customer"));
			List<CustomerCategoryEntity> customerCategoryEntities = customerCategoryService.queryList(param,false);
			CustomerCategoryEntity customerCategoryEntity ;
			if(ListUtil.isEmpty(customerCategoryEntities)){
				customerCategoryEntity = new CustomerCategoryEntity();
				customerCategoryEntity.setId(IdWorker.getId());
				customerCategoryEntity.setCode("Inner-Customer");
				customerCategoryEntity.setTenantId(888888L);
				customerCategoryEntity.setDescription("内部客户分类，系统自动生成！");
				customerCategoryEntity.setName("内部客户");
				customerCategoryEntity.setInnerCode(supplierCategoryEntity.getId().toString());
				customerCategoryEntity.setSequence(0);
				customerCategoryService.saveOrUpdate(customerCategoryEntity);
			}else {
				customerCategoryEntity = customerCategoryEntities.get(0);
			}

			for (Object o : positionArr) {
				JSONObject object = (JSONObject)o;
				param = new QueryParam();
				param.getParams().put("sourceId",new Parameter(QueryParam.EQ,object.getString("id")));
				List<SupplierEntity> supplierEntities = supplierService.queryList(param,false);
				SupplierEntity supplierEntity;
				if(ListUtil.isEmpty(supplierEntities)){
					supplierEntity = new SupplierEntity();
					supplierEntity.setTenantId(888888L);
					supplierEntity.setSourceId(object.getString("id"));
					supplierEntity.setCategoryId(supplierCategoryEntity.getId());
					supplierEntity.setName(object.getString("legalorg_name"));
					supplierEntity.setCode(object.getString("legalorg_code"));
					supplierEntity.setCategoryName(supplierCategoryEntity.getName());
					supplierEntity.setSocialCreditCode(object.getString("unified_social_credit_code"));
					supplierEntity.setLegal(object.getString("current_legal_representative"));
					supplierEntity.setBusinessScope(object.getString("business_scope"));
					supplierEntity.setEnabled(object.getInteger("data_status")==0?1:0);
					supplierEntity.setDescription("主数据同步生成！");
				} else {
					supplierEntity = supplierEntities.get(0);
					supplierEntity.setName(object.getString("legalorg_name"));
					supplierEntity.setCode(object.getString("legalorg_code"));
					supplierEntity.setSocialCreditCode(object.getString("unified_social_credit_code"));
					supplierEntity.setLegal(object.getString("current_legal_representative"));
					supplierEntity.setBusinessScope(object.getString("business_scope"));
					supplierEntity.setEnabled(object.getInteger("data_status")==0?1:0);
				}
				supplierService.saveOrUpdate(supplierEntity,false);

				List<CustomerEntity> customerEntities = customerService.queryList(param,false);
				CustomerEntity customerEntity;
				if(ListUtil.isEmpty(customerEntities)){
					customerEntity = new CustomerEntity();
					customerEntity.setTenantId(888888L);
					customerEntity.setCategoryId(customerCategoryEntity.getId());
					customerEntity.setSourceId(object.getString("id"));
					customerEntity.setName(object.getString("legalorg_name"));
					customerEntity.setCode(object.getString("legalorg_code"));
					customerEntity.setCategoryName(customerCategoryEntity.getName());
					customerEntity.setSocialCreditCode(object.getString("unified_social_credit_code"));
					customerEntity.setLegal(object.getString("current_legal_representative"));
					customerEntity.setDescription("主数据同步生成！");
				} else {
					customerEntity = customerEntities.get(0);
					customerEntity.setName(object.getString("legalorg_name"));
					customerEntity.setCode(object.getString("legalorg_code"));
					customerEntity.setSocialCreditCode(object.getString("unified_social_credit_code"));
					customerEntity.setLegal(object.getString("current_legal_representative"));
				}
				customerService.saveOrUpdate(customerEntity,false);
			}
		}
	}

	private synchronized Map<String,String> getHeader(){
		if(header == null){
			header = new HashMap<>();
			header.put("appKey",appKey);
			header.put("appSecret",appSecret);
		}
		return header;
	}

}
