package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.billcode.BillCodeException;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.bean.MaterialAuditEntity;
import com.ejianc.foundation.share.bean.MaterialCategoryEntity;
import com.ejianc.foundation.share.service.IMaterialAuditService;
import com.ejianc.foundation.share.service.IMaterialCategoryService;
import com.ejianc.foundation.share.service.IMaterialService;
import com.ejianc.foundation.share.vo.MaterialAuditDetailVO;
import com.ejianc.foundation.share.vo.MaterialAuditVO;
import com.ejianc.foundation.share.vo.MaterialImportVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.service.IBillCodeGenerator;
import com.ejianc.foundation.support.service.IBillTypeService;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 物料审核
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("materialAudit")
public class MaterialAuditController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IMaterialAuditService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IMaterialService materialService;

    @Autowired
    private IBillTypeService billTypeService;

    @Autowired
    private IMaterialCategoryService materialCategoryService;
    @Autowired
    private IBillCodeGenerator generator;

    private static final String MATERIAL_AUDIT_BILL_CODE = "SUPPORT_MATERIAL_AUDIT";

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<MaterialAuditVO> saveOrUpdate(@RequestBody MaterialAuditVO auditVO) throws BillCodeException {
        List<MaterialAuditDetailVO> materialAuditDetailList = auditVO.getMaterialAuditDetailList();
        List<String> materialNames = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(materialAuditDetailList)) {
            if ("新增".equals(auditVO.getOptFlag())) {
                Map<String, MaterialAuditDetailVO> distinctCodeMap = new HashMap<>();
                for (MaterialAuditDetailVO materialVo : materialAuditDetailList) {
                    if (!"del".equals(materialVo.getRowState())) {
                        String code = materialVo.getCode();
                        if (distinctCodeMap.containsKey(code)) {
                            throw new BusinessException("该单据明细中物料编码【" + code + "】重复！");
                        } else {
                            distinctCodeMap.put(code, materialVo);
                        }
                        MaterialVO materialBean = materialService.queryExitFlag(materialVo.getName(), materialVo.getSpec(), materialVo.getUnitName(), materialVo.getCategoryId());
                        if (materialBean != null) {
                            throw new BusinessException("该物料编码【" + code + "】在物料档案分类【" + materialVo.getCategoryName() + "】下已经有相同名称、单位、规格型号的物料！");
                        }
                        if (StringUtils.isNotBlank(code)) {
                            MaterialVO codeData = materialService.queryByCode(code);
                            if (codeData != null) {
                                throw new BusinessException("该物料编码【" + code + "】在物料档案中已存在！");
                            }
                        }
                    }
                }
            }
            // 生成物料需要预置物料id
            for (MaterialAuditDetailVO materialAuditDetailVO : materialAuditDetailList) {
                if (!"del".equals(materialAuditDetailVO.getRowState())) {
                    if (materialAuditDetailVO.getMaterialId() == null) {
                        materialAuditDetailVO.setMaterialId(IdWorker.getId());
                    }
                    materialNames.add(materialAuditDetailVO.getName());
                }
            }
        }

        if (CollectionUtils.isNotEmpty(materialNames)) {
            auditVO.setMaterialNames(StringUtils.join(materialNames, "、"));
        } else {
            auditVO.setMaterialNames(null);
        }
        if (StringUtils.isBlank(auditVO.getBillCode())) {
            String billCode = generator.generateBillCodeById(MATERIAL_AUDIT_BILL_CODE, InvocationInfoProxy.getTenantid());
            auditVO.setBillCode(billCode);
        }
        MaterialAuditEntity entity = BeanMapper.map(auditVO, MaterialAuditEntity.class);
        service.saveOrUpdate(entity, false);
        MaterialAuditVO vo = BeanMapper.map(entity, MaterialAuditVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MaterialAuditVO> queryDetail(Long id) {
        MaterialAuditEntity entity = service.selectById(id);
        MaterialAuditVO vo = BeanMapper.map(entity, MaterialAuditVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MaterialAuditVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (MaterialAuditVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(MaterialAuditVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MaterialAuditVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode", "theme", "materialNames", "employeeName"));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        IPage<MaterialAuditEntity> page = service.queryPage(param, false);
        IPage<MaterialAuditVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MaterialAuditVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode", "theme", "materialNames", "employeeName"));
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<MaterialAuditEntity> list = service.queryList(param);
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().exportWithTrans("MaterialAudit-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refMaterialAuditData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<MaterialAuditVO>> refMaterialAuditData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                       String condition,
                                                                       String searchObject,
                                                                       String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<MaterialAuditEntity> page = service.queryPage(param, false);
        IPage<MaterialAuditVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MaterialAuditVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }


}
