/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.billcode.BillCodeException;
import com.ejianc.foundation.share.bean.MaterialCategoryEntity;
import com.ejianc.foundation.share.bean.MaterialEntity;
import com.ejianc.foundation.share.enums.MaterialFuzzyMatchEnum;
import com.ejianc.foundation.share.mapper.MaterialCategoryMapper;
import com.ejianc.foundation.share.mapper.MaterialMapper;
import com.ejianc.foundation.share.service.IMaterialService;
import com.ejianc.foundation.share.util.PSRMMethodConsts;
import com.ejianc.foundation.share.util.PSRMResponse;
import com.ejianc.foundation.share.util.PSRMRestUtil;
import com.ejianc.foundation.share.vo.MaterialFuzzyMatchVO;
import com.ejianc.foundation.share.vo.MaterialPlusVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.service.IBillCodeGenerator;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.CommonUpdateBillStateService;
import com.ejianc.support.idworker.util.IdWorker;
import com.google.common.base.Stopwatch;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class MaterialServiceImpl
implements IMaterialService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private MaterialMapper materialMapper;
    @Autowired
    private MaterialCategoryMapper materialCategoryMapper;
    @Autowired
    private IParamConfigApi paramConfigApi;
    private static final ExecutorService executorService = new ThreadPoolExecutor(8, 8, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingDeque<Runnable>(1024), (ThreadFactory)new CustomizableThreadFactory("fuzzyMatch-pool-"), new ThreadPoolExecutor.AbortPolicy());
    private static final String MATERIAL_BILL_CODE = "SUPPORT_MATERIAL";
    private static final String EQUIPMENT_BILL_CODE = "SUPPORT_EQUIPMENT";
    @Autowired
    private IBillCodeGenerator generator;
    @Autowired
    private CommonUpdateBillStateService commonUpdateBillStateService;
    @Autowired
    private PSRMRestUtil psrmRestUtil;

    @Override
    public List<MaterialVO> queryListByCategoryId(Long categoryId) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<MaterialEntity> entities = this.materialMapper.queryListByCategoryId(tenantId, categoryId);
        if (entities != null && entities.size() > 0) {
            return BeanMapper.mapList(entities, MaterialVO.class);
        }
        return null;
    }

    @Override
    public MaterialVO queryDetail(Long id) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MaterialEntity entity = this.materialMapper.queryDetail(tenantId, id);
        if (entity != null) {
            return (MaterialVO)BeanMapper.map((Object)entity, MaterialVO.class);
        }
        return null;
    }

    @Override
    public void update(MaterialVO uniqueBean) {
        this.materialMapper.update(uniqueBean);
    }

    @Override
    public void save(MaterialVO materialVo) {
        this.materialMapper.save(materialVo);
    }

    @Override
    public void insertBatch(List<MaterialVO> materialVOList) {
        if (ListUtil.isNotEmpty(materialVOList)) {
            if (this.psrmRestUtil.isRunMode().booleanValue()) {
                HashMap<Long, MaterialCategoryEntity> categoryEntityHashMap = new HashMap<Long, MaterialCategoryEntity>();
                JSONArray array = new JSONArray();
                for (MaterialVO vo : materialVOList) {
                    JSONObject obj = new JSONObject();
                    obj.put("f_code", (Object)vo.getCode());
                    obj.put("f_name", (Object)vo.getName());
                    obj.put("f_spec", (Object)vo.getSpec());
                    obj.put("f_unit", (Object)vo.getUnitName());
                    obj.put("f_materialpropertyid", (Object)1);
                    MaterialCategoryEntity categoryEntity = (MaterialCategoryEntity)categoryEntityHashMap.get(vo.getCategoryId());
                    if (categoryEntity == null) {
                        categoryEntity = this.materialCategoryMapper.queryDetail(InvocationInfoProxy.getTenantid(), vo.getCategoryId());
                        categoryEntityHashMap.put(vo.getCategoryId(), categoryEntity);
                    }
                    obj.put("f_parentcode", (Object)categoryEntity.getCode());
                    obj.put("f_parentname", (Object)categoryEntity.getName());
                    array.add((Object)obj);
                }
                PSRMResponse resp = this.psrmRestUtil.postReq((Object)array, PSRMMethodConsts.MATERIAL_ADD);
                if (resp.isSuccess()) {
                    for (MaterialVO materialVO : materialVOList) {
                        materialVO.setDef8(materialVO.getCode());
                        materialVO.setDef9("0");
                    }
                } else {
                    throw new BusinessException("\u6570\u636e\u4e2d\u53f0\u64cd\u4f5c\u5931\u8d25\uff1a" + (String)resp.getWarnmsg().get(0));
                }
            }
            ArrayList<Object> toInsert = new ArrayList<MaterialVO>();
            for (MaterialVO materialVO : materialVOList) {
                if (toInsert.size() > 0 && toInsert.size() % 1000 == 0) {
                    this.materialMapper.insertBatch(InvocationInfoProxy.getTenantid(), toInsert);
                    toInsert = new ArrayList();
                }
                toInsert.add(materialVO);
            }
            if (toInsert.size() > 0) {
                this.materialMapper.insertBatch(InvocationInfoProxy.getTenantid(), toInsert);
            }
        }
    }

    @Override
    public void delete(List<Long> ids) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        for (Long id : ids) {
            this.materialMapper.delete(tenantId, id);
        }
    }

    @Override
    public IPage<MaterialEntity> queryPage(QueryParam queryParam) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        Map paramMap = queryParam.getParams();
        HashMap<String, Object> condition = new HashMap<String, Object>();
        for (Map.Entry entry : paramMap.entrySet()) {
            if ("categoryId".equals(entry.getKey())) {
                MaterialCategoryEntity categoryEntity;
                Parameter parameter = (Parameter)entry.getValue();
                if (StringUtils.isBlank((CharSequence)(parameter.getValue() + "")) || (categoryEntity = this.materialCategoryMapper.queryDetail(tenantId, Long.parseLong(parameter.getValue().toString()))) == null) continue;
                condition.put("innerCode", categoryEntity.getInnerCode());
                continue;
            }
            if ("enabled".equals(entry.getKey())) {
                if ("0,1".equals(((Parameter)entry.getValue()).getValue())) continue;
                condition.put((String)entry.getKey(), ((Parameter)entry.getValue()).getValue());
                continue;
            }
            condition.put((String)entry.getKey(), ((Parameter)entry.getValue()).getValue());
        }
        condition.put("pageIndex", (queryParam.getPageIndex() - 1) * queryParam.getPageSize());
        condition.put("pageSize", queryParam.getPageSize());
        List<MaterialEntity> records = this.materialMapper.queryList(condition);
        Long count = this.materialMapper.queryCount(condition);
        Page page = new Page();
        page.setCurrent((long)queryParam.getPageIndex());
        page.setSize((long)queryParam.getPageSize());
        page.setTotal(count.longValue());
        page.setRecords(records);
        return page;
    }

    @Override
    public MaterialVO queryExitFlag(String name, String spec, String unitName, Long categoryId) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MaterialVO materialVo = this.materialMapper.queryExitFlag(tenantId, name, spec, unitName, categoryId);
        return materialVo;
    }

    @Override
    public MaterialVO queryByCode(String code) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        return this.materialMapper.queryByCode(tenantId, code);
    }

    @Override
    public List<MaterialEntity> queryList(QueryParam queryParam) {
        Map paramMap = queryParam.getParams();
        Long tenantId = InvocationInfoProxy.getTenantid();
        HashMap<String, Object> condition = new HashMap<String, Object>();
        for (Map.Entry entry : paramMap.entrySet()) {
            if ("categoryId".equals(entry.getKey())) {
                MaterialCategoryEntity categoryEntity;
                Parameter parameter = (Parameter)entry.getValue();
                if (StringUtils.isBlank((CharSequence)(parameter.getValue() + "")) || (categoryEntity = this.materialCategoryMapper.queryDetail(tenantId, Long.parseLong(parameter.getValue().toString()))) == null) continue;
                condition.put("innerCode", categoryEntity.getInnerCode());
                continue;
            }
            condition.put((String)entry.getKey(), ((Parameter)entry.getValue()).getValue());
        }
        List<MaterialEntity> records = this.materialMapper.queryExportList(condition);
        return records;
    }

    @Override
    public void insertMaterialListFromPlatform() {
        Long tenantId = InvocationInfoProxy.getTenantid();
        this.materialMapper.insertMaterialListFromPlatform(tenantId);
    }

    @Override
    public IPage<MaterialEntity> queryRefMaterialPage(Map<String, Object> params) {
        List<MaterialEntity> dataList = this.materialMapper.queryRefMaterialList(params);
        Long dataCount = this.materialMapper.queryRefMaterialCount(params);
        Page page = new Page();
        page.setRecords(dataList);
        page.setTotal(dataCount.longValue());
        return page;
    }

    @Override
    public MaterialEntity queryBySourceId(String sourceId) {
        return this.materialMapper.queryBySourceId(sourceId, InvocationInfoProxy.getTenantid());
    }

    @Override
    public List<MaterialEntity> queryMaterialByIds(List<Long> ids) {
        return this.materialMapper.queryMaterialByIds(ids, InvocationInfoProxy.getTenantid());
    }

    @Override
    public IPage<MaterialEntity> queryZjwjRefMaterialPage(Map<String, Object> params) {
        Page page = new Page();
        if (params.containsKey("sourceOrgId") && null != params.get("sourceOrgId")) {
            List<MaterialEntity> dataList = this.materialMapper.queryZjwjRefMaterialList(params);
            Long dataCount = this.materialMapper.queryZjwjRefMaterialCount(params);
            page.setRecords(dataList);
            page.setTotal(dataCount.longValue());
        }
        return page;
    }

    @Override
    public List<MaterialEntity> queryMaterialListByNames(List<String> nameList) {
        return this.materialMapper.queryMaterialListByNames(InvocationInfoProxy.getTenantid(), nameList);
    }

    @Override
    public MaterialVO queryLastMaterialByTime() {
        return this.materialMapper.queryLastMaterialByTime(InvocationInfoProxy.getTenantid());
    }

    @Override
    public List<MaterialVO> queryMaterialList(String name, String spec, String unitName) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<MaterialEntity> list = this.materialMapper.queryMaterialList(tenantId, name, spec, unitName);
        if (CollectionUtil.isNotEmpty(list)) {
            List vos = BeanMapper.mapList(list, MaterialVO.class);
            for (MaterialVO materialVO : vos) {
                Long id = materialVO.getCategoryId();
                MaterialCategoryEntity entity = this.materialCategoryMapper.queryDetail(tenantId, id);
                materialVO.setCategoryId(entity.getId());
                materialVO.setCategoryName(entity.getName());
            }
            return vos;
        }
        return null;
    }

    private static String handleBlankString(String str, boolean flag) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return "";
        }
        if (flag) {
            return str.trim();
        }
        return str.replaceAll("\\s*", "");
    }

    private static String handleSpecialString(String str) {
        Pattern p = Pattern.compile("[^(a-zA-Z\\u4e00-\\u9fa5)]");
        Matcher matcher = p.matcher(str);
        return matcher.replaceAll("");
    }

    private static List<String> handleSegmentation(String oldStr, String str) {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add(oldStr);
        if (StringUtils.isBlank((CharSequence)str)) {
            return strings;
        }
        ArrayList<String> english = new ArrayList<String>();
        String pattern = "([a-zA-Z_]+)";
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(str);
        while (m.find()) {
            english.add(m.group());
        }
        String ss = str.replaceAll(pattern, "#");
        int index = 0;
        int length = ss.length();
        int len = length - 1;
        for (int i = 0; i < length; ++i) {
            char c1 = ss.charAt(i);
            if (i + 1 < len) {
                String s;
                char c2 = ss.charAt(i + 1);
                if ('#' == c1 && MaterialServiceImpl.chineseYes(c2)) {
                    s = (String)english.get(index) + c2;
                    strings.add(s);
                    ++index;
                }
                if (MaterialServiceImpl.chineseYes(c1) && MaterialServiceImpl.chineseYes(c2)) {
                    s = String.valueOf(c1) + c2;
                    strings.add(s);
                }
                if (!MaterialServiceImpl.chineseYes(c1) || '#' != c2) continue;
                s = c1 + (String)english.get(index);
                strings.add(s);
                continue;
            }
            String s = ss.substring(i);
            if (s.contains("#")) {
                s = s.replace("#", (CharSequence)english.get(index));
            }
            strings.add(s);
            break;
        }
        return strings;
    }

    public static boolean chineseYes(char ch) {
        return String.valueOf(ch).matches("[\\u4e00-\\u9fa5]");
    }

    private static void spliceMaterialPlusVO(MaterialPlusVO materialPlusVO, Integer matchStatus, String matchStatusDescription, Integer matchNumber, List<MaterialPlusVO> fuzzyMatchList) {
        materialPlusVO.setMatchStatus(matchStatus);
        materialPlusVO.setMatchStatusDescription(matchStatusDescription);
        materialPlusVO.setMatchNumber(matchNumber);
        materialPlusVO.setFuzzyMatchList(fuzzyMatchList);
    }

    @Override
    public MaterialFuzzyMatchVO checkArchive(MaterialFuzzyMatchVO materialFuzzyMatchVO) {
        Map equipmentCategoryMap;
        Stopwatch stopwatch = Stopwatch.createStarted();
        this.logger.info("\u6821\u9a8c\u6863\u6848\u662f\u5426\u5b58\u5728----start");
        Long tenantId = InvocationInfoProxy.getTenantid();
        ArrayList<CompletableFuture<Map>> futures1 = new ArrayList<CompletableFuture<Map>>();
        ArrayList<CompletableFuture<Map>> futures2 = new ArrayList<CompletableFuture<Map>>();
        Map materialCategoryMap = materialFuzzyMatchVO.getMaterialCategoryMap();
        if (null != materialCategoryMap && !materialCategoryMap.isEmpty()) {
            for (Map.Entry entry : materialCategoryMap.entrySet()) {
                CompletableFuture<Map> completableFuture = CompletableFuture.supplyAsync(() -> {
                    this.logger.info("\u6750\u6599\u6863\u6848\uff0c\u5f53\u524d\u7ebf\u7a0b\u4e3a\uff1a{}", (Object)Thread.currentThread().getName());
                    HashMap hashMap = new HashMap();
                    Long count = this.materialCategoryMapper.checkArchive(tenantId, 1, (String)entry.getKey());
                    hashMap.put(entry.getKey(), count.compareTo(0L) > 0);
                    return hashMap;
                }, executorService);
                futures1.add(completableFuture);
            }
        }
        if (null != (equipmentCategoryMap = materialFuzzyMatchVO.getEquipmentCategoryMap()) && !equipmentCategoryMap.isEmpty()) {
            for (Map.Entry entry : equipmentCategoryMap.entrySet()) {
                CompletableFuture<Map> equipmentCategoryFuture = CompletableFuture.supplyAsync(() -> {
                    this.logger.info("\u8bbe\u5907\u6863\u6848\uff0c\u5f53\u524d\u7ebf\u7a0b\u4e3a\uff1a{}", (Object)Thread.currentThread().getName());
                    HashMap hashMap = new HashMap();
                    Long count = this.materialCategoryMapper.checkArchive(tenantId, 2, (String)entry.getKey());
                    hashMap.put(entry.getKey(), count.compareTo(0L) > 0);
                    return hashMap;
                }, executorService);
                futures2.add(equipmentCategoryFuture);
            }
        }
        CompletableFuture.allOf((CompletableFuture[])ArrayUtils.addAll((Object[])futures1.toArray(new CompletableFuture[0]), (Object[])futures2.toArray(new CompletableFuture[0])));
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        futures1.forEach(future -> materialCategoryResult.putAll((Map)future.join()));
        futures2.forEach(future -> equipmentCategoryResult.putAll((Map)future.join()));
        MaterialFuzzyMatchVO fuzzyMatchVO = new MaterialFuzzyMatchVO();
        fuzzyMatchVO.setMaterialCategoryMap(hashMap);
        fuzzyMatchVO.setEquipmentCategoryMap(hashMap2);
        stopwatch.stop();
        this.logger.info("\u6821\u9a8c\u6863\u6848\u662f\u5426\u5b58\u5728----end\uff1a\u5df2\u5904\u7406\u6750\u6599\u6863\u6848\u3010{}\u3011\u6761\u6570\u636e\uff0c\u5171\u7528\u65f6\u3010{}\u3011\u6beb\u79d2", (Object)(materialCategoryMap == null ? 0 : materialCategoryMap.size()), (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        this.logger.info("\u6821\u9a8c\u6863\u6848\u662f\u5426\u5b58\u5728----end\uff1a\u5df2\u5904\u7406\u8bbe\u5907\u6863\u6848\u3010{}\u3011\u6761\u6570\u636e\uff0c\u5171\u7528\u65f6\u3010{}\u3011\u6beb\u79d2", (Object)(equipmentCategoryMap == null ? 0 : equipmentCategoryMap.size()), (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        return fuzzyMatchVO;
    }

    @Override
    public MaterialFuzzyMatchVO fuzzyMatchNumber(MaterialFuzzyMatchVO materialFuzzyMatchVO) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        this.logger.info("\u6a21\u7cca\u5339\u914d\u6570\u91cf----start");
        MaterialFuzzyMatchVO fuzzyMatchVO = new MaterialFuzzyMatchVO();
        Long tenantId = InvocationInfoProxy.getTenantid();
        Map fuzzyMatchMap = materialFuzzyMatchVO.getFuzzyMatchMap();
        if (null != fuzzyMatchMap && !fuzzyMatchMap.isEmpty()) {
            ArrayList<CompletableFuture<Map>> futures = new ArrayList<CompletableFuture<Map>>();
            for (Map.Entry entry : fuzzyMatchMap.entrySet()) {
                CompletableFuture<Map> future2 = CompletableFuture.supplyAsync(() -> {
                    String code;
                    String unitName;
                    String spec;
                    this.logger.info("\u6a21\u7cca\u5339\u914d\u6570\u91cf\uff0c\u5f53\u524d\u7ebf\u7a0b\u4e3a\uff1a{}", (Object)Thread.currentThread().getName());
                    HashMap hashMap = new HashMap();
                    MaterialPlusVO materialPlusVO = (MaterialPlusVO)entry.getValue();
                    String name = materialPlusVO.getName();
                    if (StringUtils.isBlank((CharSequence)name)) {
                        hashMap.put(entry.getKey(), entry.getValue());
                        return hashMap;
                    }
                    String name1 = MaterialServiceImpl.handleBlankString(name, false);
                    String segmentation = MaterialServiceImpl.handleSpecialString(name1);
                    List<String> names = MaterialServiceImpl.handleSegmentation(name, segmentation);
                    Integer type = materialPlusVO.getType();
                    if (type == null || StringUtils.isBlank((CharSequence)materialPlusVO.getCategoryName())) {
                        hashMap.put(entry.getKey(), entry.getValue());
                        return hashMap;
                    }
                    String categoryName = MaterialServiceImpl.handleBlankString(materialPlusVO.getCategoryName(), true);
                    List<MaterialPlusVO> materialPlusVOS = this.materialMapper.findFuzzyResultListByLikeOr(tenantId, name, names, type, categoryName, spec = MaterialServiceImpl.handleBlankString(materialPlusVO.getSpec(), true), unitName = MaterialServiceImpl.handleBlankString(materialPlusVO.getUnitName(), true), code = StringUtils.isNotEmpty((CharSequence)materialPlusVO.getCode()) ? MaterialServiceImpl.handleBlankString(materialPlusVO.getCode(), true) : null);
                    if (CollectionUtils.isNotEmpty(materialPlusVOS)) {
                        MaterialPlusVO plusVO = materialPlusVOS.get(0);
                        if (plusVO.getWeight() == 12) {
                            MaterialPlusVO vo = (MaterialPlusVO)BeanMapper.map((Object)plusVO, MaterialPlusVO.class);
                            MaterialServiceImpl.spliceMaterialPlusVO(vo, MaterialFuzzyMatchEnum.MACHED.getCode(), MaterialFuzzyMatchEnum.MACHED.getDesc(), materialPlusVOS.size(), new ArrayList<MaterialPlusVO>());
                            entry.setValue(vo);
                        } else {
                            MaterialServiceImpl.spliceMaterialPlusVO(materialPlusVO, MaterialFuzzyMatchEnum.FUZZY_MATCH.getCode(), MaterialFuzzyMatchEnum.FUZZY_MATCH.getDesc() + materialPlusVOS.size() + "\u6761", materialPlusVOS.size(), new ArrayList<MaterialPlusVO>());
                            entry.setValue(materialPlusVO);
                        }
                    } else {
                        MaterialServiceImpl.spliceMaterialPlusVO(materialPlusVO, MaterialFuzzyMatchEnum.UN_MATCH.getCode(), MaterialFuzzyMatchEnum.UN_MATCH.getDesc(), 0, new ArrayList<MaterialPlusVO>());
                        entry.setValue(materialPlusVO);
                    }
                    hashMap.put(entry.getKey(), entry.getValue());
                    return hashMap;
                }, executorService);
                futures.add(future2);
            }
            CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
            HashMap fuzzyMatchResult = new HashMap();
            futures.forEach(future -> fuzzyMatchResult.putAll((Map)future.join()));
            fuzzyMatchVO.setFuzzyMatchMap(fuzzyMatchResult);
        }
        stopwatch.stop();
        this.logger.info("\u6a21\u7cca\u5339\u914d\u6570\u91cf----end\uff1a\u5df2\u5904\u7406\u3010{}\u3011\u6761\u6570\u636e\uff0c\u5171\u7528\u65f6\u3010{}\u3011\u6beb\u79d2", (Object)(fuzzyMatchMap == null ? 0 : fuzzyMatchMap.size()), (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        return fuzzyMatchVO;
    }

    @Override
    public IPage<MaterialPlusVO> fuzzyMatchQueryPage(long current, long size, String name, Integer type, String categoryName, String spec, String unitName, String fuzzyName, String fuzzySpec, String fuzzyUnitName) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        Page page = new Page(current, size);
        if (StringUtils.isBlank((CharSequence)name)) {
            return null;
        }
        String name1 = MaterialServiceImpl.handleBlankString(name, false);
        String segmentation = MaterialServiceImpl.handleSpecialString(name1);
        List<String> names = MaterialServiceImpl.handleSegmentation(name, segmentation);
        if (type == null || StringUtils.isBlank((CharSequence)categoryName)) {
            return null;
        }
        categoryName = MaterialServiceImpl.handleBlankString(categoryName, true);
        spec = MaterialServiceImpl.handleBlankString(spec, true);
        unitName = MaterialServiceImpl.handleBlankString(unitName, true);
        List<MaterialPlusVO> materialPlusVOS = this.materialMapper.fuzzyMatchQueryPage((Page<MaterialPlusVO>)page, tenantId, name, names, type, categoryName, spec, unitName, fuzzyName, fuzzySpec, fuzzyUnitName);
        page.setRecords(materialPlusVOS);
        return page;
    }

    @Override
    public CommonResponse<Map<String, MaterialVO>> batchInsertArchive(Map<String, MaterialVO> materialVOMap, Long sourceBillId, String sourceBillCode, String sourceProjectName, String sourceBillType) throws BillCodeException {
        List<MaterialEntity> materialEntities;
        Stopwatch stopwatch = Stopwatch.createStarted();
        this.logger.info("\u6821\u9a8c\u6863\u6848\u662f\u5426\u5b58\u5728----start" + JSONObject.toJSONString(materialVOMap));
        if (materialVOMap.isEmpty()) {
            throw new BusinessException("\u6279\u91cf\u63d2\u5165\u6863\u6848\uff0c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Long tenantId = InvocationInfoProxy.getTenantid();
        ArrayList<MaterialVO> materialVOS = new ArrayList<MaterialVO>();
        List<String> codeList = materialVOMap.values().stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getCode())).map(e -> e.getCode()).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(codeList) && CollectionUtils.isNotEmpty(materialEntities = this.materialMapper.queryByCodes(InvocationInfoProxy.getTenantid(), codeList))) {
            throw new BusinessException("\u7269\u6599\u6863\u6848\u4e2d\u5b58\u5728\u7f16\u7801\u4e3a" + materialEntities.get(0).getCode() + "\u7684\u7269\u6599\uff0c\u8be5\u7269\u6599\u4e0d\u80fd\u65b0\u589e\uff01");
        }
        HashMap<String, String> checkMaps = new HashMap<String, String>();
        HashMap<String, MaterialVO> checkDataMaps = new HashMap<String, MaterialVO>();
        for (Map.Entry<String, MaterialVO> entry : materialVOMap.entrySet()) {
            MaterialVO materialVO = entry.getValue();
            MaterialCategoryEntity materialCategory = this.materialCategoryMapper.queryCategoryByTypeAndName(tenantId, materialVO.getType(), materialVO.getCategoryName());
            if (materialCategory == null) {
                return CommonResponse.error((String)("\u6279\u91cf\u63d2\u5165\u6863\u6848\uff0c\u6863\u6848\u5206\u7c7b:" + materialVO.getCategoryName() + "\uff0c\u4e0d\u5b58\u5728\uff01"));
            }
            MaterialVO material = this.materialMapper.queryAllByTenantIdAndNameAndTypeAndSpecAndUnitName(tenantId, materialCategory.getId(), materialVO.getName(), materialVO.getType(), materialVO.getSpec(), materialVO.getUnitName());
            if (material == null) {
                String billCode = "";
                if (StringUtils.isEmpty((CharSequence)materialVO.getCode()) || "".equals(materialVO.getCode())) {
                    if (materialVO.getType() == 1) {
                        billCode = this.generator.generateBillCodeById(MATERIAL_BILL_CODE, tenantId);
                    } else if (materialVO.getType() == 2) {
                        billCode = this.generator.generateBillCodeById(EQUIPMENT_BILL_CODE, tenantId);
                    }
                } else {
                    billCode = materialVO.getCode();
                }
                if (checkMaps.containsKey(billCode)) {
                    if (((String)checkMaps.get(billCode)).equals(entry.getKey())) {
                        if (!checkDataMaps.containsKey(billCode)) continue;
                        MaterialVO vo = (MaterialVO)checkDataMaps.get(billCode);
                        materialVO.setId(vo.getId());
                        materialVO.setEnabled(vo.getEnabled());
                        materialVO.setCreateUserCode(vo.getCreateUserCode());
                        materialVO.setCreateTime(vo.getCreateTime());
                        materialVO.setTenantId(vo.getTenantId());
                        materialVO.setCategoryId(vo.getCategoryId());
                        materialVO.setCategoryName(vo.getCategoryName());
                        materialVO.setCategoryCode(vo.getCategoryCode());
                        materialVO.setSourceId(vo.getSourceId());
                        materialVO.setSystemId(vo.getSystemId());
                        materialVO.setCategorySourceId(vo.getCategorySourceId());
                        materialVO.setBillState(vo.getBillState());
                        entry.setValue(materialVO);
                        continue;
                    }
                    throw new BusinessException("\u7269\u6599\u540d\u79f0\u4e3a:" + materialVO.getName() + "\u7f16\u7801\u4e3a:" + materialVO.getCode() + "\u7684\u7269\u6599\uff0c\u8be5\u7269\u6599\u4e0d\u80fd\u65b0\u589e\uff01\u7f16\u7801\u91cd\u590d!");
                }
                materialVO.setId(Long.valueOf(IdWorker.getId()));
                materialVO.setCategoryId(materialCategory.getId());
                materialVO.setCode(billCode);
                materialVO.setEnabled(Integer.valueOf(1));
                materialVO.setCreateUserCode(InvocationInfoProxy.getUsercode());
                materialVO.setCreateTime(new Date());
                materialVO.setTenantId(InvocationInfoProxy.getTenantid());
                materialVO.setSourceId(materialCategory.getSourceId());
                materialVO.setSystemId(materialCategory.getSystemId());
                materialVO.setCategorySourceId(materialCategory.getSourceId());
                materialVO.setCategoryName(materialCategory.getName());
                materialVO.setCategoryCode(materialCategory.getCode());
                materialVO.setBillState(Optional.ofNullable(materialVO.getBillState()).orElse(0));
                if (materialVO.getBillState() == 0) {
                    materialVO.setSourceBillId(sourceBillId);
                    materialVO.setSourceBillCode(sourceBillCode);
                    materialVO.setSourceBillType(sourceBillType);
                    materialVO.setSourceProjectName(sourceProjectName);
                    materialVO.setHide(Integer.valueOf(0));
                }
                materialVOS.add(materialVO);
                entry.setValue(materialVO);
                checkMaps.put(materialVO.getCode(), entry.getKey());
                checkDataMaps.put(billCode, materialVO);
                continue;
            }
            materialVO.setId(material.getId());
            materialVO.setCategoryId(materialCategory.getId());
            materialVO.setCode(material.getCode());
            materialVO.setSourceId(material.getSourceId());
            materialVO.setSystemId(material.getSystemId());
            materialVO.setCategorySourceId(materialCategory.getSourceId());
            materialVO.setCategoryName(materialCategory.getName());
            materialVO.setCategoryCode(materialCategory.getCode());
            entry.setValue(materialVO);
            checkMaps.put(materialVO.getCode(), entry.getKey());
            checkDataMaps.put(materialVO.getCode(), materialVO);
        }
        if (CollectionUtils.isNotEmpty(materialVOS)) {
            this.materialMapper.insertBatch1(tenantId, materialVOS);
        }
        stopwatch.stop();
        this.logger.info("\u6821\u9a8c\u6863\u6848\u662f\u5426\u5b58\u5728----end\uff1a\u5df2\u5904\u7406\u8bbe\u5907\u6863\u6848\u3010{}\u3011\u6761\u6570\u636e\uff0c\u5171\u7528\u65f6\u3010{}\u3011\u6beb\u79d2", (Object)(materialVOMap.isEmpty() ? 0 : materialVOMap.size()), (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        return CommonResponse.success(materialVOMap);
    }

    @Override
    public List<MaterialEntity> queryMaterialListByCodes(List<String> codeList) {
        return this.materialMapper.queryMaterialListByCodes(InvocationInfoProxy.getTenantid(), codeList);
    }

    @Override
    public void allowIn(List<Long> ids) {
        this.materialMapper.allowIn(InvocationInfoProxy.getTenantid(), ids);
    }

    @Override
    public void hide(List<Long> ids) {
        this.materialMapper.hide(InvocationInfoProxy.getTenantid(), ids);
    }

    @Override
    public void updateQuoteData(List<Long> ids) {
        for (Long id : ids) {
            this.commonUpdateBillStateService.updateQuoteData(id, "BT200422000000025");
        }
    }

    @Override
    public void enableOrDisable(List<Long> ids, Integer enabled) {
        this.materialMapper.enableOrDisable(InvocationInfoProxy.getTenantid(), ids, enabled);
    }

    public PSRMResponse saveOrUpdatePsrmObj(MaterialVO vo) {
        PSRMResponse resp = null;
        Long id = vo.getId();
        MaterialVO materialVO = null;
        if (id != null) {
            materialVO = this.queryDetail(id);
        }
        JSONObject obj = new JSONObject();
        obj.put("f_code", (Object)vo.getCode());
        obj.put("f_name", (Object)vo.getName());
        obj.put("f_spec", (Object)vo.getSpec());
        obj.put("f_unit", (Object)vo.getUnitName());
        obj.put("f_materialpropertyid", (Object)1);
        if (materialVO == null || StringUtils.isBlank((CharSequence)materialVO.getDef8())) {
            Long categoryId = vo.getCategoryId();
            MaterialCategoryEntity categoryEntity = this.materialCategoryMapper.queryDetail(InvocationInfoProxy.getTenantid(), Long.parseLong(categoryId.toString()));
            if (categoryEntity != null) {
                obj.put("f_parentcode", (Object)categoryEntity.getCode());
                obj.put("f_parentname", (Object)categoryEntity.getName());
            }
            if ((resp = this.psrmRestUtil.postReq((Object)obj, this.getSaveMethodName())).isSuccess()) {
                return resp;
            }
            String warnmsg = (String)resp.getWarnmsg().get(0);
            if (!warnmsg.contains("\u5df2\u5b58\u5728")) {
                throw new BusinessException("\u6570\u636e\u4e2d\u53f0\u64cd\u4f5c\u5931\u8d25\uff1a" + (String)resp.getWarnmsg().get(0));
            }
        }
        obj.put("f_code", (Object)materialVO.getDef8());
        obj.remove((Object)"f_name");
        obj.remove((Object)"f_unit");
        obj.remove((Object)"f_parentcode");
        obj.remove((Object)"f_parentname");
        obj.put("f_disabled", (Object)"0");
        resp = this.psrmRestUtil.postReq((Object)obj, this.getUpdateMethodName());
        if (!resp.isSuccess()) {
            throw new BusinessException("\u6570\u636e\u4e2d\u53f0\u64cd\u4f5c\u5931\u8d25\uff1a" + (String)resp.getWarnmsg().get(0));
        }
        return resp;
    }

    public String getSaveMethodName() {
        return PSRMMethodConsts.MATERIAL_ADD;
    }

    public String getUpdateMethodName() {
        return PSRMMethodConsts.MATERIAL_UPDATE;
    }
}

