/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.support.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.bean.FinanceAccountEntity;
import com.ejianc.foundation.support.service.IFinanceAccountService;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.FinanceAccountVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"financeAccount"})
public class FinanceAccountController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "BANK_ACCOUNT";
    @Autowired
    private IFinanceAccountService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<FinanceAccountVO> saveOrUpdate(@RequestBody FinanceAccountVO saveOrUpdateVO) {
        FinanceAccountEntity entity = (FinanceAccountEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, FinanceAccountEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        FinanceAccountVO vo = (FinanceAccountVO)BeanMapper.map((Object)((Object)entity), FinanceAccountVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<FinanceAccountVO> queryDetail(Long id) {
        FinanceAccountEntity entity = (FinanceAccountEntity)((Object)this.service.selectById(id));
        FinanceAccountVO vo = (FinanceAccountVO)BeanMapper.map((Object)((Object)entity), FinanceAccountVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<FinanceAccountVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (FinanceAccountVO financeAccountVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<FinanceAccountVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("accountName");
        fuzzyFields.add("accountNum");
        fuzzyFields.add("accountBankName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), FinanceAccountVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/downloadTemplet"})
    @ResponseBody
    public void downloadTemplet(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"finance-import.xlsx", (String)"\u5bfc\u5165\u94f6\u884c\u8d26\u6237");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        ArrayList<FinanceAccountVO> successList = new ArrayList<FinanceAccountVO>();
        ArrayList<FinanceAccountVO> errorList = new ArrayList<FinanceAccountVO>();
        if (result != null && result.size() > 0 && ((List)result.get(0)).size() != 4) {
            throw new BusinessException("\u8bf7\u6309\u7167\u5bfc\u5165\u6a21\u677f\u5bfc\u5165\u6570\u636e");
        }
        ArrayList<Integer> orgTypeList = new ArrayList<Integer>();
        orgTypeList.addAll(Arrays.asList(1, 2, 3, 4));
        CommonResponse orgByList = this.iOrgApi.findOrgByType(InvocationInfoProxy.getTenantid(), orgTypeList, null);
        Map<Object, Object> orgMap = new HashMap();
        if (!orgByList.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        orgMap = ((List)orgByList.getData()).stream().collect(Collectors.toMap(OrgVO::getName, BaseVO::getId, (e1, e2) -> e2));
        for (int i = 0; i < result.size(); ++i) {
            List row = (List)result.get(i);
            StringBuilder errMsg = new StringBuilder();
            FinanceAccountVO financeAccountVO = new FinanceAccountVO();
            String orgName = ((String)row.get(0)).trim();
            if (StringUtils.isNotBlank((CharSequence)orgName)) {
                Long orgId = (Long)orgMap.get(orgName);
                if (orgId != null) {
                    financeAccountVO.setInnerUnitId(orgId);
                    financeAccountVO.setInnerUnitName(orgName);
                } else {
                    errMsg.append("`\u5185\u90e8\u5355\u4f4d\u4e0d\u5b58\u5728\u8bf7\u91cd\u65b0\u8f93\u5165`");
                }
            } else {
                errMsg.append("`\u5185\u90e8\u5355\u4f4d\u672a\u586b\u5199`");
            }
            String accountName = ((String)row.get(1)).trim();
            if (StringUtils.isNotBlank((CharSequence)accountName)) {
                financeAccountVO.setAccountName(accountName);
            } else {
                errMsg.append("`\u8d26\u6237\u540d\u672a\u586b\u5199`");
            }
            String accountNum = ((String)row.get(2)).trim();
            if (StringUtils.isNotBlank((CharSequence)accountNum)) {
                financeAccountVO.setAccountNum(accountNum);
            } else {
                errMsg.append("`\u94f6\u884c\u8d26\u6237\u672a\u586b\u5199`");
            }
            String accountBankName = ((String)row.get(3)).trim();
            if (StringUtils.isNotBlank((CharSequence)accountBankName)) {
                financeAccountVO.setAccountBankName(accountBankName);
            }
            financeAccountVO.setEnabledStatus(Integer.valueOf(1));
            financeAccountVO.setEnabledStatusName("\u5df2\u542f\u7528");
            financeAccountVO.setErrMsg(errMsg.toString());
            if (StringUtils.isNotBlank((CharSequence)financeAccountVO.getErrMsg())) {
                errorList.add(financeAccountVO);
                continue;
            }
            successList.add(financeAccountVO);
        }
        JSONObject json = new JSONObject();
        json.put("successList", (Object)BeanMapper.mapList(successList, FinanceAccountVO.class));
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/saveImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveImport(@RequestBody List<FinanceAccountVO> accbookVOS) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, tenantId, accbookVOS.size());
        List billCodeList = new ArrayList();
        if (!billCode.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        billCodeList = (List)billCode.getData();
        for (int i = 0; i < accbookVOS.size(); ++i) {
            accbookVOS.get(i).setBillCode((String)billCodeList.get(i));
        }
        this.logger.info("billcode----------------\uff1a" + JSONObject.toJSONString((Object)billCode));
        this.service.saveBatch(BeanMapper.mapList(accbookVOS, FinanceAccountEntity.class));
        return CommonResponse.success((String)"\u5bfc\u5165\u6210\u529f");
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("accountName");
        fuzzyFields.add("accountNum");
        fuzzyFields.add("accountBankName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        List financeAccountVOS = BeanMapper.mapList((Iterable)list, FinanceAccountVO.class);
        for (FinanceAccountVO financeAccountVO : financeAccountVOS) {
            if (financeAccountVO.getEnabledStatus() == 1) {
                financeAccountVO.setEnabledStatusName("\u5df2\u542f\u7528");
                continue;
            }
            financeAccountVO.setEnabledStatusName("\u5df2\u505c\u7528");
        }
        beans.put("records", financeAccountVOS);
        ExcelExport.getInstance().export("BankAccount-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/updateEnableStatus"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<FinanceAccountVO> updateEnableStatus(Long id, Integer status) {
        if (id != null) {
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)id);
            updateWrapper.set(FinanceAccountEntity::getEnabledStatus, (Object)status);
            this.service.update((Wrapper)updateWrapper);
        }
        return CommonResponse.success((String)"\u66f4\u65b0\u542f\u7528\u72b6\u6001\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/refBankAccountData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<FinanceAccountVO>> refBankAccountData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getFuzzyFields().addAll(Arrays.asList("accountNum", "accountName", "accountBankName", "billCode"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("enabledStatus", new Parameter("eq", (Object)1));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), FinanceAccountVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

