package com.ejianc.foundation.billcode.elemproc.impl;

import com.ejianc.foundation.billcode.util.BillCodeProcessUtils;
import org.apache.commons.lang3.StringUtils;

import com.ejianc.foundation.billcode.BillCodeException;
import com.ejianc.foundation.billcode.elemproc.itf.IElemProcessor;
import com.ejianc.foundation.billcode.elemproc.result.BillCodeElemInfo;
import com.ejianc.foundation.billcode.model.BillCodeBillVO;
import com.ejianc.foundation.support.vo.BillCodeRuleAttrVO;

/**
 * 元素处理器--实体属性
 *
 * @author CJ
 * @Description:
 * @date 2021/7/8 15:21
 */
public class EntityAttrElemProcessor implements IElemProcessor {
    @Override
    public int getCanProcElemType() {
        return 4;
    }

    @Override
    public BillCodeElemInfo procElemInfo(BillCodeRuleAttrVO elemvo, BillCodeBillVO billCodeBillVO) throws BillCodeException {
        BillCodeElemInfo eleminfo = new BillCodeElemInfo();

        String elemSNRefer = elemvo.getBillValue();
        String elemSNReferDesc = "";
        if (StringUtils.isNotBlank(elemSNRefer) && !elemSNRefer.equals("")) {
            elemSNRefer = "^sysdate^" + elemSNRefer;
            elemSNReferDesc = "#date#" + elemSNRefer.length() + "|";
        }
        eleminfo.setElemSNRefer(elemSNRefer);
        eleminfo.setElemSNReferDesc(elemSNReferDesc);
        if(StringUtils.isNotBlank(elemvo.getElemIsRefer()) && "1".equals(elemvo.getElemIsRefer())){
            eleminfo.setSysTimeElem(true);
        }else{
            eleminfo.setSysTimeElem(false);
        }

        String billValue = elemvo.getBillValue();
        if(StringUtils.isNotBlank(billValue)) {
        	eleminfo.setElemValue(billValue);
        }else{
        	eleminfo.setElemValue("{" + elemvo.getElemValue().trim() + "}");
        }
        eleminfo.setElemLength(elemvo.getElemLength());
        return eleminfo;
    }
}
