package com.ejianc.foundation.billcode.elemproc.result;

import java.util.ArrayList;
import java.util.List;

public class BillCodeInfo {

    private String pk_bilcodebase = "";
    private boolean isautofill = true;
    private StringBuffer billCodeSNRefer = new StringBuffer();
    private StringBuffer billCodeSNReferDesc = new StringBuffer();
    private StringBuffer billCodeTemplte = new StringBuffer();
    private int billCodeLength = 0;
    private BillCodeSerialNumInfo serialNumInfo = new BillCodeSerialNumInfo();
    private List<BillCodeSysDateInfo> sysDateRefInfos = new ArrayList<>();

    public BillCodeInfo() {
    }

    public BillCodeInfo(BillCodeElemInfo eleminfo) {
        if (null != eleminfo) {
            this.billCodeSNRefer = new StringBuffer(eleminfo.getElemSNRefer());
            this.billCodeSNReferDesc = new StringBuffer(eleminfo.getElemSNReferDesc());
            this.billCodeTemplte = new StringBuffer(eleminfo.getElemValue());
            this.billCodeLength = eleminfo.getElemLength();
        }
    }

    public void addElemCodeInfo(BillCodeElemInfo elemCoreInfo) {
        this.billCodeSNRefer.append(elemCoreInfo.getElemSNRefer());
        this.billCodeSNReferDesc.append(elemCoreInfo.getElemSNReferDesc());
        this.billCodeTemplte.append(elemCoreInfo.getElemValue());
        this.billCodeLength += elemCoreInfo.getElemLength();
    }

    public void addBillCodeInfo(BillCodeInfo info) {
        this.billCodeSNRefer.append(info.getBillCodeSNRefer());
        this.billCodeSNReferDesc.append(info.getBillCodeSNReferDesc());
        this.billCodeTemplte.append(info.getBillCodeTemplte());
        this.billCodeLength += info.getBillcodeLength();
    }

    public String getBillCodeSNRefer() {
        return this.billCodeSNRefer.toString();
    }

    public String getBillCodeSNReferDesc() {
        return this.billCodeSNReferDesc.toString();
    }

    public String getBillCodeTemplte() {
        return this.billCodeTemplte.toString();
    }

    public String getPk_bilcodebase() {
        return this.pk_bilcodebase;
    }

    public void setPk_bilcodebase(String pk_bilcodebase) {
        this.pk_bilcodebase = pk_bilcodebase;
    }

    public int getBillcodeLength() {
        return this.billCodeLength;
    }

    public void setBillcodeLength(int billcodeLength) {
        this.billCodeLength = billcodeLength;
    }

    public boolean isautofill() {
        return this.isautofill;
    }

    public void setIsautofill(boolean isautofill) {
        this.isautofill = isautofill;
    }

    public List<BillCodeSysDateInfo> getSysDateRefInfos() {
        return this.sysDateRefInfos;
    }

    public void setSysDateRefInfos(List<BillCodeSysDateInfo> sysDateRefInfos) {
        this.sysDateRefInfos = sysDateRefInfos;
    }

    public BillCodeSerialNumInfo getSerialNumInfo() {
        return this.serialNumInfo;
    }

    public void setSerialNumInfo(BillCodeSerialNumInfo serialNumInfo) {
        this.serialNumInfo = serialNumInfo;
    }
}
