package com.ejianc.foundation.billcode.sngenerator.impl;

import com.ejianc.foundation.billcode.sngenerator.ISNGenerator;

import java.util.regex.Pattern;

public class LetterDigitalSNGenerator implements ISNGenerator {

    private char[] value = new char[] { '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0' };

    @Override
    public String getSNGeneratorType() {
        return "1";
    }

    @Override
    public String getNextSNumber(String sn, Boolean isSNAppendZero, int snLength) {
        String snLetter = sn.substring(0, 1);
        String snDigital = sn.substring(1, sn.length());
        if (snLength == 1) {
            if (snLetter.charAt(0) >= 65) {
                char needAddLetterValue1 = (char) (snLetter.charAt(0) + 1);
                snLetter = String.valueOf(needAddLetterValue1);
            } else {
                snLetter = "A";
            }

            return snLetter;
        } else {
            if (snLetter.charAt(0) >= 65) {
                snDigital = Long.parseLong(snDigital) + 1L + "";
                String needAddLetterValue = "1" + new String(this.value, 0, snLength - 1);
                if (needAddLetterValue.equals(snDigital)) {
                    char letter = (char) (snLetter.charAt(0) + 1);
                    snLetter = String.valueOf(letter);
                    snDigital = "0";
                }
            } else {
                snLetter = "A";
                snDigital = "0";
            }

            snDigital = this.getFormatedDigital(snDigital, isSNAppendZero, snLength - 1);
            return snLetter + snDigital;
        }
    }

    @Override
    public String getFormatedSNumber(String sn, Boolean isSNAppendZero, int snLength) {
        String snLetter = sn.substring(0, 1);
        String snDigital = sn.substring(1, sn.length());
        if (snLength == 1) {
            return snLetter;
        } else {
            if (sn.length() == 1) {
                snDigital = "0";
            }

            snDigital = this.getFormatedDigital(snDigital, isSNAppendZero, snLength - 1);
            return snLetter + snDigital;
        }
    }

    @Override
    public Boolean isRunOutSNumber(String sn, int needAmount, int snLength) {
        String snLetter = sn.substring(0, 1);
        if (snLetter.charAt(0) < 65) {
            return Boolean.valueOf(false);
        } else {
            String snDigital = sn.substring(1, sn.length());
            long k = Long.parseLong("1" + new String(this.value, 0, snLength - 1));
            long p = snLength == 1 ? 0L : Long.parseLong(snDigital);
            long realNumber = (long) (snLetter.charAt(0) - 65) * k + p + (long) needAmount;
            long maxNumber = 26L * k;
            return realNumber >= maxNumber ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
    }

    @Override
    public Boolean isEffectiveSNumber(String sn) {
        return Boolean.valueOf(Pattern.compile("^[A-Z]{1}[0-9]*").matcher(sn).matches()
                || Pattern.compile("[0]+").matcher(sn).matches());
    }

    private String getFormatedDigital(String sn, Boolean isSNAppendZero, int snLength) {
        if (isSNAppendZero.booleanValue()) {
            if (sn.length() < snLength) {
                String s = new String(this.value, 0, snLength - sn.length());
                sn = s + sn;
            }
        } else {
            sn = Long.parseLong(sn) + "";
        }

        return sn;
    }

    public String getSNumberDesc() {
        return "流水号为：首位字母+后位0个以上的数字。";
    }
}
