package com.ejianc.foundation.dataModel.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 数据模型主表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_support_data_model")
public class DataModelEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="code")
    private String code; // 模型编码
    @TableField(value="name")
    private String name; // 模型名称
    @TableField(value="data_set_ids")
    private String dataSetIds; // 数据集id
    @TableField(value="sub_tab_param")
    private String subTabParam; // 单据子表查询纬度，格式:"子表键值1:字段键值1,子表键值2:字段键值2"
    @TableField(value="bill_param")
    private String billParam; // 单据数据参数，查询纬度，数据来源于单据,格式:"字段1,字段2"
    @TableField(value="model_type")
    private Integer modelType; // 数据模型类型：1、指标，2、报表，3、饼状图，4、柱状图，5、折线图
    @TableField(value="sequence")
    private Integer sequence; // 排序

    @TableField(exist = false)
    private List<DataModelBillEntity> billEntities = new ArrayList<>();
    @TableField(exist = false)
    private List<DataModelColumnEntity> columnEntities = new ArrayList<>();

    public List<DataModelBillEntity> getBillEntities() {
        return billEntities;
    }

    public void setBillEntities(List<DataModelBillEntity> billEntities) {
        this.billEntities = billEntities;
    }

    public List<DataModelColumnEntity> getColumnEntities() {
        return columnEntities;
    }

    public void setColumnEntities(List<DataModelColumnEntity> columnEntities) {
        this.columnEntities = columnEntities;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getDataSetIds() {
        return dataSetIds;
    }

    public void setDataSetIds(String dataSetIds) {
        this.dataSetIds = dataSetIds;
    }
    public String getSubTabParam() {
        return subTabParam;
    }

    public void setSubTabParam(String subTabParam) {
        this.subTabParam = subTabParam;
    }
    public String getBillParam() {
        return billParam;
    }

    public void setBillParam(String billParam) {
        this.billParam = billParam;
    }
    public Integer getModelType() {
        return modelType;
    }

    public void setModelType(Integer modelType) {
        this.modelType = modelType;
    }
    public Integer getSequence() {
        return sequence;
    }

    public void setSequence(Integer sequence) {
        this.sequence = sequence;
    }
    
}
