package com.ejianc.foundation.dataModel.controller;

import java.io.Serializable;

import com.ejianc.foundation.dataModel.bean.DataModelCustomerBillEntity;
import com.ejianc.foundation.dataModel.service.IDataModelCustomerBillService;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.foundation.dataModel.bean.DataModelBillEntity;
import com.ejianc.foundation.dataModel.service.IDataModelBillService;
import com.ejianc.foundation.dataModel.vo.DataModelBillVO;

/**
 * 数据模型单据关系
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("dataModelBill")
public class DataModelBillController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IDataModelBillService service;


    @Autowired
    private IDataModelCustomerBillService iDataModelCustomerBillService;


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<DataModelBillVO> saveOrUpdate(@RequestBody DataModelBillVO saveOrUpdateVO) {
    	DataModelBillEntity entity = BeanMapper.map(saveOrUpdateVO, DataModelBillEntity.class);
    	service.saveOrUpdate(entity, false);
    	DataModelBillVO vo = BeanMapper.map(entity, DataModelBillVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }


    /**
     * @Description saveOrUpdate 新增 客户单据配置
     */
    @RequestMapping(value = "/saveOrUpdateCus", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<DataModelBillVO> saveOrUpdateCus(@RequestBody DataModelBillVO saveOrUpdateVO) {

    	DataModelBillEntity entity = service.selectById(saveOrUpdateVO.getId());
    	QueryParam param = new QueryParam();
    	param.getParams().put("billTypeCode",new Parameter(QueryParam.EQ,entity.getBillTypeCode()));
    	param.getParams().put("tenantId",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
    	param.getParams().put("dataModelId",new Parameter(QueryParam.EQ,saveOrUpdateVO.getDataModelId()));
    	List<DataModelCustomerBillEntity> list = iDataModelCustomerBillService.queryList(param);
    	if(ListUtil.isNotEmpty(list)){
    	    return CommonResponse.error("该单据已配置！");
        }

        DataModelCustomerBillEntity customerBillEntity = BeanMapper.map(entity,DataModelCustomerBillEntity.class);
        customerBillEntity.setId(IdWorker.getId());
        customerBillEntity.setTenantId(InvocationInfoProxy.getTenantid());
        customerBillEntity.setModelBillId(saveOrUpdateVO.getId());

    	iDataModelCustomerBillService.saveOrUpdate(customerBillEntity, false);
    	DataModelBillVO vo = BeanMapper.map(customerBillEntity, DataModelBillVO.class);
    	return CommonResponse.success("保存成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DataModelBillVO> queryDetail(Long id) {
    	DataModelBillEntity entity = service.selectById(id);
    	DataModelBillVO vo = BeanMapper.map(entity, DataModelBillVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DataModelBillVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (DataModelBillVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(DataModelBillVO::getId).collect(Collectors.toList()),false);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description delete 批量删除租户单据配置
     * @Param [ids]
     */
    @RequestMapping(value = "/deleteCus", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> deleteCus(@RequestBody List<DataModelBillVO> vos) {
        List<DataModelCustomerBillEntity> list = new ArrayList<>();
        if(ListUtil.isNotEmpty(vos)){
            for (DataModelBillVO vo : vos) {
                QueryParam param = new QueryParam();
                param.getParams().put("billTypeCode",new Parameter(QueryParam.EQ,vo.getBillTypeCode()));
                param.getParams().put("tenantId",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
                param.getParams().put("dataModelId",new Parameter(QueryParam.EQ,vo.getDataModelId()));
                List<DataModelCustomerBillEntity> list1 = iDataModelCustomerBillService.queryList(param);
                if(ListUtil.isNotEmpty(list1)){
                    list.addAll(list1);
                }
            }
        }
        if(ListUtil.isNotEmpty(list)){
            iDataModelCustomerBillService.removeByIds(list.stream().map(DataModelCustomerBillEntity::getId).collect(Collectors.toList()),false);
        }
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<DataModelBillVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.setPageSize(-1);
        IPage<DataModelBillEntity> page = service.queryPage(param,false);
        IPage<DataModelBillVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), DataModelBillVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description queryList 查询租户定义的单据列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryListCus", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<DataModelBillVO>> queryListCus(@RequestBody QueryParam param) {
        param.setPageSize(-1);
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<DataModelCustomerBillEntity> page = iDataModelCustomerBillService.queryPage(param,false);
        IPage<DataModelBillVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<DataModelBillVO> records = new ArrayList<>();
        if(ListUtil.isNotEmpty(page.getRecords())){
            for (DataModelCustomerBillEntity record : page.getRecords()) {
                DataModelBillEntity entity = service.selectById(record.getModelBillId());
                if(entity!=null){
                    DataModelBillVO vo = BeanMapper.map(entity,DataModelBillVO.class);
                    records.add(vo);
                }
            }
        }
  		pageData.setRecords(records);

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        List<DataModelBillEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("DataModelBill-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refDataModelBillData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<DataModelBillVO>> refDataModelBillData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            String dataModelId = _con.getString("dataModelId");
            if(StringUtils.isEmpty(dataModelId)){
                return CommonResponse.error("缺少参数dataModelId！");
            }
            param.getParams().put("dataModelId",new Parameter(QueryParam.EQ,dataModelId));
        }else {
            return CommonResponse.error("缺少参数！");
        }

        IPage<DataModelBillEntity> page = service.queryPage(param,false);
        IPage<DataModelBillVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), DataModelBillVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
