package com.ejianc.foundation.dataModel.service.impl;

import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.foundation.dataModel.mapper.DataModelCusMapper;
import com.ejianc.foundation.dataModel.bean.DataModelCusEntity;
import com.ejianc.foundation.dataModel.service.IDataModelCusService;

import java.util.List;

/**
 * 客户数据模型
 * 
 * @author generator
 * 
 */
@Service("dataModelCusService")
public class DataModelCusServiceImpl extends BaseServiceImpl<DataModelCusMapper, DataModelCusEntity> implements IDataModelCusService{

    @Override
    public DataModelCusEntity queryCusModelByModelId(Long modelId) {
        QueryParam param = new QueryParam();
        param.getParams().put("modelId",new Parameter(QueryParam.EQ,modelId));
        param.getParams().put("tenantId",new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<DataModelCusEntity> list = queryList(param);
        if(ListUtil.isNotEmpty(list)){
            return list.get(0);
        }
        return null;
    }
}
