package com.ejianc.foundation.share.controller;

import java.io.Serializable;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.bean.ParamRegisterSetEntity;
import com.ejianc.foundation.support.service.IParamRegisterSetService;
import com.ejianc.framework.core.kit.collection.ListUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.foundation.share.bean.OftenUseEntity;
import com.ejianc.foundation.share.service.IOftenUseService;
import com.ejianc.foundation.share.vo.OftenUseVO;

/**
 * 常用表
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("oftenUse")
public class OftenUseController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String OFTEN_USE_TYPE_CODE = "P-V5371N24";

    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IOftenUseService service;
    @Autowired
    private IParamRegisterSetService iParamRegisterSetService;
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OftenUseVO> saveOrUpdate(@RequestBody OftenUseVO saveorUpdateVO) {
    	OftenUseEntity entity = BeanMapper.map(saveorUpdateVO, OftenUseEntity.class);
    	if(entity.getUserId() == null){
    	    return CommonResponse.error("userId 不能为空！");
        }
    	if(entity.getOftenId() == null){
    	    return CommonResponse.error("oftenId 不能为空！");
        }
    	if(entity.getRefinfokey() == null){
    	    return CommonResponse.error("refinfokey 不能为空！");
        }
        ParamRegisterSetEntity paramSet = iParamRegisterSetService.getByCode(OFTEN_USE_TYPE_CODE);
    	String valueData;
    	if(paramSet == null){
            valueData = "1";//默认租户级别
        }else {
    	    valueData = paramSet.getValueData();
        }
    	if(entity.getId() == null){
            QueryParam param = new QueryParam();
            param.getParams().put("refinfokey",new Parameter(QueryParam.EQ,saveorUpdateVO.getRefinfokey()));
            param.getParams().put("oftenId",new Parameter(QueryParam.EQ,saveorUpdateVO.getOftenId()));

            param.getParams().put("tenantId",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
            switch (valueData){
                case "1" ://租户级别
                    break;
                case "2"://组织级别
                    if(entity.getOrgId()==null){
                        param.getParams().put("orgId",new Parameter(QueryParam.EQ,InvocationInfoProxy.getOrgId()));
                    }else {
                        param.getParams().put("orgId",new Parameter(QueryParam.EQ,entity.getOrgId()));
                    }
                    break;
                case "3"://个人级别
                    if(entity.getOrgId()!=null){
                        param.getParams().put("orgId",new Parameter(QueryParam.EQ,entity.getOrgId()));
                    }
                    param.getParams().put("userId",new Parameter(QueryParam.EQ,entity.getUserId()));
                    break;
                default:
                    break;
            }
            List<OftenUseEntity> useEntities = service.queryList(param,false);
            if(ListUtil.isNotEmpty(useEntities)){
                return CommonResponse.error("已在常用列表啦！");
            }
        }
    	if(entity.getOrgId()==null){
            entity.setOrgId(InvocationInfoProxy.getOrgId());
        }
    	service.saveOrUpdate(entity, false);
    	OftenUseVO vo = BeanMapper.map(entity, OftenUseVO.class);
    	return CommonResponse.success("添加常用成功！",vo);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OftenUseVO> queryDetail(Long id) {
    	OftenUseEntity entity = service.selectById(id);
    	OftenUseVO vo = BeanMapper.map(entity, OftenUseVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OftenUseVO> vos) {
        service.removeByIds(vos.stream().map(OftenUseVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("移除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<JSONObject>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("data");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        ParamRegisterSetEntity paramSet = iParamRegisterSetService.getByCode(OFTEN_USE_TYPE_CODE);
        String valueData;
        if(paramSet == null){
            valueData = "1";//默认租户级别
        }else {
            valueData = paramSet.getValueData();
        }
        switch (valueData){
            case "1" ://租户级别
                break;
            case "2"://组织级别
                if(param.getParams().get("orgId")==null){
                    param.getParams().put("orgId",new Parameter(QueryParam.EQ,InvocationInfoProxy.getOrgId()));
                }else {
                    param.getParams().put("orgId",new Parameter(QueryParam.EQ,param.getParams().get("orgId")));
                }
                break;
            case "3"://个人级别
                if(param.getParams().get("orgId")!=null){
                    param.getParams().put("orgId",new Parameter(QueryParam.EQ,param.getParams().get("orgId")));
                }
                param.getParams().put("createUserCode",new Parameter(QueryParam.EQ,InvocationInfoProxy.getUsercode()));
                break;
            default:
                break;
        }

        IPage<OftenUseEntity> page = service.queryPage(param,false);
        IPage<JSONObject> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        logger.info("常用参照，查询参数：{},查询结果：{}",JSONObject.toJSONString(param),JSONObject.toJSONString(page));
        if(ListUtil.isNotEmpty(page.getRecords())){
            List<JSONObject> records = new ArrayList<>();
            page.getRecords().forEach(o->{
                JSONObject r = JSONObject.parseObject(o.getData());
                /** 传真实行id */
                r.putIfAbsent("rowTrueId",o.getId());
                records.add(r);
            });
            pageData.setRecords(records);
        }
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

}
