package com.ejianc.foundation.share.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.foundation.share.bean.MaterialAuditDetailEntity;
import com.ejianc.foundation.share.bean.MaterialAuditEntity;
import com.ejianc.foundation.share.service.IMaterialAuditService;
import com.ejianc.foundation.share.service.IMaterialService;
import com.ejianc.foundation.share.util.PSRMResponse;
import com.ejianc.foundation.share.util.PSRMRestUtil;
import com.ejianc.foundation.share.vo.MaterialAuditDetailVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.service.IBillTypeService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

@Service("materialAudit")
public class MaterialAuditBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IMaterialAuditService service;

    @Autowired
    private IMaterialService materialService;

    @Autowired
    private IBillTypeService billTypeService;

    @Autowired
    private PSRMRestUtil psrmRestUtil;

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回后回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    /**
     * 审批节点审批中时节点审批前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    /**
     * 审批节点审批中时节点审批后回调
     *
     * @param billId    //单据id
     * @param state        //单据状态
     * @param billTypeCode        //单据类型code
     * @param taskId        //该流程id
     * @param isEnd        //该节点是否结束
     * @return
     */
    @Override
    public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String, Object> other) {
        return CommonResponse.success();
    }

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        MaterialAuditEntity auditEntity = service.selectById(billId);
        List<MaterialAuditDetailEntity> materialAuditDetailList = auditEntity.getMaterialAuditDetailList();
        if (CollectionUtils.isNotEmpty(materialAuditDetailList)) {
            List<Long> enabledList = new ArrayList<>();
            List<Long> disabledList = new ArrayList<>();
            for (MaterialAuditDetailEntity detailEntity : materialAuditDetailList) {
                Long materialId = detailEntity.getMaterialId();
                detailEntity.setId(materialId);
                if (detailEntity.getEnabled().intValue() == 1) {
                    enabledList.add(materialId);
                } else {
                    disabledList.add(materialId);
                }
            }
            if ("新增".equals(auditEntity.getOptFlag())) {
                List<MaterialVO> materialVOS = BeanMapper.mapList(materialAuditDetailList, MaterialVO.class);
                for (MaterialVO materialVO : materialVOS) {
                    materialVO.setBillState(1);
                    materialVO.setSourceBillId(billId);
                    materialVO.setSourceBillCode(auditEntity.getBillCode());
                    materialVO.setSourceBillType("物料审核");
                    materialVO.setCreateUserCode(auditEntity.getCreateUserCode());
                    materialVO.setCreateTime(new Date());
                }
                materialService.insertBatch(materialVOS);
            } else if ("修改".equals(auditEntity.getOptFlag())) {
                if (!enabledList.isEmpty()) {
                    materialService.enableOrDisable(enabledList, 1);
                }
                if (!disabledList.isEmpty()) {
                    materialService.enableOrDisable(disabledList, 0);
                }
            }
        }

        return CommonResponse.success();
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error("该单据不支持弃审！");
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

}
