package com.ejianc.foundation.share.service.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.share.bean.SupplierLinkerEntity;
import com.ejianc.foundation.share.mapper.SupplierLinkerMapper;
import com.ejianc.foundation.share.service.ISupplierLinkerService;
import com.ejianc.foundation.share.vo.SupplierLinkerVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

@Service
public class SupplierLinkerServiceImpl extends BaseServiceImpl<SupplierLinkerMapper, SupplierLinkerEntity> implements ISupplierLinkerService {

	@Autowired
	private SupplierLinkerMapper supplierLinkerMapper;
	
	@Override
	public void deleteBySupplierId(Long supplierId) {
		QueryWrapper<SupplierLinkerEntity> deleteWrapper = new QueryWrapper<>();
		deleteWrapper.eq("supplier_id", supplierId);
		supplierLinkerMapper.delete(deleteWrapper);
	}

	@Override
	public SupplierLinkerVO queryBySupplierIdAndLinkman(Long supplierId, String linkman) {
		QueryWrapper<SupplierLinkerEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("supplier_id", supplierId);
		queryWrapper.eq("link_man", linkman);
		
		List<SupplierLinkerEntity> entities = supplierLinkerMapper.selectList(queryWrapper);
		if(entities != null && entities.size() > 0) {
			return BeanMapper.map(entities.get(0), SupplierLinkerVO.class);
		}
		return null;
	}

}
