package com.ejianc.foundation.support.controller;

import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

import com.ejianc.foundation.support.bean.DefdocEntity;
import com.google.common.collect.Lists;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.support.bean.DefdocDetailEntity;
import com.ejianc.foundation.support.service.IDefdocDetailService;
import com.ejianc.foundation.support.service.IDefdocService;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.foundation.support.vo.DefdocVO;
import com.ejianc.foundation.util.DefdocDetailAsTree;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.support.idworker.util.IdWorker;

/**
 * 自定义档案明细controller
 * 
 * @author guominga
 *
 */
@SuppressWarnings("rawtypes")
@RestController
@RequestMapping("/defdocdetail/")
public class DefdocDetailController implements Serializable {
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	private static final long serialVersionUID = 1L;
	
	@Value("${oms.tenantid}")
	private String OMS_TENANT;
	
	@Autowired
	private IDefdocDetailService defdocDetailService;
	@Autowired
	private IDefdocService defdocService;
	
	/**
	 * 新增或者修改
	 * 
	 * @param defdocDetailVo
	 * @return
	 */
	@RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> saveOrUpdate(@RequestBody DefdocDetailVO defdocDetailVo) {
		if(defdocDetailVo.getId() != null &&defdocDetailVo.getId() > 0) {
			DefdocDetailVO uniqueBean = defdocDetailService.queryDetail(defdocDetailVo.getId());
			List<DefdocDetailVO> detailVOS = defdocDetailService.queryListByDefdocId(Collections.singletonList(uniqueBean.getDefdocId()));
			List<DefdocDetailVO> num = new ArrayList<>() ;
			if(!ListUtil.isEmpty(detailVOS)){
				detailVOS.forEach(e->{
					if(e.getCode().equals(defdocDetailVo.getCode()) && !e.getId().equals(defdocDetailVo.getId())){
						num.add(e);
					}
				});
			}
			if(num.size()>0){
				throw new BusinessException("修改失败，档案项编码与【"+num.get(0).getName()+"】重复！");
			}
			uniqueBean.setCode(defdocDetailVo.getCode());
			uniqueBean.setName(defdocDetailVo.getName());
			uniqueBean.setSequence(defdocDetailVo.getSequence());
			uniqueBean.setDescription(defdocDetailVo.getDescription());
			uniqueBean.setAttrCode(defdocDetailVo.getAttrCode());
			uniqueBean.setAttrId(defdocDetailVo.getAttrId());
			uniqueBean.setAttrName(defdocDetailVo.getAttrName());
			DefdocDetailEntity defdocDetailEntity = BeanMapper.map(uniqueBean, DefdocDetailEntity.class);
			defdocDetailEntity.setUpdateUserCode(InvocationInfoProxy.getUsercode());
			defdocDetailEntity.setUpdateTime(new Date());
			defdocDetailEntity.setSyncEsFlag(0);
//			defdocDetailEntity.setTenantId(InvocationInfoProxy.getTenantid());
			defdocDetailService.updateDetail(defdocDetailEntity);
			
			return CommonResponse.success("修改成功");
		}else{
			DefdocDetailEntity defdocDetailEntity = BeanMapper.map(defdocDetailVo, DefdocDetailEntity.class);
			List<DefdocDetailVO> detailVOS = defdocDetailService.queryListByDefdocId(Collections.singletonList(defdocDetailEntity.getDefdocId()));
			if(!ListUtil.isEmpty(detailVOS)){
				detailVOS.forEach(e->{
					if(e.getCode().equals(defdocDetailEntity.getCode())){
						throw new BusinessException("保存报错，档案项编码与【"+e.getName()+"】重复！");
					}
				});
			}
			defdocDetailEntity.setId(IdWorker.getId());
			if(defdocDetailEntity.getParentId() != null && defdocDetailEntity.getParentId() > 0) {
				DefdocDetailVO uniqueBean = defdocDetailService.queryDetail(defdocDetailEntity.getParentId());
				defdocDetailEntity.setEnabled(uniqueBean.getEnabled());
				defdocDetailEntity.setInnerCode(uniqueBean.getInnerCode()+"|"+defdocDetailEntity.getId());
			}else{
				defdocDetailEntity.setInnerCode(defdocDetailEntity.getId().toString());
				defdocDetailEntity.setEnabled(1);
			}
			defdocDetailEntity.setCreateUserCode(InvocationInfoProxy.getUsercode());
			defdocDetailEntity.setCreateTime(new Date());
			defdocDetailEntity.setDr(0);
			defdocDetailEntity.setSyncEsFlag(0);
//			defdocDetailEntity.setTenantId(InvocationInfoProxy.getTenantid());
			defdocDetailService.saveDetail(defdocDetailEntity);
			
			return CommonResponse.success("保存成功");
		}
	}
	
	/**
	 * 根据主键ID查询编码规则明细详情
	 * 
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<DefdocDetailVO> queryDetail(@RequestParam Long id) {
		DefdocDetailVO defdocDetailVo = defdocDetailService.queryDetail(id);
		return CommonResponse.success(defdocDetailVo);
	}
	
	/**
	 * 删除
	 * 
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/delete", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<String> delete(@RequestParam Long id) {
		//先查询该档案项有没有子节点
		List<DefdocDetailVO> defdocDetails = defdocDetailService.queryListByPid(id);
		if(defdocDetails != null && defdocDetails.size() > 0) {
			return CommonResponse.error("该档案项有子节点，不允许删除");
		}else{
			defdocDetailService.delete(id);
			return CommonResponse.success("删除成功");
		}
	}

	
	/**
	 * 查询列表
	 * 
	 * @param queryParam
	 * @return
	 */
	@RequestMapping(value = "/queryList", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<JSONObject> queryList(@RequestBody QueryParam queryParam) {
		queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
		List<DefdocDetailEntity> dataList = defdocDetailService.queryList(queryParam);
		List<Map> resultMapList = BeanMapper.mapList(dataList, Map.class);
		JSONObject jsonObject = new JSONObject();
		jsonObject.put("data", ResultAsTree.createTreeData(resultMapList));
		return CommonResponse.success(jsonObject);
	}

	/** 根据自定义档案编码查询自定义档案项 无鉴权 */
	@GetMapping("/no_auth/detailListByDefdocCode")
	@ResponseBody
	public CommonResponse<List<Map<String, Object>>> queryDetailListByDefDocCode(@RequestParam String defdocTypeCode,
		@RequestParam(value = "range", required = false) String range,@RequestParam(value = "condition", required = false) String condition) {
		return queryDetailListByDefdocCode(defdocTypeCode,range,condition);
	}

	@GetMapping("/detailListByDefdocCode")
	@ResponseBody
	public CommonResponse<List<Map<String, Object>>> queryDetailListByDefdocCode(@RequestParam String defdocTypeCode,
		@RequestParam(value = "range", required = false) String range,@RequestParam(value = "condition", required = false) String condition) {
		QueryParam queryParam = new QueryParam();
		DefdocVO defdocVo = defdocService.queryUniqueByCode(defdocTypeCode);
		List<String> detailIds = null;
		List<Long> docIds = null;
		if(null == defdocVo) {
			return CommonResponse.success("查询成功！", new ArrayList<>());
		}
		Long tenantId = InvocationInfoProxy.getTenantid();
		if(tenantId==null){
			tenantId = Long.parseLong(OMS_TENANT);
		}
		logger.info("detailListByDefdocCode ==== condition-----"+condition);
		if(org.apache.commons.lang.StringUtils.isNotBlank(condition) && !"null".equals(condition)) {
			JSONObject jsonParam = JSONObject.parseObject(condition);
			if(null != jsonParam.get("tenantId")) {
				tenantId = Long.valueOf(jsonParam.get("tenantId").toString());
			}
			if(StringUtils.isNotEmpty(jsonParam.getString("attrCode"))){
				queryParam.getParams().put("attrCode", new Parameter(QueryParam.EQ, jsonParam.getString("attrCode")));
			}
			if(StringUtils.isNotEmpty(jsonParam.getString("detailIds"))){
				detailIds = Arrays.asList(jsonParam.getString("detailIds").split(","));
			}
			if(StringUtils.isNotEmpty(jsonParam.getString("docCodes"))){
				QueryParam docParam = new QueryParam();
				docParam.getParams().put("code",new Parameter(QueryParam.IN,jsonParam.getString("docCodes")));
				List<DefdocEntity> entities = defdocService.queryList(docParam,false);
				if(ListUtil.isNotEmpty(entities)){
					docIds =  entities.stream().map(DefdocEntity::getId).collect(Collectors.toList());
				}
			}
		}

		queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, tenantId));
		if(ListUtil.isNotEmpty(docIds)){
			queryParam.getParams().put("docIds", new Parameter(QueryParam.IN, docIds));
		}else {
			queryParam.getParams().put("defdocId", new Parameter(QueryParam.EQ, defdocVo.getId()));
		}
		if(ListUtil.isNotEmpty(detailIds)){
			queryParam.getParams().put("detailIds", new Parameter(QueryParam.IN, detailIds));
		}
		if(StringUtils.isNotBlank(range) && "all".equals(range)){

		}else{
			queryParam.getParams().put("enabled", new Parameter(QueryParam.EQ, 1));
		}
		List<DefdocDetailEntity> dataList = defdocDetailService.queryList(queryParam);
		List<Map> resultMapList = BeanMapper.mapList(dataList, Map.class);
		return CommonResponse.success(ResultAsTree.createTreeData(resultMapList));
	}

	/**
	 * 更新父节点状态，同时更新子节点状态
	 * 
	 * @param defdocDetailVo
	 * @return
	 */
	@RequestMapping(value = "/enabled/update", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> updateEnabled(@RequestBody DefdocDetailVO defdocDetailVo) {
		defdocDetailService.updateEnabled(defdocDetailVo);
		return CommonResponse.success("更新成功");
	}
	
	/**
	 * 根据档案编号查询列表(code 作为了key)
	 * 
	 * @param defdocCode
	 * @return
	 */
	@RequestMapping(value = "/queryListByCode", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<JSONObject> queryListByCode(@RequestParam String defdocCode) {
		DefdocVO defdocVo = defdocService.queryUniqueByCode(defdocCode);
		QueryParam queryParam = new QueryParam();
		queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
		queryParam.getParams().put("defdocId", new Parameter(QueryParam.EQ, defdocVo.getId()));
		queryParam.getParams().put("enabled", new Parameter(QueryParam.EQ, 1));
		List<DefdocDetailEntity> dataList = defdocDetailService.queryList(queryParam);
		List<Map> resultMapList = new ArrayList<Map>();
		Map<String, Object> resultMap ;
		for(DefdocDetailEntity entity : dataList) {
			resultMap = new HashMap<String, Object>();
			resultMap.put("id", entity.getId());
			resultMap.put("text", entity.getName());
			resultMap.put("value", entity.getCode());
			resultMap.put("parentId", entity.getParentId());
			resultMapList.add(resultMap);
		}
		JSONObject jsonObject = new JSONObject();
		jsonObject.put("data", ResultAsTree.createTreeData(resultMapList));
		return CommonResponse.success(jsonObject);
	}
	
	/**
	 * 根据档案编号查询列表(id 作为了key)
	 * 
	 * @param defdocCode
	 * @return
	 */
	@RequestMapping(value = "/queryTreeList", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<JSONObject> queryTreeList(@RequestParam String defdocCode, @RequestParam(value = "tenantId", required = false) Long tenantId) {
		DefdocVO defdocVo = defdocService.queryUniqueByCode(defdocCode);
		if(null == tenantId) {
			tenantId = InvocationInfoProxy.getTenantid();
		}
		QueryParam queryParam = new QueryParam();
		queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, tenantId));
		queryParam.getParams().put("defdocId", new Parameter(QueryParam.EQ, defdocVo.getId()));
		queryParam.getParams().put("enabled", new Parameter(QueryParam.EQ, 1));
		List<DefdocDetailEntity> dataList = defdocDetailService.queryList(queryParam);
		List<Map> resultMapList = new ArrayList<Map>();
		Map<String, Object> resultMap ;
		for(DefdocDetailEntity entity : dataList) {
			resultMap = new HashMap<String, Object>();
			resultMap.put("id", entity.getId());
			resultMap.put("key", entity.getId());
			if(entity.getParentId() != null && entity.getParentId() > 0) {
				resultMap.put("label", entity.getName()+"("+entity.getCode()+")");
				resultMap.put("title", entity.getName()+"("+entity.getCode()+")");
				resultMap.put("value", entity.getName()+"("+entity.getCode()+")");
			}else{
				resultMap.put("label", entity.getName());
				resultMap.put("title", entity.getName());
				resultMap.put("value", entity.getName());
			}
			resultMap.put("parentId", entity.getParentId());
			resultMapList.add(resultMap);
		}
		JSONObject jsonObject = new JSONObject();
		jsonObject.put("data", ResultAsTree.createTreeData(resultMapList));
		return CommonResponse.success(jsonObject);
	}
	
	/**
	 * 根据档案编号查询列表(参照)
	 * 
	 * @return
	 */
	@RequestMapping(value = "queryReferList", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<IPage> queryReferList(
			@RequestParam(defaultValue = "1") int pageNumber,
			@RequestParam(defaultValue = "10") int pageSize,
			@RequestParam(required = false) String searchText,
			@RequestParam(required=false) String condition) {
		IPage<DefdocDetailVO> page = new Page();
		try {
			JSONObject json = JSONObject.parseObject(condition);
			String defCode = "";
			Long tenantId = InvocationInfoProxy.getTenantid();
			if(json!=null&&json.get("defCode")!=null){
				defCode = json.get("defCode").toString();
			}else{
				return CommonResponse.error("档案编码不能为空refCode");
			}
			//增加自定义查询租户范围  modify by cj 2021年1月19日 15:32:12
			if(null != json && json.get("tenantId") != null) {
				tenantId = Long.valueOf(json.getString("tenantId"));
			}

			DefdocVO defdocVo = defdocService.queryUniqueByCode(defCode);
			QueryParam queryParam = new QueryParam();
			queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, tenantId));
			queryParam.getParams().put("defdocId", new Parameter(QueryParam.EQ, defdocVo.getId()));
			queryParam.getParams().put("enabled", new Parameter(QueryParam.EQ, 1));
			queryParam.getParams().put("searchText", new Parameter(QueryParam.EQ, searchText));
			queryParam.setPageIndex(pageNumber);
			queryParam.setPageSize(pageSize);
//			defdocDetailService.queryPage(queryParam, false);
			List<DefdocDetailEntity> dataList = defdocDetailService.queryList(queryParam);
			List<DefdocDetailVO> vos = BeanMapper.mapList(dataList, DefdocDetailVO.class);
			page.setCurrent(pageNumber);
			page.setRecords(vos);
			page.setSize(pageSize);
			page.setTotal(vos.size());
		}catch(Exception e) {
			return CommonResponse.error("查询失败");
		}
		
		return CommonResponse.success(page);
	}

	/**
	 * 根据档案编号查询档案项 树型(参照)
	 *
	 * @return
	 */
	@RequestMapping(value = "queryDefDocReferTree", method = RequestMethod.GET)
	@ResponseBody
	public List<Map<String, Object>> queryDefDocReferTree(
			@RequestParam(required = false) String searchText,
			@RequestParam(required=false) String condition) {
		List<Map<String, Object>> vos = new ArrayList<>();
		try {
			JSONObject json = JSONObject.parseObject(condition);
			String defCode = "";
			Long tenantId = InvocationInfoProxy.getTenantid();
			if(json!=null&&json.get("defCode")!=null){
				defCode = json.get("defCode").toString();
			}else{
				throw new BusinessException("档案编码不能为空refCode");
			}
			//增加自定义查询租户范围  modify by cj 2021年1月19日 15:32:12
			if(json.get("tenantId") != null) {
				tenantId = Long.valueOf(json.getString("tenantId"));
			}

			DefdocVO defdocVo = defdocService.queryUniqueByCode(defCode);
			QueryParam queryParam = new QueryParam();
			queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, tenantId == null?999999L:tenantId));
			queryParam.getParams().put("defdocId", new Parameter(QueryParam.EQ, defdocVo.getId()));
			queryParam.getParams().put("enabled", new Parameter(QueryParam.EQ, 1));
			queryParam.getParams().put("searchText", new Parameter(QueryParam.EQ, searchText));
			List<DefdocDetailEntity> dataList = defdocDetailService.queryList(queryParam);
			List<Map> resultMapList = new ArrayList<>();
			Map<String, Object> resultMap;
			for(DefdocDetailEntity entity : dataList) {
				resultMap = new HashMap<>();
				resultMap.put("id", entity.getId());
				resultMap.put("text", entity.getName());
				resultMap.put("name", entity.getName());
				resultMap.put("value", entity.getCode());
				resultMap.put("parentId", entity.getParentId());
				resultMapList.add(resultMap);
			}
			vos = ResultAsTree.createTreeData(resultMapList);
		}catch(Exception e) {
			throw new BusinessException("查询失败");
		}

		return vos;
	}

	/**
	 * 一键同步平台基础档案
	 * 
	 * @param
	 * @return
	 */
	@RequestMapping(value = "/sync", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<String> syncDefdocDetails() {
		Long tenantId = InvocationInfoProxy.getTenantid();
		if(OMS_TENANT.equals(tenantId.toString())) {
			return CommonResponse.error("平台运营人员不能操作此功能");
		}
//		defdocDetailService.insertDetailsFromPlatform();
		
		return CommonResponse.success("同步成功");
	}
	
	@RequestMapping(value = "/queryReferTree", method = RequestMethod.GET)
	@ResponseBody
    public List<DefdocDetailEntity> queryOrgTree(@RequestParam(required = false) String searchText,
		@RequestParam(required = true) String condition) {
		JSONObject json = JSONObject.parseObject(condition);
		String defCode = "";
		String detailCodes = null;
		if(json!=null&&json.get("defCode")!=null){
			defCode = json.get("defCode").toString();
			detailCodes = json.getString("detailCodes");//格式：detailCodes:"code1,code2,code3"
		}else{
			throw new BusinessException("档案编码不能为空refCode");
		}
		DefdocVO defdocVo = defdocService.queryUniqueByCode(defCode);
		QueryParam queryParam = new QueryParam();
		queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
		queryParam.getParams().put("defdocId", new Parameter(QueryParam.EQ, defdocVo.getId()));
		queryParam.getParams().put("enabled", new Parameter(QueryParam.EQ, 1));


		List<DefdocDetailEntity> dataList = Lists.newArrayList();
		if(StringUtils.isNotBlank(detailCodes)) {
			String[] codes = detailCodes.split(",");
			for (String code : codes) {
				queryParam.getParams().put("code", new Parameter(QueryParam.EQ, code));
				List<DefdocDetailEntity> detailPList = defdocDetailService.queryList(queryParam);
				if(ListUtil.isNotEmpty(detailPList)){
					DefdocDetailEntity detailP = detailPList.get(0);
					queryParam.getParams().remove("code");
					queryParam.getParams().put("innerCode", new Parameter(QueryParam.LIKE, detailP.getInnerCode()));
					if(StringUtils.isNotBlank(searchText)) {
						queryParam.getParams().put("searchText", new Parameter(QueryParam.LIKE, searchText));
					}
					List<DefdocDetailEntity> resultList = defdocDetailService.queryList(queryParam);
					if(ListUtil.isNotEmpty(resultList)){
						dataList.addAll(resultList);
					}
					queryParam.getParams().remove("innerCode");
					queryParam.getParams().remove("searchText");
				}
			}
		}else {
			if(StringUtils.isNotBlank(searchText)) {
				queryParam.getParams().put("searchText", new Parameter(QueryParam.LIKE, searchText));
			}
			dataList = defdocDetailService.queryList(queryParam);
		}

		return DefdocDetailAsTree.createTreeData(dataList);
	}

	@RequestMapping(value = "/initDefdoc", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<String> initDefdoc() {
		defdocDetailService.initDefdoc();
		return  CommonResponse.success();
	}
}
