package com.ejianc.foundation.support.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.support.bean.ModuleEntity;
import com.ejianc.foundation.support.bean.ReferEntity;
import com.ejianc.foundation.support.service.IModuleService;
import com.ejianc.foundation.support.service.IReferService;
import com.ejianc.foundation.support.vo.ModuleVO;
import com.ejianc.foundation.support.vo.ReferVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.List;

/**
 * 参照测试用例
 * 
 * @author liyongjia
 *
 */
@Controller
@RequestMapping("referTest")
public class ReferTestController implements Serializable {

    private Logger logger = LoggerFactory.getLogger(this.getClass());
	private static final long serialVersionUID = 1L;

	@Autowired
	private IReferService referService;
    @Autowired
    private IModuleService moduleService;

    /*
     * 
     * 树
     * 
     * */
    @GetMapping("loadReferModuleTree")
    public List<ModuleEntity> loadReferModuleTree() {
        List<ModuleEntity> dataList = null;
        try {
        	QueryParam queryParam = new QueryParam();
            dataList = moduleService.queryList(queryParam, false);
        } catch (Exception e) {
            logger.error("查询所有模块树异常: ", e);
            return null;
        }

        return dataList;
    }

    /*
     * 
     * 异步树
     * 
     * */
//	@RequestMapping(value = "/lazyReferModuleTree", method = RequestMethod.GET)
//	@ResponseBody
//    public List<ModuleVO> lazyReferModuleTree(@RequestParam(required=false) String condition,
//    		@RequestParam(required=false) String pid) {
//        List<ModuleVO> dataList = null;
//        try {
//        	
//              dataList = moduleService.loadModulesTreeWithKeywords(StringUtils.isNotBlank(pid)?Long.parseLong(pid):null, null);
//        } catch (Exception e) {
//            logger.error("查询所有模块树异常: ", e);
//            return null;
//        }
//
//        return dataList;
//    }

    /*
     * 
     * 表
     * 
     * */
    @GetMapping("loadReferModuleList")
    public CommonResponse<IPage<ModuleVO>> loadReferModuleList(
			@RequestParam(defaultValue = "1") int pageNumber,
			@RequestParam(defaultValue = "10") int pageSize
			) {
        try {
        	QueryParam queryParam = new QueryParam();
        	queryParam.setPageSize(pageSize);
        	queryParam.setPageIndex(pageNumber);
        	IPage<ModuleEntity> pageData = moduleService.queryPage(queryParam, false);
        	IPage<ModuleVO> result = new Page<>(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        	result.setRecords(BeanMapper.mapList(pageData.getRecords(), ModuleVO.class));

            return CommonResponse.success(result);
        } catch (Exception e) {
            logger.error("查询所有模块树异常: ", e);
            return null;
        }
    }
    
    /*
     * 
     * 表
     * 
     * */
	@RequestMapping(value = "/loadReferList", method = RequestMethod.GET)
	@ResponseBody
    public CommonResponse<IPage<ReferVO>> loadReferList(
			@RequestParam(defaultValue = "1") int pageNumber,
			@RequestParam(defaultValue = "10") int pageSize,
			@RequestParam(required=false) String relyCondition,
			@RequestParam(required=false) String relyNode,
			@RequestParam(required=false) String condition
			) {
        try {
        	QueryParam queryParam = new QueryParam();
        	queryParam.setPageSize(pageSize);
        	queryParam.setPageIndex(pageNumber);
        	if(StringUtils.isNotBlank(relyCondition)){
        		Long moduleId = Long.parseLong(relyCondition.split("=")[1]);
        		queryParam.getParams().put("referModule", new Parameter("eq",moduleId));
        	}
    		
        	IPage<ReferEntity> pageData = referService.queryPage(queryParam, false);
        	IPage<ReferVO> result = new Page<>(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        	result.setRecords(BeanMapper.mapList(pageData.getRecords(), ReferVO.class));

            return CommonResponse.success(result);
        } catch (Exception e) {
            logger.error("查询所有模块树异常: ", e);
            return null;
        }
    }

	
	/**
	 * 自动匹配
	 * 
	 * @param projectId
	 * @return
	 */
	@RequestMapping(value = "/queryModuleListAutoSelect", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<List<ModuleVO>> queryModuleListAutoSelect(
			@RequestParam(required=false) String condition,
			@RequestParam(required=false) String searchText,
			@RequestParam String maxSize) {
    	QueryParam queryParam = new QueryParam();
    	queryParam.setPageSize(Integer.parseInt(maxSize));
    	queryParam.setPageIndex(1);
    	if(StringUtils.isNotBlank(searchText)){
    		queryParam.getParams().put("moduleName", new Parameter("like",searchText));
    	}
    	IPage<ModuleEntity> pageData = moduleService.queryPage(queryParam, false);
    	List<ModuleVO> dataList = BeanMapper.mapList(pageData.getRecords(), ModuleVO.class);
		return CommonResponse.success(dataList);
	}
}
