package com.ejianc.foundation.support.controller.api;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.ejianc.foundation.billcode.BillCodeException;
import com.ejianc.foundation.support.service.IBillCodeGenerator;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.response.CommonResponse;

import java.util.List;

@RestController
@RequestMapping("/api/billCodeApi/")
public class BillCodeApi {
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IBillCodeGenerator generator;

	/**
	 * 根据编码规则生成单据号
	 *
	 * @param code
	 * @param tenantId
	 * @return
	 * @throws BillCodeException
	 */
	@GetMapping("getByCode")
	public CommonResponse<String> getCodeBatchByRuleCode(@RequestParam(value = "code") String code, @RequestParam("tenantId") Long tenantId) throws BillCodeException {
		try {
			String billCode = generator.generateBillCodeById(code, tenantId);
			return CommonResponse.success("获取编码成功！", billCode);
		} catch (Exception e) {
			logger.error("编码获取失败", e);
		}
		return CommonResponse.error("编码获取失败！");
	}
	
	/**
	 * 单据编码自动生成 2021-12-17  guoming
	 * 
	 * @param billCodeParam
	 * @return
	 */
	@PostMapping(value = "generateBillCode")
	public CommonResponse<String> generateBillCode(@RequestBody BillCodeParam billCodeParam) {
		try {
			String billCode = generator.generateBillCode(billCodeParam);
			return CommonResponse.success("获取编码成功！", billCode);
		} catch (Exception e) {
			logger.error("编码获取失败", e);
		}
		return CommonResponse.error("编码获取失败！");
	}

	/**
	 * 根据编码规则主键ID获取按对应规则生成的编码(批量)
	 *
	 * @param code
	 * @param tenantId
	 * @param count
	 * @return
	 */
	@GetMapping(value = "getCodeBatchByCode")
	public CommonResponse<List<String>> getCodeBatchByRuleCode(@RequestParam(value = "code") String code,
															   @RequestParam(value = "tenantId") Long tenantId,
															   @RequestParam(value = "count") int count) {
		try {
			List<String> codeList = generator.generateBillCodeById(code, tenantId, count);
			return CommonResponse.success("获取编码成功！", codeList);
		} catch (Exception e) {
			logger.error("编码获取失败", e);
		}
		return CommonResponse.error("编码获取失败！");
	}

}
