package com.ejianc.foundation.support.service.impl;

import com.ejianc.foundation.support.vo.PublishVO;
import com.ejianc.foundation.util.DataTransferUtil;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.google.gson.Gson;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.foundation.support.mapper.BillParamMapper;
import com.ejianc.foundation.support.bean.BillParamEntity;
import com.ejianc.foundation.support.service.IBillParamService;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 业务单据控制参数
 * 
 * @author generator
 * 
 */
@Service("billParamService")
public class BillParamServiceImpl extends BaseServiceImpl<BillParamMapper, BillParamEntity> implements IBillParamService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private Gson gson = new Gson();
    /**
     * @param publishVO
     * @Author mrsir_wxp
     * @Date 2021/1/15 发布参数
     * @Description publishParamConfig
     * @Param [publishVO]
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.Boolean>
     */
    @Override
    public CommonResponse<String> publishParamConfig(PublishVO publishVO) {
        try {
            String targetEnv = publishVO.getTarget();
            if (StringUtils.isBlank(targetEnv)) {
                return CommonResponse.error("发布数据失败:目标环境域名不能为空!");
            }
            if (ListUtil.isEmpty(publishVO.getIdList())) {
                return CommonResponse.error("发布数据失败:要发布的参数数据不能为空!");
            }
            QueryParam param = new QueryParam();
            param.getParams().put("id",new Parameter(QueryParam.IN,publishVO.getIdList()));
            List<BillParamEntity> entities = this.queryList(param,false);
            if(ListUtil.isEmpty(entities)){
                return CommonResponse.error("发布数据失败:没有找到要发布的数据!");
            }
            Map<String, Object> params = new HashMap<>();
            params.put("sql", getSql(entities));
            String paramterStr = gson.toJson(params);
            logger.info("发布 参数控制 sql= "+paramterStr);
            String url = publishVO.getTarget() + DataTransferUtil.DATA_TRANSFER_REST_URL2;
            String result = ReferHttpClientUtils.postByJson(url, paramterStr);
            logger.info("发布{}数据返回的结果：---------------{}",publishVO.getTarget(),result);
            return gson.fromJson(result, CommonResponse.class);
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("发布参数失败：---------------"+e.getMessage());
            return CommonResponse.error("发布参数失败:" + e.getMessage());
        }
    }

    private List<String> getSql(List<BillParamEntity> ids){
        List<String> sql = new ArrayList<>();
        String  sb = "DELETE FROM `ejc-support`.`ejc_bill_param` WHERE id in (";
        for (int i = 0; i < ids.size(); i++) {
            sb = sb + "'"+ids.get(i).getId()+"'";
            if(i<ids.size()-1){
                sb = sb + ",";
            }
        }
        sb = sb + ") ; ";
        sql.add(sb);
        System.out.println(sb);
        sb = "INSERT INTO `ejc-support`.`ejc_bill_param` " ;
        sb = sb + " ( id, `name`, `code`,tenant_id, bill_name, role_name,role_value,control_type, memo,module_id,sequence, dr) values " ;
        for (int i = 0; i < ids.size(); i++) {
            BillParamEntity entity = ids.get(i);
            sb = sb + "('"+entity.getId()+"'," ;
            sb = sb +"'"+entity.getName()+"'," ;
            sb = sb +"'"+entity.getCode()+"'," ;
            sb = sb +"'"+entity.getTenantId()+"'," ;
            sb = sb +"'"+entity.getBillName()+"'," ;
            sb = sb +"'"+entity.getRoleName()+"'," ;
            sb = sb +"'"+entity.getRoleValue()+"'," ;
            sb = sb +"'"+entity.getControlType()+"'," ;
            sb = sb +"'"+entity.getMemo()+"'," ;
            sb = sb +"'"+entity.getModuleId()+"'," ;
            sb = sb +"'"+entity.getSequence()+"'," ;
            sb = sb +entity.getDr()+")" ;
            if(i<ids.size()-1){
                sb = sb +",\n" ;
            }
        }
        sb = sb + " ; ";
        sql.add(sb);
        System.out.println(sb);
        return sql;
    }
}
