package com.ejianc.foundation.support.service.impl;

import java.util.List;

import com.alibaba.fastjson.JSONObject;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.foundation.support.mapper.DataTransferMapper;
import com.ejianc.foundation.support.service.IDataTransferService;
import com.ejianc.framework.core.response.CommonResponse;

@Service
public class DataTransferService implements IDataTransferService {

	private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private DataTransferMapper dataTransferMapper;
	@Autowired
	private SqlSessionTemplate sqlSessionTemplate;
	
	@Override
	public CommonResponse<String> executeSql(List<String> sqls) {
		SqlSession session = sqlSessionTemplate.getSqlSessionFactory().openSession(ExecutorType.BATCH, false);
		LOGGER.info("待发布sql:{}", JSONObject.toJSONString(sqls));
		try {
			String sqlUnion = "";
	        for (int i = 0; i < sqls.size(); i++) {
	        	sqlUnion += sqls.get(i);
	            if (i != 0 && (i % 400 == 0 || i == (sqls.size() - 1))) {
	            	dataTransferMapper.executeSql(sqlUnion);
	                //手动每400条提交一次，提交后无法回滚
	                session.commit();
	                //清理缓存，防止溢出
	                session.clearCache();
					LOGGER.info("发布成功的sql:{}",sqlUnion);
	                sqlUnion = "";
	            }
	        }
	    } catch (Exception e) {
	        //没有提交的数据可以回滚
			LOGGER.error("1执行SQL失败：{}",e.getMessage());
			LOGGER.error("2执行SQL失败",e);
	        session.rollback();
	        e.printStackTrace();
			return CommonResponse.error("存在发布失败数据，请查看日志！");
	    } finally {
	        session.close();
	    }
//		String sqlUnion = "";
//		for(String sql : sqls){
//			sqlUnion += (sql+";");
//		}
//		dataTransferMapper.executeSql(sqlUnion);
		return CommonResponse.success("发布成功");
	}

}
