package com.ejianc.foundation.support.service.impl;

import com.ejianc.foundation.support.bean.ParamRegisterSetEntity;
import com.ejianc.foundation.support.service.IParamRegisterSetService;
import com.ejianc.foundation.support.vo.PublishVO;
import com.ejianc.foundation.util.DataTransferUtil;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.google.gson.Gson;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.foundation.support.mapper.ParamRegisterMapper;
import com.ejianc.foundation.support.bean.ParamRegisterEntity;
import com.ejianc.foundation.support.service.IParamRegisterService;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 参数注册
 * 
 * @author generator
 * 
 */
@Service("paramRegisterService")
public class ParamRegisterServiceImpl extends BaseServiceImpl<ParamRegisterMapper, ParamRegisterEntity> implements IParamRegisterService{
    private Gson gson = new Gson();
    @Autowired
    private IParamRegisterSetService iParamRegisterSetService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    /**
     * @param id
     * @Author mrsir_wxp
     * @Date 2021/1/15 配置租户参数
     * @Description configTenantParam
     * @Param [id]
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.Boolean>
     */
    @Override
    public CommonResponse<Boolean> configTenantParam(Long id) {
        String msg = "配置成功";
        ParamRegisterEntity entity = this.selectById(id);
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("code", new Parameter(QueryParam.EQ, entity.getCode()));
        List<ParamRegisterSetEntity> setEntities = iParamRegisterSetService.queryList(param,false);
        if(ListUtil.isEmpty(setEntities)){
            ParamRegisterSetEntity setEntity = BeanMapper.map(entity, ParamRegisterSetEntity.class);
            setEntity.setTenantId(InvocationInfoProxy.getTenantid());
            setEntity.setId(null);
            setEntity.setValueData(entity.getDefaultValue());
            iParamRegisterSetService.saveOrUpdate(setEntity);
        }else {
            msg = "已配置，无需再次配置！";
        }
        return CommonResponse.success(msg,true);
    }

    /**
     * @param publishVO
     * @Author mrsir_wxp
     * @Date 2021/1/15 发布参数
     * @Description publishParamConfig
     * @Param [publishVO]
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.Boolean>
     */
    @Override
    public CommonResponse<String> publishParamConfig(PublishVO publishVO) {
        try {
            String targetEnv = publishVO.getTarget();
            if (StringUtils.isBlank(targetEnv)) {
                return CommonResponse.error("发布数据失败:目标环境域名不能为空!");
            }
            if (ListUtil.isEmpty(publishVO.getIdList())) {
                return CommonResponse.error("发布数据失败:要发布的参数数据不能为空!");
            }
            QueryParam param = new QueryParam();
            param.getParams().put("id",new Parameter(QueryParam.IN,publishVO.getIdList()));
            List<ParamRegisterEntity> entities = this.queryList(param,false);
            if(ListUtil.isEmpty(entities)){
                return CommonResponse.error("发布数据失败:没有找到要发布的数据!");
            }
            Map<String, Object> params = new HashMap<>();
            params.put("sql", getSql(entities));
            String paramterStr = gson.toJson(params);
            logger.info("发布 参数控制 sql= "+paramterStr);
            String url = publishVO.getTarget() + DataTransferUtil.DATA_TRANSFER_REST_URL2;
            String result = ReferHttpClientUtils.postByJson(url, paramterStr);
            logger.info("发布数据返回的结果：---------------"+result);
            return gson.fromJson(result, CommonResponse.class);
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("发布参数失败：---------------"+e.getMessage());
            return CommonResponse.error("发布参数失败:" + e.getMessage());
        }
    }

    private List<String> getSql(List<ParamRegisterEntity> ids){
        List<String> sql = new ArrayList<>();
        String  sb = new String("DELETE FROM `ejc-support`.`ejc_p_register` WHERE id in (");
        for (int i = 0; i < ids.size(); i++) {
            sb = sb + "'"+ids.get(i).getId()+"'";
            if(i<ids.size()-1){
                sb = sb + ",";
            }
        }
        sb = sb + ") ; ";
        sql.add(sb);
        System.out.println(sb);
        sb = "INSERT INTO `ejc-support`.`ejc_p_register` " ;
        sb = sb + " ( id, `name`, `code`, rangee, default_value, memo, dr, tenant_id ) values " ;
        for (int i = 0; i < ids.size(); i++) {
            ParamRegisterEntity entity = ids.get(i);
            sb = sb + "('"+entity.getId()+"'," ;
            sb = sb +"'"+entity.getName()+"'," ;
            sb = sb +"'"+entity.getCode()+"'," ;
            sb = sb +"'"+entity.getRangee()+"'," ;
            sb = sb +"'"+entity.getDefaultValue()+"'," ;
            sb = sb +"'"+entity.getMemo()+"'," ;
            sb = sb +entity.getDr()+"," ;
            sb = sb +entity.getTenantId()+")" ;
            if(i<ids.size()-1){
                sb = sb +",\n" ;
            }
        }
        sb = sb + " ; ";
        sql.add(sb);
        System.out.println(sb);
        return sql;
    }

}
