/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.controller.api;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.bean.ProjectEntity;
import com.ejianc.foundation.share.service.IProjectService;
import com.ejianc.foundation.share.vo.ProjectPriceVO;
import com.ejianc.foundation.share.vo.ProjectVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/zjkj/projectApi/"})
public class ZjkjProjectApi {
    @Autowired
    private IProjectService projectService;
    @Autowired
    private IOrgApi iOrgApi;

    @GetMapping(value={"queryDetailById"})
    public CommonResponse<ProjectVO> queryDetailById(@RequestParam(value="id") Long id) {
        ProjectEntity entity = (ProjectEntity)((Object)this.projectService.selectById(id));
        ProjectVO vo = (ProjectVO)BeanMapper.map((Object)((Object)entity), ProjectVO.class);
        ArrayList<ProjectPriceVO> projectPriceList = new ArrayList<ProjectPriceVO>();
        ProjectPriceVO ProjectPriceVO2 = (ProjectPriceVO)BeanMapper.map((Object)((Object)entity), ProjectPriceVO.class);
        projectPriceList.add(ProjectPriceVO2);
        vo.setProjectPriceList(projectPriceList);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/saveProject"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ProjectVO> saveProject(@RequestBody ProjectVO projectVO) {
        ProjectVO vo = this.projectService.saveData(projectVO);
        return CommonResponse.success((String)"\u4fee\u6539\u9879\u76ee\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetailByparam"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ProjectVO> queryDetailByparam(@RequestBody Map<String, Object> param) {
        List list;
        ProjectVO vo = null;
        QueryWrapper queryWrapper = new QueryWrapper();
        if (param.get("projectName") != null) {
            queryWrapper.eq((Object)"project_name", param.get("projectName"));
        }
        if (param.get("projectCode") != null) {
            queryWrapper.eq((Object)"bill_code", param.get("projectCode"));
        }
        if ((list = this.projectService.list((Wrapper)queryWrapper)) != null && list.size() > 0) {
            ProjectEntity entity = (ProjectEntity)((Object)list.get(0));
            vo = (ProjectVO)BeanMapper.map((Object)((Object)entity), ProjectVO.class);
            ArrayList<ProjectPriceVO> projectPriceList = new ArrayList<ProjectPriceVO>();
            ProjectPriceVO ProjectPriceVO2 = (ProjectPriceVO)BeanMapper.map((Object)((Object)entity), ProjectPriceVO.class);
            projectPriceList.add(ProjectPriceVO2);
            vo.setProjectPriceList(projectPriceList);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", vo);
    }

    @GetMapping(value={"findProjectNum"})
    CommonResponse<Integer> findProjectNum(@RequestParam(value="section") String section) {
        Integer projectNum = this.projectService.queryProjectNum(section);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)projectNum);
    }

    @GetMapping(value={"findProjectAll"})
    CommonResponse<List<ProjectVO>> findProjectAll() {
        List orgIds = ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        QueryParam param = new QueryParam();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("project_department_id", new Parameter("in", orgIds));
        List list = this.projectService.queryList(param);
        List voList = BeanMapper.mapList((Iterable)list, ProjectVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)voList);
    }

    @PostMapping(value={"queryProjectArray"})
    public CommonResponse<JSONArray> queryProjectArray(@RequestBody List<Long> ids) {
        ArrayList vos = new ArrayList();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.in((Object)"id", ids);
        List entitys = this.projectService.list((Wrapper)queryWrapper);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)JSONArray.parseArray((String)JSONObject.toJSONString((Object)entitys)));
    }

    @PostMapping(value={"queryProjects"})
    @ResponseBody
    CommonResponse<List<ProjectVO>> queryProjects(@RequestBody QueryParam param) {
        Long orgId = InvocationInfoProxy.getOrgId();
        if (param.getParams().get("orgId") != null) {
            orgId = Long.valueOf(String.valueOf(((Parameter)param.getParams().get("orgId")).getValue()));
            param.getParams().remove("orgId");
        }
        List orgIds = ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        if (param.getParams().containsKey("mobileLeave")) {
            CommonResponse response = this.iOrgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
            if (response.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)response.getData()))) {
                orgIds = ((List)response.getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
            }
            param.getParams().remove("mobileLeave");
        }
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("project_department_id", new Parameter("in", orgIds));
        List list = this.projectService.queryList(param);
        List voList = BeanMapper.mapList((Iterable)list, ProjectVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)voList);
    }

    @PostMapping(value={"queryArray"})
    @ResponseBody
    CommonResponse<JSONArray> queryArray(@RequestBody QueryParam param) {
        Long orgId = InvocationInfoProxy.getOrgId();
        if (param.getParams().get("orgId") != null) {
            orgId = Long.valueOf(String.valueOf(((Parameter)param.getParams().get("orgId")).getValue()));
            param.getParams().remove("orgId");
        }
        List orgIds = ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("project_department_id", new Parameter("in", orgIds));
        List list = this.projectService.queryList(param);
        List voList = BeanMapper.mapList((Iterable)list, ProjectVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)JSONArray.parseArray((String)JSONObject.toJSONString((Object)voList)));
    }

    @GetMapping(value={"queryProjectByProjectDepartmentId"})
    public CommonResponse<ProjectVO> queryProjectByProjectDepartmentId(@RequestParam(value="projectDepartmentId") Long projectDepartmentId) {
        ProjectVO vo = new ProjectVO();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"project_department_id", (Object)projectDepartmentId);
        ProjectEntity entity = (ProjectEntity)((Object)this.projectService.getOne((Wrapper)queryWrapper));
        if (entity != null) {
            vo = (ProjectVO)BeanMapper.map((Object)((Object)entity), ProjectVO.class);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)vo);
    }

    @GetMapping(value={"queryProjectsByOrgId"})
    @ResponseBody
    CommonResponse<List<ProjectVO>> queryProjectsByOrgId(@RequestParam(value="orgId") Long orgId) {
        List orgIds = ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        QueryParam param = new QueryParam();
        param.getParams().put("status", new Parameter("eq", (Object)2));
        param.getParams().put("state", new Parameter("eq", (Object)1));
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("project_department_id", new Parameter("in", orgIds));
        List list = this.projectService.queryList(param);
        List voList = BeanMapper.mapList((Iterable)list, ProjectVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)voList);
    }

    @GetMapping(value={"queryArrayByOrgId"})
    @ResponseBody
    CommonResponse<JSONArray> queryArrayByOrgId(@RequestParam(value="orgId") Long orgId) {
        List orgIds = ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        QueryParam param = new QueryParam();
        param.getParams().put("status", new Parameter("eq", (Object)2));
        param.getParams().put("state", new Parameter("eq", (Object)1));
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("project_department_id", new Parameter("in", orgIds));
        List list = this.projectService.queryList(param);
        List voList = BeanMapper.mapList((Iterable)list, ProjectVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)JSONArray.parseArray((String)JSONObject.toJSONString((Object)voList)));
    }
}

