package com.ejianc.foundation.support.controller;

import java.io.Serializable;

import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.service.IBankdocDetailService;
import com.ejianc.foundation.support.vo.BankdocDetailVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.foundation.support.bean.BankdocEntity;
import com.ejianc.foundation.support.service.IBankdocService;
import com.ejianc.foundation.support.vo.BankdocVO;

/**
 * 银行档案类别实体
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("bankdoc")
public class BankdocController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Value("${oms.tenantid}")
    private String OMS_TENANT;

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "SUPPORT_BANK_CODE";//此处需要根据实际修改
    
    @Autowired
    private IBankdocService bankdocService;

    @Autowired
    private IBankdocDetailService bankdocDetailService;
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BankdocVO> saveOrUpdate(@RequestBody BankdocVO saveorUpdateVO) {
        BankdocEntity entity = BeanMapper.map(saveorUpdateVO, BankdocEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        bankdocService.saveOrUpdate(entity, false);
        BankdocVO vo = BeanMapper.map(entity, BankdocVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BankdocVO> queryDetail(@RequestParam Long id) {
        BankdocVO bankdocVo = bankdocService.queryDetail(id);
        return CommonResponse.success(bankdocVo);
    }


    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if(!OMS_TENANT.equals(tenantId.toString())) {
            return CommonResponse.error("您没有权限执行此操作");
        }
        //先判断要删除的该银行类别下面有没有银行档案信息，有档案项不允许删除
        List<BankdocDetailVO> bankdocDetails = bankdocDetailService.queryListByBankdocId(ids);
        if(bankdocDetails != null && bankdocDetails.size() > 0) {
            return CommonResponse.error("删除失败！该银行类别已存在银行档案信息，不允许删除");
        }else{
            bankdocService.delete(ids);
            return CommonResponse.success("删除成功");
        }
    }

    /**
     * 查询待分页的列表
     *
     * @param queryParam
     * @return
     */
    @RequestMapping(value = "/pageList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam queryParam) {
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, OMS_TENANT));
        queryParam.getOrderMap().put("sequence", QueryParam.ASC);
        IPage<BankdocEntity> pageData = bankdocService.queryPage(queryParam, false);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", pageData);
        return CommonResponse.success(jsonObject);
    }
    /**
     * @Description ref 参照查询
     * @param [queryparam]
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/list/ref", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<BankdocEntity>> ref(@RequestParam Integer pageNumber,
                                                   @RequestParam Integer pageSize,
                                                   String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        Map<String, Parameter> param = queryParam.getParams();
        param.put("tenantId", new Parameter(QueryParam.EQ, OMS_TENANT));
        if(!org.apache.commons.lang.StringUtils.isEmpty(searchText)){
            param.put("name",new Parameter(QueryParam.LIKE,searchText));
        }
        queryParam.getOrderMap().put("sequence", QueryParam.ASC);
        IPage<BankdocEntity> pageData = bankdocService.queryPage(queryParam, false);
        return CommonResponse.success("查询数表参照成功", pageData);
    }



}
