package com.ejianc.foundation.support.service.impl;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.foundation.support.bean.BankCategoryEntity;
import com.ejianc.foundation.support.mapper.BankCategoryMapper;
import com.ejianc.foundation.support.service.IBankCategoryService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;


/**
 * 银行类别实体
 * 
 * @author generator
 * 
 */
@Service("bankCategoryService")
public class BankCategoryServiceImpl extends BaseServiceImpl<BankCategoryMapper, BankCategoryEntity> implements IBankCategoryService{

    @Autowired
    private BankCategoryMapper bankCategoryMapper;

    @Override
    public List<BankCategoryEntity> queryByName(String name) {
        LambdaQueryWrapper<BankCategoryEntity> lambda = new LambdaQueryWrapper<BankCategoryEntity>();
        lambda.eq(BankCategoryEntity::getName,name);
        lambda.eq(BankCategoryEntity::getDr,0);
        lambda.eq(BankCategoryEntity::getTenantId,InvocationInfoProxy.getTenantid());
        List<BankCategoryEntity> bankCategoryEntities = bankCategoryMapper.selectList(lambda);
        return bankCategoryEntities;
    }

}
