/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.support.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.support.bean.BillCodeRuleAttrEntity;
import com.ejianc.foundation.support.bean.BillCodeRuleEntity;
import com.ejianc.foundation.support.service.IBillCodeRuleAttrService;
import com.ejianc.foundation.support.service.IBillCodeRuleService;
import com.ejianc.foundation.support.vo.BillCodeRuleAttrVO;
import com.ejianc.foundation.support.vo.BillCodeRuleVO;
import com.ejianc.foundation.support.vo.PublishVO;
import com.ejianc.foundation.util.DataTransferUtil;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/billcoderule/"})
public class BillCodeRuleController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private Gson gson = new Gson();
    @Autowired
    private IBillCodeRuleService billTypeRuleService;
    @Autowired
    private IBillCodeRuleAttrService billCodeRuleAttrService;
    @Value(value="${oms.tenantid}")
    private Long omTenantId;

    @PostMapping(value={"pageList"})
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam queryParam) {
        try {
            queryParam.getParams().put("tenantId", new Parameter("eq", (Object)this.omTenantId));
            IPage pageData = this.billTypeRuleService.queryPage(queryParam, false);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("data", (Object)pageData);
            return CommonResponse.success((Object)jsonObject);
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u5355\u636e\u7f16\u7801\u89c4\u5219\u5217\u8868\u5f02\u5e38\uff0c", (Throwable)e);
            return CommonResponse.error((String)(null != e.getMessage() ? e.getMessage() : "\u67e5\u8be2\u5355\u636e\u7f16\u7801\u89c4\u5219\u5217\u8868\u5931\u8d25\uff0c"));
        }
    }

    @PostMapping(value={"delete"})
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        try {
            Long curTenantId = InvocationInfoProxy.getTenantid();
            if (!this.omTenantId.equals(curTenantId)) {
                this.logger.error("\u975e\u8fd0\u8425\u5e73\u53f0\u79df\u6237-\u3010tenantId-{},userId-{}\u3011\u8fdb\u884c\u7f16\u7801\u89c4\u5219\u5220\u9664\u64cd\u4f5c", (Object)curTenantId, (Object)InvocationInfoProxy.getUserid());
                return CommonResponse.error((String)"\u975e\u8fd0\u8425\u4eba\u5458\u65e0\u6cd5\u8fdb\u884c\u7f16\u7801\u89c4\u5219\u5220\u9664\u64cd\u4f5c\uff01");
            }
            QueryParam param = new QueryParam();
            param.getParams().put("billcodeRuleId", new Parameter("in", ids));
            param.getParams().put("tenantId", new Parameter("ne", (Object)this.omTenantId));
            List attrList = this.billCodeRuleAttrService.queryList(param, false);
            if (CollectionUtils.isNotEmpty((Collection)attrList)) {
                return CommonResponse.error((String)"\u8be5\u7f16\u7801\u89c4\u5219\u5df2\u88ab\u79df\u6237\u4f7f\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff01");
            }
            this.billTypeRuleService.delete(ids);
            return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            this.logger.error("\u6279\u91cf\u5220\u9664\u5355\u636e\u7f16\u7801\u89c4\u5219\u5f02\u5e38: ", (Throwable)e);
            return CommonResponse.error((String)(null != e.getMessage() ? e.getMessage() : "\u5220\u9664\u5931\u8d25, "));
        }
    }

    @GetMapping(value={"queryDetail"})
    public CommonResponse<BillCodeRuleVO> queryDetail(@RequestParam Long id) {
        try {
            BillCodeRuleVO billCodeRuleVo = this.billTypeRuleService.queryDetail(id);
            return CommonResponse.success((Object)billCodeRuleVo);
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u5355\u636e\u7f16\u7801\u89c4\u5219\u5f02\u5e38\uff0c", (Throwable)e);
            return CommonResponse.error((String)(null != e.getMessage() ? e.getMessage() : "\u67e5\u8be2\u5355\u636e\u7f16\u7801\u89c4\u5219\u5931\u8d25,"));
        }
    }

    @PostMapping(value={"save"})
    public CommonResponse<String> saveOrUpdate(@RequestBody BillCodeRuleVO billCodeRuleVo) {
        try {
            QueryParam param = new QueryParam();
            param.getParams().put("billtypeId", new Parameter("eq", (Object)billCodeRuleVo.getBillTypeId()));
            param.getParams().put("id", new Parameter("ne", (Object)(null == billCodeRuleVo.getId() ? 0L : billCodeRuleVo.getId())));
            List eLIst = this.billTypeRuleService.queryList(param, false);
            if (CollectionUtils.isNotEmpty((Collection)eLIst)) {
                return CommonResponse.error((String)"\u65b0\u589e\u5931\u8d25\uff0c\u540c\u4e00\u5355\u636e\u7c7b\u578b\u4e0b\u53ea\u80fd\u521b\u5efa\u4e00\u4e2a\u7f16\u7801\u89c4\u5219\uff01");
            }
            this.billTypeRuleService.save(billCodeRuleVo);
            return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
        }
        catch (Exception e) {
            this.logger.error("\u4fdd\u5b58\u5355\u636e\u7f16\u7801\u89c4\u5219\u5f02\u5e38,", (Throwable)e);
            return CommonResponse.error((String)(null != e.getMessage() ? e.getMessage() : "\u4fdd\u5b58\u5355\u636e\u7f16\u7801\u89c4\u5219\u5931\u8d25"));
        }
    }

    @PostMapping(value={"checkCode"})
    public CommonResponse<Boolean> checkCode(@RequestBody QueryParam param) {
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List list = this.billTypeRuleService.queryList(param, false);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return CommonResponse.error((String)"\u7f16\u7801\u91cd\u590d\uff01");
        }
        return CommonResponse.success((String)"\u7f16\u7801\u53ef\u4ee5\u4f7f\u7528\uff01");
    }

    @ResponseBody
    @RequestMapping(value={"publish"})
    public CommonResponse<String> publish(@RequestBody PublishVO publishVO) {
        try {
            String targetEnv = publishVO.getTarget();
            if (StringUtils.isBlank((CharSequence)targetEnv)) {
                return CommonResponse.error((String)"\u53d1\u5e03\u6570\u636e\u5931\u8d25:\u76ee\u6807\u73af\u5883\u57df\u540d\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            String scope = publishVO.getScope();
            if (StringUtils.isBlank((CharSequence)scope)) {
                return CommonResponse.error((String)"\u53d1\u5e03\u6570\u636e\u5931\u8d25:\u6570\u636e\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            ArrayList<Long> ids = null;
            ArrayList<String> codes = null;
            List baseEntities = null;
            List ruleAttrEntities = null;
            if ("all".equalsIgnoreCase(scope)) {
                QueryParam queryParam = new QueryParam();
                HashMap<String, Parameter> params = new HashMap<String, Parameter>();
                params.put("billtypeId", new Parameter("in", (Object)publishVO.getModuleId()));
                queryParam.setParams(params);
                baseEntities = this.billTypeRuleService.queryList(queryParam, false);
            } else if ("select".equalsIgnoreCase(scope)) {
                if (publishVO.getIdList() != null && publishVO.getIdList().size() > 0) {
                    baseEntities = (List)this.billTypeRuleService.listByIds(publishVO.getIdList());
                } else {
                    return CommonResponse.error((String)"\u672a\u9009\u4e2d\u8981\u53d1\u5e03\u7684\u6570\u636e");
                }
            }
            if (ids == null || ids.isEmpty() || codes == null || codes.isEmpty()) {
                ids = new ArrayList<Long>(baseEntities.size());
                codes = new ArrayList<String>(baseEntities.size());
                for (BillCodeRuleEntity entity : baseEntities) {
                    if (entity.getId() != null) {
                        ids.add(entity.getId());
                    }
                    if (!StringUtils.isNotBlank((CharSequence)entity.getRuleCode())) continue;
                    codes.add(entity.getRuleCode());
                }
            }
            if (ids != null && ids.size() > 0) {
                QueryParam q = new QueryParam();
                q.getParams().put("billcode_rule_id", new Parameter("in", ids));
                q.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
                q.getOrderMap().put("elem_order", "asc");
                List<BillCodeRuleAttrVO> attrs = this.billCodeRuleAttrService.getListByProperties(q, false);
                if (attrs != null && attrs.size() > 0) {
                    ruleAttrEntities = BeanMapper.mapList(attrs, BillCodeRuleAttrEntity.class);
                }
            }
            ArrayList<String> sqls = new ArrayList<String>();
            List<String> deleteSql = this.getDeleteSql(ids, codes);
            List<String> insertSql = this.getInsertSql(baseEntities, ruleAttrEntities);
            if (deleteSql != null && !deleteSql.isEmpty()) {
                sqls.addAll(deleteSql);
            }
            if (insertSql != null && !insertSql.isEmpty()) {
                sqls.addAll(insertSql);
            }
            String url = publishVO.getTarget() + "/ejc-support-web/dataTransfer/transferBySql";
            HashMap<String, ArrayList<String>> params = new HashMap<String, ArrayList<String>>();
            params.put("sql", sqls);
            this.gson = new GsonBuilder().disableHtmlEscaping().create();
            String paramterStr = this.gson.toJson(params);
            this.logger.info("\u53d1\u5e03\u6570\u636e\u7684url\uff1a---------------" + url);
            try {
                String result = ReferHttpClientUtils.postByJson((String)url, (String)paramterStr);
                this.logger.info("\u53d1\u5e03\u6570\u636e\u8fd4\u56de\u7684\u7ed3\u679c\uff1a---------------" + result);
                return (CommonResponse)this.gson.fromJson(result, CommonResponse.class);
            }
            catch (Exception e) {
                e.printStackTrace();
                return CommonResponse.error((String)"\u53d1\u5e03\u53c2\u7167\u6570\u636e\u5931\u8d25");
            }
        }
        catch (Exception e) {
            return CommonResponse.error((String)("\u53d1\u5e03\u53c2\u7167\u6570\u636e\u5931\u8d25:" + e.getMessage()));
        }
    }

    private List<String> getDeleteSql(List<Long> ids, List<String> codes) {
        if (ids == null || ids.isEmpty()) {
            return null;
        }
        ArrayList<String> sqlList = new ArrayList<String>();
        String idStr = "";
        for (Long l : ids) {
            idStr = idStr + "'" + l + "',";
        }
        String codeStr = "";
        for (String code : codes) {
            codeStr = codeStr + "'" + code + "',";
        }
        idStr = "(" + idStr.substring(0, idStr.lastIndexOf(",")) + ")";
        codeStr = "(" + codeStr.substring(0, codeStr.lastIndexOf(",")) + ")";
        String string = "ejc_support_billcode_rule";
        String ruleAttrTableName = "ejc_support_billcode_rule_attr";
        String deleteRuleAttrSql = " delete from " + ruleAttrTableName + " where billcode_rule_Id in " + idStr + ";";
        String deleteBaseSql = " delete from " + string + " where id in " + idStr + ";";
        String deleteByCodeSql = " delete from " + string + " where dr =1 and rule_code in " + codeStr + ";";
        sqlList.add(deleteRuleAttrSql);
        sqlList.add(deleteBaseSql);
        sqlList.add(deleteByCodeSql);
        return sqlList;
    }

    private List<String> getInsertSql(List<BillCodeRuleEntity> baseEntityList, List<BillCodeRuleAttrEntity> ruleAttrEntities) throws Exception {
        ArrayList<String> retList = new ArrayList<String>();
        List<String> baseInsertSql = DataTransferUtil.getInsertSql(baseEntityList);
        List<String> ruleAttrInsertSql = DataTransferUtil.getInsertSql(ruleAttrEntities);
        if (baseInsertSql != null && !baseInsertSql.isEmpty()) {
            retList.addAll(baseInsertSql);
        }
        if (ruleAttrInsertSql != null && !ruleAttrInsertSql.isEmpty()) {
            retList.addAll(ruleAttrInsertSql);
        }
        return retList;
    }

    @ResponseBody
    @RequestMapping(value={"/exportSQL"})
    public void exportSQL(HttpServletRequest req, HttpServletResponse response, @RequestBody PublishVO publishVO) {
        try {
            String scope = publishVO.getScope();
            if (StringUtils.isBlank((CharSequence)scope)) {
                throw new BusinessException("\u5bfc\u51fa\u811a\u672c\u5931\u8d25:\u6570\u636e\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            ArrayList<Long> ids = null;
            ArrayList<String> codes = null;
            List baseEntities = null;
            List ruleAttrEntities = null;
            if ("all".equalsIgnoreCase(scope)) {
                QueryParam queryParam = new QueryParam();
                HashMap<String, Parameter> params = new HashMap<String, Parameter>();
                params.put("billtypeId", new Parameter("in", (Object)publishVO.getModuleId()));
                queryParam.setParams(params);
                baseEntities = this.billTypeRuleService.queryList(queryParam, false);
            } else if ("select".equalsIgnoreCase(scope)) {
                if (publishVO.getIdList() != null && publishVO.getIdList().size() > 0) {
                    baseEntities = (List)this.billTypeRuleService.listByIds(publishVO.getIdList());
                } else {
                    throw new BusinessException("\u672a\u9009\u4e2d\u8981\u5bfc\u51fa\u811a\u672c\u7684\u6570\u636e!");
                }
            }
            if (ids == null || ids.isEmpty() || codes == null || codes.isEmpty()) {
                ids = new ArrayList<Long>(baseEntities.size());
                codes = new ArrayList<String>(baseEntities.size());
                for (BillCodeRuleEntity entity : baseEntities) {
                    if (entity.getId() != null) {
                        ids.add(entity.getId());
                    }
                    if (!StringUtils.isNotBlank((CharSequence)entity.getRuleCode())) continue;
                    codes.add(entity.getRuleCode());
                }
            }
            if (ids != null && ids.size() > 0) {
                QueryParam q = new QueryParam();
                q.getParams().put("billcode_rule_id", new Parameter("in", ids));
                q.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
                q.getOrderMap().put("elem_order", "asc");
                List<BillCodeRuleAttrVO> attrs = this.billCodeRuleAttrService.getListByProperties(q, false);
                if (attrs != null && attrs.size() > 0) {
                    ruleAttrEntities = BeanMapper.mapList(attrs, BillCodeRuleAttrEntity.class);
                }
            }
            ArrayList<String> sqls = new ArrayList<String>();
            List<String> deleteSql = this.getDeleteSql(ids, codes);
            List<String> insertSql = this.getInsertSql(baseEntities, ruleAttrEntities);
            if (deleteSql != null && !deleteSql.isEmpty()) {
                sqls.addAll(deleteSql);
            }
            if (insertSql != null && !insertSql.isEmpty()) {
                sqls.addAll(insertSql);
            }
            StringBuffer fileName = new StringBuffer();
            fileName.append("billType.sql");
            response.setContentType("application/octet-stream; charset=utf-8");
            response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(fileName.toString(), "UTF-8"));
            ServletOutputStream out = response.getOutputStream();
            out.write(String.join((CharSequence)"\r\n", sqls).getBytes());
            out.flush();
            out.close();
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            response.setStatus(400);
        }
    }
}

