/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.dataModel.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.dataModel.bean.DataModelBillEntity;
import com.ejianc.foundation.dataModel.bean.DataModelCusEntity;
import com.ejianc.foundation.dataModel.bean.DataModelCustomerBillEntity;
import com.ejianc.foundation.dataModel.bean.DataModelDataEntity;
import com.ejianc.foundation.dataModel.bean.DataModelDataSetEntity;
import com.ejianc.foundation.dataModel.bean.DataModelEntity;
import com.ejianc.foundation.dataModel.bean.DataModelRoleEntity;
import com.ejianc.foundation.dataModel.mapper.DataModelMapper;
import com.ejianc.foundation.dataModel.service.IDataModelBillService;
import com.ejianc.foundation.dataModel.service.IDataModelColumnService;
import com.ejianc.foundation.dataModel.service.IDataModelCusService;
import com.ejianc.foundation.dataModel.service.IDataModelCustomerBillService;
import com.ejianc.foundation.dataModel.service.IDataModelDataService;
import com.ejianc.foundation.dataModel.service.IDataModelDataSetService;
import com.ejianc.foundation.dataModel.service.IDataModelRoleService;
import com.ejianc.foundation.dataModel.service.IDataModelService;
import com.ejianc.foundation.dataModel.vo.DataModelColConditionVO;
import com.ejianc.foundation.dataModel.vo.DataModelColumnVO;
import com.ejianc.foundation.metadata.vo.MdProjectVO;
import com.ejianc.foundation.permission.api.IRoleApi;
import com.ejianc.foundation.util.CalculatorUtils;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.util.JdkBase64Util;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

@Service(value="dataModelService")
public class DataModelServiceImpl
extends BaseServiceImpl<DataModelMapper, DataModelEntity>
implements IDataModelService {
    private static final Logger logger = LoggerFactory.getLogger(DataModelServiceImpl.class);
    @Autowired
    private DataModelMapper dataModelMapper;
    @Autowired
    private IRoleApi iRoleApi;
    @Autowired
    private IDataModelRoleService dataModelRoleService;
    @Autowired
    private IDataModelBillService iDataModelBillService;
    @Autowired
    private IDataModelCustomerBillService customerBillService;
    @Autowired
    private IDataModelDataService dataModelDataService;
    @Autowired
    private IDataModelCusService iDataModelCusService;
    @Autowired
    private IDataModelDataSetService iDataModelDataSetService;
    @Autowired
    private IDataModelColumnService iDataModelColumnService;
    @Autowired
    private EnvironmentTools environmentTools;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommonResponse<List<JSONObject>> saveOrQueryDataModelDataByBill(JSONObject jsonObject, HttpServletRequest request) {
        DataModelBillEntity billEntity;
        String baseHost = this.environmentTools.getBaseHost(InvocationInfoProxy.getTenantid());
        ArrayList<JSONObject> allList = new ArrayList<JSONObject>();
        HashMap<String, JSONObject> allMap = new HashMap<String, JSONObject>();
        ArrayList<JSONObject> res = new ArrayList<JSONObject>();
        HashMap<String, Long> resMap = new HashMap<String, Long>();
        ArrayList<JSONObject> saveList = new ArrayList<JSONObject>();
        String billTypeCode = jsonObject.getString("billTypeCode");
        JSONObject bill = jsonObject.getJSONObject("bill");
        Integer queryType = jsonObject.getInteger("type");
        if (bill.getString("id") != null) {
            JSONArray array;
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"bill_id", (Object)bill.getString("id"));
            wrapper.last("LIMIT 1");
            DataModelDataEntity dataEntity = (DataModelDataEntity)((Object)this.dataModelDataService.getOne((Wrapper)wrapper));
            if (dataEntity != null && (array = JSONArray.parseArray((String)dataEntity.getData())) != null) {
                for (Object o : array) {
                    JSONObject object = (JSONObject)o;
                    if (allMap.get(object.getString("dataModelId")) != null) continue;
                    allList.add(object);
                    allMap.put(object.getString("dataModelId"), object);
                }
            }
        }
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("billTypeCode", new Parameter("eq", (Object)billTypeCode));
        List customerBillEntities = this.customerBillService.queryList(param);
        if (ListUtil.isEmpty((List)customerBillEntities)) {
            return CommonResponse.success((String)"\u8be5\u5355\u636e\u7c7b\u578b\u672a\u6302\u8f7d\u4efb\u4f55\u6570\u636e\u6a21\u578b\uff01");
        }
        CommonResponse roleIds = this.iRoleApi.queryRoleIdsByUserId(InvocationInfoProxy.getUserid());
        if (!roleIds.isSuccess() || roleIds.isSuccess() && ListUtil.isEmpty((List)((List)roleIds.getData()))) {
            logger.error("\u67e5\u8be2\u5f53\u524d\u7528\u6237\u6302\u8f7d\u7684\u89d2\u8272:{}", (Object)JSONObject.toJSONString((Object)roleIds));
            return CommonResponse.success((String)"\u672a\u67e5\u8be2\u5230\u67e5\u8be2\u5f53\u524d\u7528\u6237\u6302\u8f7d\u7684\u89d2\u8272\uff01");
        }
        QueryParam roleParam = new QueryParam();
        roleParam.getParams().put("roleId", new Parameter("in", roleIds.getData()));
        List dataModelRoleEntities = this.dataModelRoleService.queryList(roleParam);
        if (ListUtil.isEmpty((List)dataModelRoleEntities)) {
            logger.error("\u5f53\u524d\u7528\u6237\u6302\u8f7d\u7684\u89d2\u8272\u91cc\u9762 \u6ca1\u6709\u6302\u8f7d\u4efb\u4f55\u6570\u636e\u6a21\u578b:{}", (Object)JSONObject.toJSONString((Object)roleIds));
            return CommonResponse.success((String)"\u5f53\u524d\u7528\u6237\u6302\u8f7d\u7684\u89d2\u8272\u91cc\u9762\uff0c\u6ca1\u6709\u6302\u8f7d\u4efb\u4f55\u6570\u636e\u6a21\u578b\uff01");
        }
        ConcurrentHashMap<Long, MdProjectVO> projectCache = new ConcurrentHashMap<Long, MdProjectVO>();
        for (DataModelCustomerBillEntity customerBillEntity : customerBillEntities) {
            DataModelEntity modelEntity;
            billEntity = (DataModelBillEntity)((Object)this.iDataModelBillService.getById(customerBillEntity.getModelBillId()));
            logger.info("\u6302\u8f7d\u7684\u7684\u5355\u636e\u7c7b\u578b\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)((Object)billEntity)));
            if (billEntity == null || billEntity.getQueryType() != 1 && queryType != 2 && !StringUtils.isEmpty((CharSequence)bill.getString("id")) || (modelEntity = (DataModelEntity)((Object)this.selectById(billEntity.getDataModelId()))) == null) continue;
            logger.info("\u6302\u8f7d\u7684\u7684\u6570\u636e\u6a21\u578b\u4fe1\u606f\uff1a{}\uff0c\u6302\u8f7d\u7684\u7684\u5355\u636e\u7c7b\u578b\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)((Object)modelEntity)), (Object)JSONObject.toJSONString((Object)((Object)billEntity)));
            ArrayList dataSetData = new ArrayList();
            DataModelCusEntity cusEntity = this.iDataModelCusService.queryCusModelByModelId(modelEntity.getId());
            if (cusEntity != null) {
                modelEntity.setName(cusEntity.getName());
            }
            String[] setIds = modelEntity.getDataSetIds().split(",");
            ExecutorService threadPool = null;
            try {
                List list;
                if (modelEntity.getModelType() == 1 || modelEntity.getModelType() == 3 || modelEntity.getModelType() == 4 || modelEntity.getModelType() == 5) {
                    threadPool = Executors.newFixedThreadPool(1);
                    DataModelDataSetEntity setEntity = (DataModelDataSetEntity)((Object)this.iDataModelDataSetService.selectById((Serializable)((Object)setIds[0])));
                    MainDatasetCallable mainDataModelCall = new MainDatasetCallable(billTypeCode, setIds, RequestContextHolder.getRequestAttributes(), modelEntity, setEntity, bill, billEntity.getBillParam(), billEntity.getSubTabParam(), request.getHeader("authority"), InvocationInfoProxy.getTenantid(), projectCache, baseHost);
                    Future<List<JSONObject>> future = threadPool.submit(mainDataModelCall);
                    list = future.get(30L, TimeUnit.SECONDS);
                    if (ListUtil.isNotEmpty(list)) {
                        dataSetData.addAll(list);
                    }
                } else {
                    threadPool = Executors.newFixedThreadPool(setIds.length);
                    ArrayList<Future<List<JSONObject>>> futureList = new ArrayList<Future<List<JSONObject>>>();
                    for (int i = 0; i < setIds.length; ++i) {
                        DataModelDataSetEntity dataModelDataSetEntity = (DataModelDataSetEntity)((Object)this.iDataModelDataSetService.selectById((Serializable)((Object)setIds[i])));
                        MainDatasetCallable mainDataModelCall = new MainDatasetCallable(billTypeCode, setIds, RequestContextHolder.getRequestAttributes(), modelEntity, dataModelDataSetEntity, bill, billEntity.getBillParam(), billEntity.getSubTabParam(), request.getHeader("authority"), InvocationInfoProxy.getTenantid(), projectCache, baseHost);
                        Future<List<JSONObject>> childFuture = threadPool.submit(mainDataModelCall);
                        futureList.add(childFuture);
                    }
                    for (Future future : futureList) {
                        list = (List)future.get(30L, TimeUnit.SECONDS);
                        if (!ListUtil.isNotEmpty((List)list)) continue;
                        dataSetData.addAll(list);
                    }
                }
                JSONObject dataModel = new JSONObject();
                List<DataModelColumnVO> columnVOS = this.iDataModelColumnService.queryListByTenant(modelEntity.getId());
                dataModel.put("columns", columnVOS);
                if (dataSetData.size() > 0) {
                    for (JSONObject data : dataSetData) {
                        for (DataModelColumnVO columnVO : columnVOS) {
                            if (!StringUtils.isNotEmpty((CharSequence)columnVO.getFormula())) continue;
                            logger.info("\u8ba1\u7b97\u516c\u5f0f\uff1a{},\u6570\u636e\uff1a{}", (Object)columnVO.getFormula(), (Object)data);
                            data.put(columnVO.getProperty(), (Object)CalculatorUtils.getResult(columnVO.getFormula(), data));
                        }
                        data.put("colStyles", (Object)new JSONObject());
                        block11: for (DataModelColumnVO columnVO : columnVOS) {
                            if (!ListUtil.isNotEmpty((List)columnVO.getConditionEntities())) continue;
                            for (DataModelColConditionVO conditionEntity : columnVO.getConditionEntities()) {
                                boolean r;
                                if (!StringUtils.isNotEmpty((CharSequence)conditionEntity.getCond()) || !(r = CalculatorUtils.getFiled(conditionEntity.getCond(), data, columnVOS, logger))) continue;
                                JSONObject colStyles = data.getJSONObject("colStyles");
                                JSONObject style = new JSONObject();
                                style.put("color", (Object)conditionEntity.getColor());
                                style.put("background", (Object)conditionEntity.getBgColor());
                                style.put("bold", (Object)conditionEntity.getBold());
                                colStyles.put(columnVO.getProperty(), (Object)style);
                                data.put("colStyles", (Object)colStyles);
                                continue block11;
                            }
                        }
                    }
                }
                dataModel.put("name", (Object)modelEntity.getName());
                dataModel.put("type", (Object)modelEntity.getModelType());
                dataModel.put("dataModelId", (Object)modelEntity.getId());
                dataModel.put("billId", (Object)bill.getLong("id"));
                dataModel.put("data", dataSetData);
                dataModel.put("sequence", (Object)modelEntity.getSequence());
                allList.add(dataModel);
                allMap.put(dataModel.getString("dataModelId"), dataModel);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                e.printStackTrace();
                logger.error("\u67e5\u8be2\u6570\u636e\u6a21\u578b\u51fa\u9519:{}", (Object)e.getMessage());
            }
            finally {
                if (threadPool == null) continue;
                threadPool.shutdown();
            }
        }
        for (DataModelRoleEntity roleEntity : dataModelRoleEntities) {
            if (allMap.get(roleEntity.getDatasetId().toString()) == null || resMap.get(roleEntity.getDatasetId().toString()) != null) continue;
            resMap.put(roleEntity.getDatasetId().toString(), roleEntity.getDatasetId());
            res.add((JSONObject)allMap.get(roleEntity.getDatasetId().toString()));
        }
        if (queryType == 2) {
            for (DataModelCustomerBillEntity customerBillEntity : customerBillEntities) {
                billEntity = (DataModelBillEntity)((Object)this.iDataModelBillService.getById(customerBillEntity.getModelBillId()));
                if (billEntity.getQueryType() != 2) continue;
                saveList.add((JSONObject)allMap.get(billEntity.getDataModelId().toString()));
            }
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"bill_id", (Object)bill.getString("id"));
            wrapper.last("LIMIT 1");
            DataModelDataEntity dataEntity = (DataModelDataEntity)((Object)this.dataModelDataService.getOne((Wrapper)wrapper));
            if (dataEntity == null) {
                dataEntity = new DataModelDataEntity();
            }
            dataEntity.setBillId(bill.getString("id"));
            dataEntity.setData(JSONObject.toJSONString(saveList));
            this.dataModelDataService.saveOrUpdate((Object)dataEntity, false);
        }
        if (ListUtil.isNotEmpty(res)) {
            res.sort(Comparator.comparingInt(a -> a.getInteger("sequence")));
        }
        return CommonResponse.success(res);
    }

    @Override
    public CommonResponse<List<Long>> queryDataModelExist(String billTypeCode) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("billTypeCode", new Parameter("eq", (Object)billTypeCode));
        List customerBillEntities = this.customerBillService.queryList(param);
        if (ListUtil.isEmpty((List)customerBillEntities)) {
            return CommonResponse.error((String)"\u8be5\u5355\u636e\u7c7b\u578b\u672a\u6302\u8f7d\u4efb\u4f55\u6570\u636e\u6a21\u578b\uff01");
        }
        ArrayList<DataModelCustomerBillEntity> customerBills = new ArrayList<DataModelCustomerBillEntity>();
        for (DataModelCustomerBillEntity record : customerBillEntities) {
            DataModelBillEntity entity = (DataModelBillEntity)((Object)this.iDataModelBillService.selectById(record.getModelBillId()));
            if (entity == null) continue;
            customerBills.add(record);
        }
        if (ListUtil.isEmpty(customerBills)) {
            return CommonResponse.error((String)"\u8be5\u5355\u636e\u7c7b\u578b\u672a\u6302\u8f7d\u4efb\u4f55\u6570\u636e\u6a21\u578b\uff01");
        }
        CommonResponse roleIds = this.iRoleApi.queryRoleIdsByUserId(InvocationInfoProxy.getUserid());
        if (!roleIds.isSuccess() || roleIds.isSuccess() && ListUtil.isEmpty((List)((List)roleIds.getData()))) {
            return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u67e5\u8be2\u5f53\u524d\u7528\u6237\u6302\u8f7d\u7684\u89d2\u8272\uff01");
        }
        QueryParam roleParam = new QueryParam();
        roleParam.getParams().put("roleId", new Parameter("in", roleIds.getData()));
        List dataModelRoleEntities = this.dataModelRoleService.queryList(roleParam);
        if (ListUtil.isEmpty((List)dataModelRoleEntities)) {
            return CommonResponse.error((String)"\u5f53\u524d\u7528\u6237\u6302\u8f7d\u7684\u89d2\u8272\u91cc\u9762\uff0c\u6ca1\u6709\u6302\u8f7d\u4efb\u4f55\u6570\u636e\u6a21\u578b\uff01");
        }
        HashMap<String, Long> resMap = new HashMap<String, Long>();
        ArrayList<Long> res = new ArrayList<Long>();
        for (DataModelRoleEntity roleEntity : dataModelRoleEntities) {
            for (DataModelCustomerBillEntity customerBillEntity : customerBills) {
                DataModelEntity dataModelEntity;
                if (!customerBillEntity.getDataModelId().equals(roleEntity.getDatasetId()) || resMap.get(roleEntity.getDatasetId().toString()) != null || (dataModelEntity = (DataModelEntity)((Object)this.selectById(customerBillEntity.getDataModelId()))) == null) continue;
                resMap.put(roleEntity.getDatasetId().toString(), roleEntity.getDatasetId());
                res.add(roleEntity.getDatasetId());
            }
        }
        if (ListUtil.isEmpty(res)) {
            return CommonResponse.error((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u6302\u8f7d\u4efb\u4f55\u6570\u636e\u6a21\u578b\uff01");
        }
        return CommonResponse.success(res);
    }

    @Override
    public void deleteByIds(String ids) {
        this.dataModelMapper.deleteByIds(ids);
    }

    class ChildDatasetCallable
    implements Callable<List<JSONObject>> {
        private DataModelEntity modelEntity;
        private DataModelDataSetEntity childDataset;
        private JSONObject mainDataset;
        private RequestAttributes context;
        private Long tenantId;
        private String authority;
        private String baseHost;
        private String billTypeCode;
        private String billParam;
        private String billSubParam;
        private JSONObject billData;
        private ConcurrentHashMap<Long, MdProjectVO> projectCache;

        public ChildDatasetCallable(String billTypeCode, DataModelEntity modelEntity, String billParam, String billSubParam, DataModelDataSetEntity childDataset, JSONObject mainDataset, JSONObject billData, RequestAttributes context, Long tenantId, String authority, ConcurrentHashMap<Long, MdProjectVO> projectCache, String baseHost) {
            this.billTypeCode = billTypeCode;
            this.modelEntity = modelEntity;
            this.billParam = billParam;
            this.billSubParam = billSubParam;
            this.childDataset = childDataset;
            this.mainDataset = mainDataset;
            this.context = context;
            this.tenantId = tenantId;
            this.authority = authority;
            this.billData = billData;
            this.projectCache = projectCache;
            this.baseHost = baseHost;
        }

        @Override
        public List<JSONObject> call() throws Exception {
            String[] bpp;
            String url;
            this.context.setAttribute("authority", (Object)this.authority, 0);
            RequestContextHolder.setRequestAttributes((RequestAttributes)this.context);
            ArrayList<JSONObject> dataList = new ArrayList<JSONObject>();
            MdProjectVO projectVO = this.projectCache.get(this.childDataset.getMdprojectId());
            if (null == projectVO) {
                url = this.baseHost + "ejc-metadata-web/api/mdProjectApi/queryDetail";
                HashMap<String, String> param = new HashMap<String, String>();
                HashMap<String, String> header = new HashMap<String, String>();
                param.put("id", this.childDataset.getMdprojectId().toString());
                header.put("authority", this.authority);
                String projectInfoResp = HttpTookit.get((String)url, param, header);
                logger.info("\u67e5\u8be2\u3010id-{}\u3011\u5143\u6570\u636e\u9879\u76ee\u4fe1\u606f\u7ed3\u679c\uff1a{}", (Object)this.childDataset.getMdprojectId(), (Object)projectInfoResp);
                CommonResponse response = (CommonResponse)JSONObject.parseObject((String)projectInfoResp, CommonResponse.class);
                if (response.isSuccess()) {
                    projectVO = (MdProjectVO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)response.getData()), MdProjectVO.class);
                    this.projectCache.put(projectVO.getId(), projectVO);
                } else {
                    logger.error("\u6570\u636e\u5b50\u96c6\u3010id-{}\u3011\u67e5\u8be2\u6570\u636e\u5931\u8d25, \u5176\u5bf9\u5e94\u5143\u6570\u636e\u67e5\u8be2\u5931\u8d25, \u539f\u56e0\uff1a{}", (Object)this.childDataset.getId(), (Object)response.getMsg());
                }
            }
            if (null != projectVO && StringUtils.isNotEmpty((CharSequence)this.childDataset.getSqlContent())) {
                String bp;
                String childDatasetUrl = this.baseHost + projectVO.getProjectName() + "/common/report/parse";
                JSONObject childParamJson = new JSONObject();
                JSONObject childQueryParam = new JSONObject();
                childQueryParam.put("tenantId", (Object)this.tenantId);
                if (StringUtils.isNotBlank((CharSequence)this.childDataset.getChildParam())) {
                    CommonResponse childParamArr;
                    for (CommonResponse childParamStr : childParamArr = this.childDataset.getChildParam().split(",")) {
                        childQueryParam.put((String)childParamStr, (Object)this.mainDataset.getString((String)childParamStr));
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)(bp = this.modelEntity.getBillParam())) && StringUtils.isNotEmpty((CharSequence)this.billParam)) {
                    String[] billP;
                    bpp = bp.split(",");
                    if (bpp.length == (billP = this.billParam.split(",")).length) {
                        for (int i = 0; i < bpp.length; ++i) {
                            String s = bpp[i];
                            String p = billP[i];
                            if (this.billData.getString(p) == null) {
                                logger.error("\u5355\u636e\u6570\u636e{}\u4e3a\u7a7a\uff0c\u5355\u636e\u6570\u636e{}", (Object)p, (Object)this.billData);
                            }
                            if (this.billData.getString(p) != null && this.billData.getString(p).indexOf("{") > -1) {
                                childQueryParam.put(s, (Object)this.billData.getJSONObject(p).getString("id"));
                                continue;
                            }
                            childQueryParam.put(s, (Object)this.billData.getString(p));
                        }
                    } else {
                        logger.error("\u5355\u636e\u6570\u636e\u5b57\u6bb5{}\u4e0e\u7cfb\u7edf\u5b57\u6bb5{}\u4e0d\u5339\u914d", (Object)this.billParam, (Object)bp);
                    }
                } else {
                    logger.error("\u5355\u636e\u6570\u636e\u5b57\u6bb5{}\u4e0e\u7cfb\u7edf\u5b57\u6bb5{}\u6709\u7a7a\u503c", (Object)this.billParam, (Object)bp);
                }
                childParamJson.put("sqlContent", (Object)JdkBase64Util.encode((String)this.childDataset.getSqlContent()));
                childParamJson.put("datasetType", (Object)"2");
                childParamJson.put("params", (Object)childQueryParam);
                String childResponseStr = ReferHttpClientUtils.postByJson((String)childDatasetUrl, (String)JSON.toJSONString((Object)childParamJson));
                CommonResponse childResponse = (CommonResponse)JSON.parseObject((String)childResponseStr, CommonResponse.class);
                if (childResponse.isSuccess()) {
                    logger.info("\u6267\u884csql-{}, \u53c2\u6570-{}, \u7ed3\u679c-{}", new Object[]{this.childDataset.getSqlContent(), childQueryParam, JSONObject.toJSONString((Object)childResponse.getData())});
                    if (ListUtil.isNotEmpty((List)((List)childResponse.getData()))) {
                        return (List)childResponse.getData();
                    }
                }
            }
            if (this.childDataset.getDataUrl() != null) {
                url = null;
                url = this.childDataset.getDataUrl().startsWith("http") ? this.childDataset.getDataUrl() : this.baseHost + this.childDataset.getDataUrl();
                JSONObject mainQueryParam = new JSONObject();
                mainQueryParam.put("tenantId", (Object)this.tenantId);
                mainQueryParam.put("billTypeCode", (Object)this.billTypeCode);
                mainQueryParam.put("bill", (Object)this.billData);
                String bp = this.modelEntity.getBillParam();
                if (StringUtils.isNotEmpty((CharSequence)bp) && StringUtils.isNotEmpty((CharSequence)this.billParam)) {
                    String[] billP = this.billParam.split(",");
                    bpp = bp.split(",");
                    if (bpp.length == billP.length) {
                        for (int i = 0; i < bpp.length; ++i) {
                            String s = bpp[i];
                            String p = billP[i];
                            if (this.billData.getString(p) == null) {
                                logger.error("\u5355\u636e\u6570\u636e{}\u4e3a\u7a7a\uff0c\u5355\u636e\u6570\u636e{}", (Object)p, (Object)this.billData);
                            }
                            if (this.billData.getString(p) != null && this.billData.getString(p).indexOf("{") > -1) {
                                mainQueryParam.put(s, (Object)this.billData.getJSONObject(p).getString("id"));
                                continue;
                            }
                            mainQueryParam.put(s, (Object)this.billData.getString(p));
                        }
                    } else {
                        logger.error("\u5355\u636e\u6570\u636e\u5b57\u6bb5{}\u4e0e\u7cfb\u7edf\u5b57\u6bb5{}\u4e0d\u5339\u914d", (Object)this.billParam, (Object)bp);
                    }
                } else {
                    logger.error("\u5355\u636e\u6570\u636e\u5b57\u6bb5{}\u4e0e\u7cfb\u7edf\u5b57\u6bb5{}\u6709\u7a7a\u503c", (Object)this.billParam, (Object)bp);
                }
                if (this.modelEntity.getSubTabParam() != null && this.billSubParam != null) {
                    String[] subs;
                    String[] sqlParam = this.modelEntity.getSubTabParam().split(",");
                    if (sqlParam.length == (subs = this.billSubParam.split(",")).length) {
                        for (int i = 0; i < subs.length; ++i) {
                            String[] sub = subs[i].split(":");
                            if (sub.length != 2) {
                                logger.error("\u5355\u636e\u5b50\u8868\u5b57\u6bb5{}\u4e0e\u7cfb\u7edf\u5b50\u8868\u5b57\u6bb5{} \u4e0d\u5339\u914d", (Object)this.billSubParam, (Object)this.modelEntity.getSubTabParam());
                                continue;
                            }
                            JSONArray array = this.billData.getJSONArray(sub[0]);
                            String key = sub[1];
                            ArrayList<String> value = new ArrayList<String>();
                            if (array != null) {
                                for (Object o : array) {
                                    JSONObject row = new JSONObject((Map)((HashMap)o));
                                    if (!StringUtils.isNotEmpty((CharSequence)row.getString(key))) continue;
                                    value.add(row.getString(key));
                                }
                            }
                            if (value.size() <= 0) continue;
                            mainQueryParam.put(sqlParam[i], value);
                        }
                    } else {
                        logger.error("\u5355\u636e\u5b50\u8868\u5b57\u6bb5{}\u4e0e\u7cfb\u7edf\u5b50\u8868\u5b57\u6bb5{}\u6570\u91cf\u4e0d\u5339\u914d", (Object)this.billSubParam, (Object)this.modelEntity.getSubTabParam());
                    }
                } else {
                    logger.error("\u5355\u636e\u5b50\u8868\u5b57\u6bb5{}\u4e0e\u7cfb\u7edf\u5b50\u8868\u5b57\u6bb5{}\u6709\u7a7a\u503c", (Object)this.billSubParam, (Object)this.modelEntity.getSubTabParam());
                }
                String mainResponseStr = ReferHttpClientUtils.postByJson((String)url, (String)JSON.toJSONString((Object)mainQueryParam));
                CommonResponse mainResponse = (CommonResponse)JSON.parseObject((String)mainResponseStr, CommonResponse.class);
                if (mainResponse.isSuccess()) {
                    if (ListUtil.isNotEmpty((List)((List)mainResponse.getData()))) {
                        return (List)mainResponse.getData();
                    }
                } else {
                    logger.error("******************* \u6839\u636e\u6570\u636e\u5730\u5740\u67e5\u8be2\u6570\u636e\u96c6 \u67e5\u8be2\u5931\u8d25\uff1a{}  *******************", (Object)mainResponse.getMsg());
                }
            }
            return dataList;
        }
    }

    class MainDatasetCallable
    implements Callable<List<JSONObject>> {
        private RequestAttributes context;
        private String[] setIds;
        private DataModelEntity modelEntity;
        private DataModelDataSetEntity setEntity;
        private String baseHost;
        private String billTypeCode;
        private String authority;
        private String billParam;
        private String billSubParam;
        private Long tenantId;
        private JSONObject billData;
        private ConcurrentHashMap<Long, MdProjectVO> projectCache;

        public MainDatasetCallable(String billTypeCode, String[] setIds, RequestAttributes context, DataModelEntity modelEntity, DataModelDataSetEntity setEntity, JSONObject billData, String billParam, String billSubParam, String authority, Long tenantId, ConcurrentHashMap<Long, MdProjectVO> projectCache, String baseHost) {
            this.billTypeCode = billTypeCode;
            this.setIds = setIds;
            this.billSubParam = billSubParam;
            this.billParam = billParam;
            this.setEntity = setEntity;
            this.billData = billData;
            this.context = context;
            this.modelEntity = modelEntity;
            this.authority = authority;
            this.tenantId = tenantId;
            this.projectCache = projectCache;
            this.baseHost = baseHost;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public List<JSONObject> call() throws Exception {
            void var1_7;
            void var1_5;
            void var1_3;
            String url;
            InvocationInfoProxy.setTenantid((Long)this.tenantId);
            this.context.setAttribute("authority", (Object)this.authority, 0);
            RequestContextHolder.setRequestAttributes((RequestAttributes)this.context);
            Object var1_1 = null;
            MdProjectVO projectVO = this.projectCache.get(this.setEntity.getMdprojectId());
            if (null == projectVO) {
                url = this.baseHost + "ejc-metadata-web/api/mdProjectApi/queryDetail";
                HashMap<String, String> param = new HashMap<String, String>();
                HashMap<String, String> header = new HashMap<String, String>();
                param.put("id", this.setEntity.getMdprojectId().toString());
                header.put("authority", this.authority);
                String projectInfoResp = HttpTookit.get((String)url, param, header);
                logger.info("\u67e5\u8be2\u3010id-{}\u3011\u5143\u6570\u636e\u9879\u76ee\u4fe1\u606f\u7ed3\u679c\uff1a{}", (Object)this.setEntity.getMdprojectId().toString(), (Object)projectInfoResp);
                CommonResponse response = (CommonResponse)JSONObject.parseObject((String)projectInfoResp, CommonResponse.class);
                if (response.isSuccess()) {
                    projectVO = (MdProjectVO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)response.getData()), MdProjectVO.class);
                    this.projectCache.put(projectVO.getId(), projectVO);
                } else {
                    logger.error("\u6570\u636e\u6a21\u578b\u3010{}\u3011\u67e5\u8be2\u6570\u636e\u5931\u8d25, \u5176\u5bf9\u5e94\u5143\u6570\u636e\u67e5\u8be2\u5931\u8d25, \u539f\u56e0\uff1a{}", (Object)JSONObject.toJSONString((Object)((Object)this.modelEntity)), (Object)response.getMsg());
                }
            }
            if (null != projectVO && StringUtils.isNotEmpty((CharSequence)this.setEntity.getSqlContent())) {
                int i;
                String mainDatasetUrl = this.baseHost + projectVO.getProjectName() + "/common/report/parse";
                JSONObject mainParamJson = new JSONObject();
                JSONObject mainQueryParam = new JSONObject();
                mainQueryParam.put("tenantId", (Object)this.tenantId);
                String bp = this.modelEntity.getBillParam();
                if (StringUtils.isNotEmpty((CharSequence)bp) && StringUtils.isNotEmpty((CharSequence)this.billParam)) {
                    String[] billP = this.billParam.split(",");
                    String[] bpp = bp.split(",");
                    if (bpp.length == billP.length) {
                        for (i = 0; i < bpp.length; ++i) {
                            String string = bpp[i];
                            String p = billP[i];
                            if (this.billData.getString(p) == null) {
                                logger.error("\u5355\u636e\u6570\u636e{}\u4e3a\u7a7a\uff0c\u5355\u636e\u6570\u636e{}", (Object)p, (Object)this.billData);
                            }
                            if (this.billData.getString(p) != null && this.billData.getString(p).indexOf("{") > -1) {
                                mainQueryParam.put(string, (Object)this.billData.getJSONObject(p).getString("id"));
                                continue;
                            }
                            mainQueryParam.put(string, (Object)this.billData.getString(p));
                        }
                    } else {
                        logger.error("\u5355\u636e\u6570\u636e\u5b57\u6bb5{}\u4e0e\u7cfb\u7edf\u5b57\u6bb5{}\u4e0d\u5339\u914d", (Object)this.billParam, (Object)bp);
                    }
                } else {
                    logger.error("\u5355\u636e\u6570\u636e\u5b57\u6bb5{}\u4e0e\u7cfb\u7edf\u5b57\u6bb5{}\u6709\u7a7a\u503c", (Object)this.billParam, (Object)bp);
                }
                if (this.modelEntity.getSubTabParam() != null && this.billSubParam != null) {
                    String[] subs;
                    String[] sqlParam = this.modelEntity.getSubTabParam().split(",");
                    if (sqlParam.length == (subs = this.billSubParam.split(",")).length) {
                        for (i = 0; i < subs.length; ++i) {
                            String[] stringArray = subs[i].split(":");
                            if (stringArray.length != 2) {
                                logger.error("\u5355\u636e\u5b50\u8868\u5b57\u6bb5{}\u4e0e\u7cfb\u7edf\u5b50\u8868\u5b57\u6bb5{} \u4e0d\u5339\u914d", (Object)this.billSubParam, (Object)this.modelEntity.getSubTabParam());
                                continue;
                            }
                            JSONArray array = this.billData.getJSONArray(stringArray[0]);
                            String key = stringArray[1];
                            StringBuffer valueArr = new StringBuffer();
                            if (array != null) {
                                for (Object o : array) {
                                    JSONObject row = new JSONObject((Map)((HashMap)o));
                                    if (!StringUtils.isNotEmpty((CharSequence)row.getString(key))) continue;
                                    valueArr.append("'").append(row.getString(key)).append("',");
                                }
                            }
                            if (valueArr.length() <= 0) continue;
                            mainQueryParam.put(sqlParam[i], (Object)valueArr.toString().substring(0, valueArr.length() - 1));
                        }
                    } else {
                        logger.error("\u5355\u636e\u5b50\u8868\u5b57\u6bb5{}\u4e0e\u7cfb\u7edf\u5b50\u8868\u5b57\u6bb5{}\u6570\u91cf\u4e0d\u5339\u914d", (Object)this.billSubParam, (Object)this.modelEntity.getSubTabParam());
                    }
                } else {
                    logger.error("\u5355\u636e\u5b50\u8868\u5b57\u6bb5{}\u4e0e\u7cfb\u7edf\u5b50\u8868\u5b57\u6bb5{}\u6709\u7a7a\u503c", (Object)this.billSubParam, (Object)this.modelEntity.getSubTabParam());
                }
                String sql = "SELECT dsq.* FROM (" + this.setEntity.getSqlContent() + " ) dsq  ";
                mainParamJson.put("sqlContent", (Object)JdkBase64Util.encode((String)sql));
                mainParamJson.put("datasetType", (Object)"1");
                mainParamJson.put("params", (Object)mainQueryParam);
                String mainResponseStr = ReferHttpClientUtils.postByJson((String)mainDatasetUrl, (String)JSON.toJSONString((Object)mainParamJson));
                CommonResponse mainResponse = (CommonResponse)JSON.parseObject((String)mainResponseStr, CommonResponse.class);
                if (mainResponse.isSuccess()) {
                    if (var1_1 == null) {
                        ArrayList arrayList = new ArrayList();
                    }
                    var1_3.addAll((Collection)mainResponse.getData());
                } else {
                    logger.error("******************* \u6267\u884cSQL\u67e5\u8be2\u5931\u8d25\uff1a{}  *******************", (Object)mainResponse.getMsg());
                }
            } else {
                logger.error("*******************\u6570\u636e\u6a21\u578b\u6ca1\u627e\u5230\u5bf9\u5e94\u5143\u6570\u636e\uff1a{}  *******************", (Object)JSONObject.toJSONString((Object)((Object)this.modelEntity)));
            }
            if (StringUtils.isNotEmpty((CharSequence)this.setEntity.getDataUrl())) {
                url = null;
                url = this.setEntity.getDataUrl().startsWith("http") ? this.setEntity.getDataUrl() : this.baseHost + this.setEntity.getDataUrl();
                JSONObject mainQueryParam = new JSONObject();
                mainQueryParam.put("tenantId", (Object)this.tenantId);
                mainQueryParam.put("billTypeCode", (Object)this.billTypeCode);
                mainQueryParam.put("bill", (Object)this.billData);
                String bp = this.modelEntity.getBillParam();
                if (StringUtils.isNotEmpty((CharSequence)bp) && StringUtils.isNotEmpty((CharSequence)this.billParam)) {
                    String[] billP = this.billParam.split(",");
                    String[] bpp = bp.split(",");
                    if (bpp.length == billP.length) {
                        for (int i = 0; i < bpp.length; ++i) {
                            String s = bpp[i];
                            String string = billP[i];
                            if (this.billData.getString(string) == null) {
                                logger.error("\u5355\u636e\u6570\u636e{}\u4e3a\u7a7a\uff0c\u5355\u636e\u6570\u636e{}", (Object)string, (Object)this.billData);
                            }
                            if (this.billData.getString(string) != null && this.billData.getString(string).indexOf("{") > -1) {
                                mainQueryParam.put(s, (Object)this.billData.getJSONObject(string).getString("id"));
                                continue;
                            }
                            mainQueryParam.put(s, (Object)this.billData.getString(string));
                        }
                    } else {
                        logger.error("\u5355\u636e\u6570\u636e\u5b57\u6bb5{}\u4e0e\u7cfb\u7edf\u5b57\u6bb5{}\u4e0d\u5339\u914d", (Object)this.billParam, (Object)bp);
                    }
                } else {
                    logger.error("\u5355\u636e\u6570\u636e\u5b57\u6bb5{}\u4e0e\u7cfb\u7edf\u5b57\u6bb5{}\u6709\u7a7a\u503c", (Object)this.billParam, (Object)bp);
                }
                if (this.modelEntity.getSubTabParam() != null && this.billSubParam != null) {
                    String[] subs;
                    String[] sqlParam = this.modelEntity.getSubTabParam().split(",");
                    if (sqlParam.length == (subs = this.billSubParam.split(",")).length) {
                        for (int i = 0; i < subs.length; ++i) {
                            String[] sub = subs[i].split(":");
                            if (sub.length != 2) {
                                logger.error("\u5355\u636e\u5b50\u8868\u5b57\u6bb5{}\u4e0e\u7cfb\u7edf\u5b50\u8868\u5b57\u6bb5{} \u4e0d\u5339\u914d", (Object)this.billSubParam, (Object)this.modelEntity.getSubTabParam());
                                continue;
                            }
                            JSONArray jSONArray = this.billData.getJSONArray(sub[0]);
                            String key = sub[1];
                            ArrayList<String> value = new ArrayList<String>();
                            if (jSONArray != null) {
                                for (Object o : jSONArray) {
                                    JSONObject row = new JSONObject((Map)((HashMap)o));
                                    if (!StringUtils.isNotEmpty((CharSequence)row.getString(key))) continue;
                                    value.add(row.getString(key));
                                }
                            }
                            if (value.size() <= 0) continue;
                            mainQueryParam.put(sqlParam[i], value);
                        }
                    } else {
                        logger.error("\u5355\u636e\u5b50\u8868\u5b57\u6bb5{}\u4e0e\u7cfb\u7edf\u5b50\u8868\u5b57\u6bb5{}\u6570\u91cf\u4e0d\u5339\u914d", (Object)this.billSubParam, (Object)this.modelEntity.getSubTabParam());
                    }
                } else {
                    logger.error("\u5355\u636e\u5b50\u8868\u5b57\u6bb5{}\u4e0e\u7cfb\u7edf\u5b50\u8868\u5b57\u6bb5{}\u6709\u7a7a\u503c", (Object)this.billSubParam, (Object)this.modelEntity.getSubTabParam());
                }
                String mainResponseStr = ReferHttpClientUtils.postByJson((String)url, (String)JSON.toJSONString((Object)mainQueryParam));
                CommonResponse mainResponse = (CommonResponse)JSON.parseObject((String)mainResponseStr, CommonResponse.class);
                logger.info("url-{},mainQueryParam-{},mainResponse-{}", new Object[]{url, JSON.toJSONString((Object)mainQueryParam), JSON.toJSONString((Object)mainResponse)});
                if (mainResponse.isSuccess()) {
                    if (var1_3 == null) {
                        ArrayList arrayList = new ArrayList();
                    }
                    var1_5.addAll((Collection)mainResponse.getData());
                } else {
                    logger.error("******************* \u6839\u636e\u6570\u636e\u5730\u5740\u67e5\u8be2\u6570\u636e\u96c6 \u67e5\u8be2\u5931\u8d25\uff1a{}  *******************", (Object)mainResponse.getMsg());
                }
            }
            QueryParam queryParam = new QueryParam();
            if (this.modelEntity.getModelType() == 1 || this.modelEntity.getModelType() == 3 || this.modelEntity.getModelType() == 4 || this.modelEntity.getModelType() == 5) {
                if (ListUtil.isEmpty((List)var1_5)) {
                    ArrayList<JSONObject> arrayList = new ArrayList<JSONObject>();
                    arrayList.add(new JSONObject());
                }
                if (this.setIds.length <= 1) return var1_7;
                ArrayList<String> ids = new ArrayList<String>();
                for (int i = 1; i < this.setIds.length; ++i) {
                    ids.add(this.setIds[i]);
                }
                queryParam.getParams().put("id", new Parameter("in", ids));
            } else {
                queryParam.getParams().put("parentId", new Parameter("eq", (Object)this.setEntity.getId()));
            }
            List childDatasetList = DataModelServiceImpl.this.iDataModelDataSetService.queryList(queryParam);
            if (!ListUtil.isNotEmpty((List)childDatasetList) || !ListUtil.isNotEmpty((List)var1_7)) return var1_7;
            ExecutorService threadPool = Executors.newFixedThreadPool(childDatasetList.size());
            try {
                for (JSONObject mainDataset : var1_7) {
                    ArrayList<Future<List<JSONObject>>> futureList = new ArrayList<Future<List<JSONObject>>>();
                    for (DataModelDataSetEntity dataModelDataSetEntity : childDatasetList) {
                        ChildDatasetCallable childCallable = new ChildDatasetCallable(this.billTypeCode, this.modelEntity, this.billParam, this.billSubParam, dataModelDataSetEntity, mainDataset, this.billData, this.context, this.tenantId, this.authority, this.projectCache, this.baseHost);
                        Future<List<JSONObject>> childFuture = threadPool.submit(childCallable);
                        futureList.add(childFuture);
                    }
                    for (Future future : futureList) {
                        JSONObject childObject;
                        List childList = (List)future.get();
                        if (childList == null || childList.size() <= 0 || null == (childObject = (JSONObject)childList.get(0))) continue;
                        for (Map.Entry entry : childObject.entrySet()) {
                            if (entry.getValue() instanceof BigDecimal && entry.getValue().toString().equals("0E-8")) {
                                mainDataset.put((String)entry.getKey(), (Object)new BigDecimal("0.00"));
                                continue;
                            }
                            mainDataset.put((String)entry.getKey(), entry.getValue());
                        }
                    }
                }
                return var1_7;
            }
            finally {
                threadPool.shutdown();
            }
        }
    }
}

