/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.foundation.share.bean.MaterialEntity;
import com.ejianc.foundation.share.bean.MaterialRelationEntity;
import com.ejianc.foundation.share.service.IMaterialCategoryService;
import com.ejianc.foundation.share.service.IMaterialRelationService;
import com.ejianc.foundation.share.service.IMaterialService;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.share.vo.ZjwjSupplierAccountVO;
import com.ejianc.foundation.share.vo.ZjwjSupplierVO;
import com.ejianc.foundation.util.HttpTookit;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.io.IOException;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.xcontent.XContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/zjwjsupplier/"})
public class ZjwjSupplierController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${zjwjSupl.addr}")
    private String zjwjHost;
    @Value(value="${zjwjSupl.appId}")
    private String appId;
    @Value(value="${zjwjSupl.secret}")
    private String secret;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private IMaterialRelationService materialRelationService;
    @Autowired
    private IMaterialService materialService;
    @Autowired
    private IMaterialCategoryService materialCategoryService;
    @Autowired(required=false)
    private RestHighLevelClient client;

    @RequestMapping(value={"/updateIsesign"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> updateIsesign(@RequestBody ZjwjSupplierVO zjwjSupplierVO) {
        String url = this.zjwjHost + "/el/supl/supplier/updatesupplier";
        JSONObject param1 = new JSONObject();
        param1.put("pkSupplier", (Object)zjwjSupplierVO.getPkSupplier());
        param1.put("isesign", (Object)zjwjSupplierVO.getIsesign());
        return this.doPostHttp(url, param1.toJSONString());
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ZjwjSupplierVO> queryDetail(String pkSupplier) {
        String url = this.zjwjHost + "/el/supl/supplier/queryDetail";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("pkSupplier", pkSupplier);
        HashMap<String, String> headers = new HashMap<String, String>();
        this.getAccessToken(headers);
        try {
            this.logger.info("------------  url\uff1a" + url + "  ------------");
            this.logger.info("------------  \u5165\u53c2\uff1a" + ((Object)params).toString() + "  ------------");
            String back = HttpTookit.get(url, params, headers);
            JSONObject jsonBack = JSONObject.parseObject((String)back);
            if ("200".equals(jsonBack.getString("code"))) {
                this.logger.info("------------  \u8bf7\u6c42\u6210\u529f\uff01body = " + jsonBack.getString("body") + "  ------------");
                ZjwjSupplierVO vo = (ZjwjSupplierVO)JSONObject.parseObject((String)((JSONObject)jsonBack.get((Object)"body")).toJSONString(), ZjwjSupplierVO.class);
                return CommonResponse.success((Object)vo);
            }
            this.logger.info("------------  \u8bf7\u6c42\u5931\u8d25\uff01body = " + jsonBack.toJSONString());
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25");
    }

    @RequestMapping(value={"/getSupplierAccountList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<ZjwjSupplierAccountVO>> getSupplierAccountList(String pkSupplier) {
        String url = this.zjwjHost + "/el/supl/account/getSupplierAccountList";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pkSupplier", pkSupplier);
        params.put("order", "desc");
        params.put("page", 1);
        params.put("rows", 100);
        params.put("sort", "ts");
        HashMap<String, String> headers = new HashMap<String, String>();
        this.getAccessToken(headers);
        try {
            this.logger.info("------------  url\uff1a" + url + "  ------------");
            this.logger.info("------------  \u5165\u53c2\uff1a" + ((Object)params).toString() + "  ------------");
            String back = HttpTookit.get(url, params, headers);
            JSONObject jsonBack = JSONObject.parseObject((String)back);
            if ("200".equals(jsonBack.getString("code"))) {
                this.logger.info("------------  \u8bf7\u6c42\u6210\u529f\uff01body = " + jsonBack.getString("body") + "  ------------");
                JSONObject jsonObject = (JSONObject)jsonBack.get((Object)"body");
                JSONArray jsonArray = (JSONArray)jsonObject.get((Object)"records");
                List voList = JSONObject.parseArray((String)jsonArray.toJSONString(), ZjwjSupplierAccountVO.class);
                return CommonResponse.success((Object)voList);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25");
    }

    @RequestMapping(value={"/addSupplierAccount"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> addSupplierAccount(@RequestBody ZjwjSupplierAccountVO zjwjSupplierAccountVO) {
        String url = this.zjwjHost + "/el/supl/account/addSupplierAccount";
        JSONObject param1 = new JSONObject();
        param1.put("pkSupplier", (Object)zjwjSupplierAccountVO.getPkSupplier());
        param1.put("account", (Object)zjwjSupplierAccountVO.getAccount());
        param1.put("accountStatus", (Object)zjwjSupplierAccountVO.getAccountStatus());
        return this.doPostHttp(url, param1.toJSONString());
    }

    @RequestMapping(value={"/updateSupplierAccount"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> updateSupplierAccount(@RequestBody ZjwjSupplierAccountVO zjwjSupplierAccountVO) {
        String url = this.zjwjHost + "/el/supl/account/updateSupplierAccount";
        JSONObject param1 = new JSONObject();
        param1.put("accountStatus", (Object)zjwjSupplierAccountVO.getAccountStatus());
        param1.put("pkAccount", (Object)zjwjSupplierAccountVO.getPkAccount());
        return this.doPostHttp(url, param1.toJSONString());
    }

    @RequestMapping(value={"/deleteSupplierAccount"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> deleteSupplierAccount(@RequestBody ZjwjSupplierAccountVO zjwjSupplierAccountVO) {
        String url = this.zjwjHost + "/el/supl/account/deleteSupplierAccount";
        JSONObject param1 = new JSONObject();
        param1.put("pkAccount", (Object)zjwjSupplierAccountVO.getPkAccount());
        return this.doPostHttp(url, param1.toJSONString());
    }

    @RequestMapping(value={"/resetmd"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Object> resetmd(Integer pkAccount) {
        String url = this.zjwjHost + "/el/supl/account/resetmd";
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("pkAccount", pkAccount);
        HashMap<String, String> headers = new HashMap<String, String>();
        this.getAccessToken(headers);
        try {
            this.logger.info("------------  url\uff1a" + url + "  ------------");
            this.logger.info("------------  \u5165\u53c2\uff1a" + ((Object)params).toString() + "  ------------");
            String back = HttpTookit.get(url, params, headers);
            JSONObject jsonBack = JSONObject.parseObject((String)back);
            if ("200".equals(jsonBack.getString("code"))) {
                this.logger.info("------------  \u8bf7\u6c42\u6210\u529f\uff01body = " + jsonBack.getString("body") + "  ------------");
                return CommonResponse.success((Object)jsonBack.get((Object)"body"));
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25");
    }

    private CommonResponse<Object> doPostHttp(String url, String parameterStr) {
        HashMap<String, String> headers = new HashMap<String, String>();
        this.getAccessToken(headers);
        try {
            this.logger.info("------------  url\uff1a" + url + "  ------------");
            this.logger.info("------------  \u5165\u53c2\uff1a" + parameterStr + "  ------------");
            String back = HttpTookit.postByJson(url, parameterStr, headers);
            JSONObject jsonBack = JSONObject.parseObject((String)back);
            if ("200".equals(jsonBack.getString("code"))) {
                this.logger.info("------------  \u8bf7\u6c42\u6210\u529f\uff01body = " + jsonBack.getString("body") + "  ------------");
                return CommonResponse.success((Object)jsonBack.get((Object)"body"));
            }
            this.logger.error("------------  \u8bf7\u6c42\u5931\u8d25\uff01message = " + jsonBack.getString("message") + "  ------------");
            return CommonResponse.error((String)jsonBack.getString("message"));
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff01");
        }
    }

    private CommonResponse<String> getAccessToken(Map<String, String> headers) {
        if (this.redisTemplate.opsForValue().get((Object)"X-Open-Token") != null) {
            headers.put("X-Open-Token", this.redisTemplate.opsForValue().get((Object)"X-Open-Token").toString());
        } else {
            String initContextUrl = this.zjwjHost + "/el/sw/auth/v1/accessToken?appId=" + this.appId + "&secret=" + this.secret;
            String responseStr = null;
            try {
                responseStr = HttpTookit.get(initContextUrl, null);
                JSONObject json = JSONObject.parseObject((String)responseStr);
                if (!"200".equals(json.get((Object)"code").toString())) {
                    return CommonResponse.error((String)"\u83b7\u53d6\u4f9b\u65b9access_token\u5f02\u5e38");
                }
                JSONObject data = json.getJSONObject("body");
                String access_token = data.get((Object)"token").toString();
                headers.put("X-Open-Token", access_token);
                this.redisTemplate.opsForValue().set((Object)"X-Open-Token", (Object)access_token, 6000L, TimeUnit.SECONDS);
                this.logger.info("------------  \u83b7\u53d6access_token\u670d\u52a1\uff0c\u8bf7\u6c42\u6210\u529f\uff01data = " + data + "  ------------");
            }
            catch (GeneralSecurityException e) {
                this.logger.info("GeneralSecurityException \u5f02\u5e38" + e.getMessage());
                return CommonResponse.error((String)"\u83b7\u53d6\u4f9b\u65b9access_token\u5f02\u5e38");
            }
            catch (IOException e) {
                this.logger.info("IOException \u5f02\u5e38" + e.getMessage());
                return CommonResponse.error((String)"\u83b7\u53d6\u4f9b\u65b9access_token\u5f02\u5e38");
            }
        }
        return CommonResponse.success();
    }

    @RequestMapping(value={"/initEs"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Object> initEs(@RequestParam(required=false) String pkCorp, @RequestParam(required=false) String sourceMaterialId, @RequestParam(required=false) String tenantId, @RequestParam(required=false) String beginTime, @RequestParam(required=false) String endTime) {
        this.logger.info("make number is 1");
        ExecutorService threadPool = Executors.newFixedThreadPool(1);
        MainDatasetCallable mainDatasetCallable = new MainDatasetCallable(pkCorp, sourceMaterialId, tenantId, beginTime, endTime);
        threadPool.submit(mainDatasetCallable);
        return CommonResponse.success((String)"\u6210\u529f");
    }

    @RequestMapping(value={"/newCorpToEs"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Object> newCorpToEs(@RequestParam(required=false) String pkCorp, @RequestParam(required=false) String params, @RequestParam(required=false) String tenantId, @RequestParam(required=false) String beginTime, @RequestParam(required=false) String endTime) {
        ExecutorService threadPool = Executors.newFixedThreadPool(1);
        CorpToEsCallable mainDatasetCallable = new CorpToEsCallable(pkCorp, params, tenantId, beginTime, endTime);
        threadPool.submit(mainDatasetCallable);
        return CommonResponse.success((String)"\u6210\u529f");
    }

    class CorpToEsCallable
    implements Callable<CommonResponse<String>> {
        private String pkCorp;
        private String params;
        private String tenantId;
        private String beginTime;
        private String endTime;

        public CorpToEsCallable(String pkCorp, String params, String tenantId, String beginTime, String endTime) {
            this.pkCorp = pkCorp;
            this.params = params;
            this.tenantId = tenantId;
            this.beginTime = beginTime;
            this.endTime = endTime;
        }

        @Override
        public CommonResponse<String> call() {
            InvocationInfoProxy.setTenantid((Long)Long.valueOf(this.tenantId));
            boolean flag = true;
            int pageNumber = 1;
            while (flag) {
                ArrayList entityList = new ArrayList();
                BulkRequest bulkRequest = new BulkRequest();
                LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                if (StringUtils.isNotBlank((CharSequence)this.pkCorp)) {
                    wrapper.eq(MaterialRelationEntity::getSourceOrgId, (Object)this.pkCorp);
                } else if (StringUtils.isNotBlank((CharSequence)this.beginTime) && StringUtils.isNotBlank((CharSequence)this.endTime)) {
                    wrapper.between(BaseEntity::getCreateTime, (Object)this.beginTime, (Object)this.endTime);
                } else {
                    return CommonResponse.error((String)"\u7ec4\u7ec7\u548c\u65e5\u671f\u533a\u95f4\u90fd\u4e3a\u7a7a");
                }
                wrapper.eq(StringUtils.isNotBlank((CharSequence)this.params), MaterialRelationEntity::getDef10, (Object)this.params);
                wrapper.last("limit " + (pageNumber - 1) * 5000 + ", 5000");
                List relationEntityList = ZjwjSupplierController.this.materialRelationService.list((Wrapper)wrapper);
                ZjwjSupplierController.this.logger.info("relationEntityList is" + relationEntityList.size());
                if (CollectionUtils.isNotEmpty((Collection)relationEntityList)) {
                    for (MaterialRelationEntity entity : relationEntityList) {
                        if (null != entity.getMaterialId() && null != entity.getCategoryId()) {
                            HashMap<String, Object> dataMap = new HashMap<String, Object>();
                            dataMap.put("materialId", entity.getMaterialId());
                            dataMap.put("categoryId", entity.getCategoryId());
                            dataMap.put("innerCode", entity.getInnerCode());
                            dataMap.put("code", entity.getCode());
                            dataMap.put("categoryName", entity.getCategoryName());
                            dataMap.put("name", entity.getName());
                            dataMap.put("spec", entity.getSpec());
                            dataMap.put("model", entity.getModel());
                            dataMap.put("unitName", entity.getUnitName());
                            dataMap.put("itemType", entity.getType());
                            dataMap.put("sourceOrgId", entity.getSourceOrgId());
                            IndexRequest indexRequest = new IndexRequest("ejc_wj_org_material_relation_es");
                            indexRequest.id(String.valueOf(entity.getId()));
                            indexRequest.source(dataMap, XContentType.JSON);
                            bulkRequest.add(indexRequest);
                            continue;
                        }
                        ZjwjSupplierController.this.logger.info("no material id or categoryId--------\u300b\u300b\u300b" + entity.getId());
                    }
                    try {
                        ZjwjSupplierController.this.logger.info("\u540c\u6b65ES\u5f00\u59cb--------\u300b\u300b\u300b" + entityList.size() + ">>>" + new Date());
                        ZjwjSupplierController.this.client.bulk(bulkRequest, RequestOptions.DEFAULT);
                        ZjwjSupplierController.this.logger.info("\u540c\u6b65ES\u7ed3\u675f--------\u300b\u300b\u300b" + new Date());
                    }
                    catch (Exception e) {
                        ZjwjSupplierController.this.logger.error(e.getMessage());
                    }
                } else {
                    flag = false;
                    ZjwjSupplierController.this.logger.info("no data pageNumber is  ------->" + pageNumber);
                }
                if (relationEntityList.size() < 5000) {
                    flag = false;
                    ZjwjSupplierController.this.logger.info("normal pageNumber is  ------->" + pageNumber);
                }
                ++pageNumber;
            }
            return CommonResponse.success((String)"\u6210\u529f");
        }
    }

    class MainDatasetCallable
    implements Callable<CommonResponse<String>> {
        private String pkCorp;
        private String sourceMaterialId;
        private String tenantId;
        private String beginTime;
        private String endTime;

        public MainDatasetCallable(String pkCorp, String sourceMaterialId, String tenantId, String beginTime, String endTime) {
            this.pkCorp = pkCorp;
            this.sourceMaterialId = sourceMaterialId;
            this.tenantId = tenantId;
            this.beginTime = beginTime;
            this.endTime = endTime;
        }

        @Override
        public CommonResponse<String> call() {
            InvocationInfoProxy.setTenantid((Long)Long.valueOf(this.tenantId));
            boolean flag = true;
            int pageNumber = 1;
            while (flag) {
                ArrayList<MaterialRelationEntity> entityList = new ArrayList<MaterialRelationEntity>();
                BulkRequest bulkRequest = new BulkRequest();
                LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                if (StringUtils.isNotBlank((CharSequence)this.pkCorp)) {
                    wrapper.eq(!"0000".equals(this.pkCorp), MaterialRelationEntity::getSourceOrgId, (Object)this.pkCorp);
                    wrapper.isNull(MaterialRelationEntity::getMaterialId);
                } else if (StringUtils.isNotBlank((CharSequence)this.sourceMaterialId)) {
                    wrapper.eq(MaterialRelationEntity::getSourceMaterialId, (Object)this.sourceMaterialId);
                } else if (StringUtils.isNotBlank((CharSequence)this.beginTime) && StringUtils.isNotBlank((CharSequence)this.endTime)) {
                    wrapper.between(BaseEntity::getCreateTime, (Object)this.beginTime, (Object)this.endTime);
                } else {
                    return CommonResponse.error((String)"\u7ec4\u7ec7\u548c\u6765\u6e90\u7269\u6599\u4e3b\u952e\u90fd\u4e3a\u7a7a");
                }
                wrapper.last("limit " + (pageNumber - 1) * 5000 + ", 5000");
                List relationEntityList = ZjwjSupplierController.this.materialRelationService.list((Wrapper)wrapper);
                ZjwjSupplierController.this.logger.info("relationEntityList is" + relationEntityList.size());
                if (CollectionUtils.isNotEmpty((Collection)relationEntityList)) {
                    for (MaterialRelationEntity entity : relationEntityList) {
                        MaterialEntity materialEntity = ZjwjSupplierController.this.materialService.queryBySourceId(entity.getSourceMaterialId());
                        if (materialEntity == null) continue;
                        entity.setMaterialId(materialEntity.getId());
                        entity.setCategoryId(materialEntity.getCategoryId());
                        entity.setCode(materialEntity.getCode());
                        entity.setName(materialEntity.getName());
                        entity.setSpec(materialEntity.getSpec());
                        entity.setUnitName(materialEntity.getUnitName());
                        entity.setType(1);
                        entity.setEnabled(materialEntity.getEnabled());
                        entity.setSourceId(materialEntity.getSourceId());
                        entity.setDef1(materialEntity.getDef1());
                        entity.setDef2(materialEntity.getDef2());
                        entity.setDef3(materialEntity.getDef3());
                        entity.setDef4(materialEntity.getDef4());
                        entity.setDef5(materialEntity.getDef5());
                        entity.setDef6(materialEntity.getDef6());
                        entity.setDef7(materialEntity.getDef7());
                        entity.setDef8(materialEntity.getDef8());
                        entity.setDef9(materialEntity.getDef9());
                        entity.setDef10(new Date().toString());
                        MaterialCategoryVO materialCategoryVO = ZjwjSupplierController.this.materialCategoryService.queryDetail(materialEntity.getCategoryId());
                        if (materialCategoryVO != null) {
                            entity.setCategoryName(materialCategoryVO.getName());
                            entity.setInnerCode(materialCategoryVO.getInnerCode());
                        }
                        entityList.add(entity);
                        HashMap<String, Object> dataMap = new HashMap<String, Object>();
                        dataMap.put("materialId", entity.getMaterialId());
                        dataMap.put("categoryId", entity.getCategoryId());
                        dataMap.put("innerCode", entity.getInnerCode());
                        dataMap.put("code", entity.getCode());
                        dataMap.put("categoryName", entity.getCategoryName());
                        dataMap.put("name", entity.getName());
                        dataMap.put("spec", entity.getSpec());
                        dataMap.put("model", entity.getModel());
                        dataMap.put("unitName", entity.getUnitName());
                        dataMap.put("itemType", entity.getType());
                        dataMap.put("sourceOrgId", entity.getSourceOrgId());
                        IndexRequest indexRequest = new IndexRequest("ejc_wj_org_material_relation_es");
                        indexRequest.id(String.valueOf(entity.getId()));
                        indexRequest.source(dataMap, XContentType.JSON);
                        bulkRequest.add(indexRequest);
                    }
                    ZjwjSupplierController.this.logger.info("\u4fdd\u5b58\u5f00\u59cb--------\u300b\u300b\u300b" + entityList.size() + ">>>" + new Date());
                    ZjwjSupplierController.this.materialRelationService.saveOrUpdateBatch(entityList);
                    ZjwjSupplierController.this.logger.info("\u4fdd\u5b58\u7ed3\u675f--------\u300b\u300b\u300b" + new Date());
                    try {
                        ZjwjSupplierController.this.client.bulk(bulkRequest, RequestOptions.DEFAULT);
                    }
                    catch (Exception e) {
                        ZjwjSupplierController.this.logger.error(e.getMessage());
                    }
                } else {
                    flag = false;
                    ZjwjSupplierController.this.logger.info("no data pageNumber is  ------->" + pageNumber);
                }
                if (relationEntityList.size() < 5000) {
                    flag = false;
                    ZjwjSupplierController.this.logger.info("normal pageNumber is  ------->" + pageNumber);
                }
                ++pageNumber;
            }
            return CommonResponse.success((String)"\u6210\u529f");
        }
    }
}

