/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.support.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.billcode.BillCodeException;
import com.ejianc.foundation.support.bean.BillTypeEntity;
import com.ejianc.foundation.support.service.IBillCodeGenerator;
import com.ejianc.foundation.support.service.IBillTypeService;
import com.ejianc.foundation.support.service.IModuleService;
import com.ejianc.foundation.support.vo.BillTypeVO;
import com.ejianc.foundation.support.vo.ModuleVO;
import com.ejianc.foundation.support.vo.PublishVO;
import com.ejianc.foundation.support.vo.ReferShowfieldVO;
import com.ejianc.foundation.support.vo.ReferVO;
import com.ejianc.foundation.util.DataTransferUtil;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/billtype/"})
public class BillTypeController
implements Serializable {
    private Gson gson = new Gson();
    private static final long serialVersionUID = 1L;
    private static final String BILLTYPE_BILL_CODE = "SUPPORT_BILLTYPE";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeService billTypeService;
    @Autowired
    private IBillCodeGenerator generator;
    @Autowired
    private IModuleService moduleService;
    @Autowired
    private EnvironmentTools environmentTools;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveOrUpdate(@RequestBody BillTypeVO billTypeVo) throws BillCodeException {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (billTypeVo.getId() != null && billTypeVo.getId() > 0L) {
            BillTypeVO uniqueBean = this.billTypeService.queryDetail(billTypeVo.getId());
            uniqueBean.setBillCode(billTypeVo.getBillCode());
            uniqueBean.setBillName(billTypeVo.getBillName());
            uniqueBean.setMetadataId(billTypeVo.getMetadataId());
            if (StringUtils.isNotBlank((CharSequence)billTypeVo.getMetadataName())) {
                uniqueBean.setMetadataName(billTypeVo.getMetadataName());
            }
            BillTypeEntity billTypeEntity = (BillTypeEntity)((Object)BeanMapper.map((Object)uniqueBean, BillTypeEntity.class));
            this.billTypeService.saveOrUpdate((Object)billTypeEntity, false);
            return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f");
        }
        String billCode = this.generator.generateBillCodeById(BILLTYPE_BILL_CODE, tenantId);
        billTypeVo.setBillCode(billCode);
        BillTypeEntity billTypeEntity = (BillTypeEntity)((Object)BeanMapper.map((Object)billTypeVo, BillTypeEntity.class));
        this.billTypeService.saveOrUpdate((Object)billTypeEntity, false);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BillTypeVO> queryDetail(@RequestParam Long id) {
        BillTypeVO billTypeVo = this.billTypeService.queryDetail(id);
        return CommonResponse.success((Object)billTypeVo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        this.billTypeService.delete(ids);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/pageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam queryParam) {
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getOrderMap().put("createTime", "desc");
        IPage pageData = this.billTypeService.queryPage(queryParam, false);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", (Object)pageData);
        return CommonResponse.success((Object)jsonObject);
    }

    @GetMapping(value={"/billTypeTree"})
    @ResponseBody
    public CommonResponse<List<Map<String, Object>>> getBillTypeTree() {
        try {
            return CommonResponse.success(this.billTypeService.getBillTypeTree());
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u7f16\u7801\u7c7b\u578b\u6811\u5f02\u5e38,", (Throwable)e);
            return CommonResponse.error((String)"\u67e5\u8be2\u7f16\u7801\u7c7b\u578b\u6811\u5931\u8d25", (Throwable)e);
        }
    }

    @GetMapping(value={"pageListRef"})
    public CommonResponse<IPage<BillTypeEntity>> loadReferModuleList(@RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=false) String relyCondition, @RequestParam(required=false) String searchText, @RequestParam(required=false) String condition) {
        JSONObject json;
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            queryParam.getParams().put("billName", new Parameter("like", (Object)searchText));
        }
        if (StringUtils.isNotBlank((CharSequence)condition) && (json = JSONObject.parseObject((String)condition)).get((Object)"moduleId") != null) {
            Long moduleId = Long.parseLong(json.get((Object)"moduleId").toString());
            queryParam.getParams().put("moduleId", new Parameter("eq", (Object)moduleId));
        }
        if (StringUtils.isNotBlank((CharSequence)relyCondition)) {
            Long moduleId = Long.parseLong(relyCondition.split("=")[1]);
            queryParam.getParams().put("moduleId", new Parameter("eq", (Object)moduleId));
        }
        queryParam.getOrderMap().put("createTime", "desc");
        IPage pageData = this.billTypeService.queryPage(queryParam, false);
        return CommonResponse.success((Object)pageData);
    }

    @GetMapping(value={"/findByCode"})
    @ResponseBody
    public CommonResponse<ReferVO> findByCode(@RequestParam String refCode) {
        ReferVO refer = new ReferVO();
        ArrayList<ReferShowfieldVO> gridHeaders = new ArrayList<ReferShowfieldVO>();
        ReferShowfieldVO idHeader = new ReferShowfieldVO();
        ReferShowfieldVO entityHeader = new ReferShowfieldVO();
        ReferShowfieldVO displayHeader = new ReferShowfieldVO();
        ReferShowfieldVO entityFullHeader = new ReferShowfieldVO();
        switch (refCode) {
            case "metadata-treegrid": {
                refer.setRefCode("metadata-treegrid");
                refer.setRefName("\u5143\u6570\u636e");
                refer.setRefType("treegrid");
                refer.setTreerelyurl(this.environmentTools.getBaseHost() + "ejc-metadata-web/project/queryProjectTree");
                refer.setDataurl(this.environmentTools.getBaseHost() + "ejc-metadata-web/cls/referClsPage");
                refer.setIdField("id");
                refer.setCodeField("entityName");
                refer.setNameField("displayName");
                refer.setRelyfield("projectId");
                refer.setId(Long.valueOf(new Date().getTime()));
                idHeader.setId(Long.valueOf(1L));
                idHeader.setName("\u4e3b\u952e");
                idHeader.setCode("id");
                idHeader.setHidden(true);
                idHeader.setShowOrder(Integer.valueOf(1));
                idHeader.setType("string");
                gridHeaders.add(idHeader);
                entityHeader.setId(Long.valueOf(2L));
                entityHeader.setName("\u5b9e\u4f53\u540d\u79f0");
                entityHeader.setCode("entityName");
                entityHeader.setHidden(false);
                entityHeader.setShowOrder(Integer.valueOf(1));
                entityHeader.setType("string");
                gridHeaders.add(entityHeader);
                displayHeader.setId(Long.valueOf(3L));
                displayHeader.setName("\u663e\u793a\u540d\u79f0");
                displayHeader.setCode("displayName");
                displayHeader.setHidden(false);
                displayHeader.setShowOrder(Integer.valueOf(1));
                displayHeader.setType("string");
                gridHeaders.add(displayHeader);
                entityFullHeader.setId(Long.valueOf(4L));
                entityFullHeader.setName("\u5b9e\u4f53\u5168\u540d");
                entityFullHeader.setCode("entityFullName");
                entityFullHeader.setHidden(false);
                entityFullHeader.setShowOrder(Integer.valueOf(1));
                entityFullHeader.setType("string");
                gridHeaders.add(entityFullHeader);
                refer.setGridheaders(gridHeaders);
            }
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", (Object)refer);
        return CommonResponse.success((Object)refer);
    }

    @ResponseBody
    @RequestMapping(value={"publish"})
    public CommonResponse<String> publish(@RequestBody PublishVO publishVO) {
        try {
            String targetEnv = publishVO.getTarget();
            if (StringUtils.isBlank((CharSequence)targetEnv)) {
                return CommonResponse.error((String)"\u53d1\u5e03\u6570\u636e\u5931\u8d25:\u76ee\u6807\u73af\u5883\u57df\u540d\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            String scope = publishVO.getScope();
            if (StringUtils.isBlank((CharSequence)scope)) {
                return CommonResponse.error((String)"\u53d1\u5e03\u6570\u636e\u5931\u8d25:\u6570\u636e\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            ArrayList<Long> ids = null;
            ArrayList<String> codes = null;
            List baseEntities = null;
            if ("all".equalsIgnoreCase(scope)) {
                QueryParam queryParam = new QueryParam();
                List<ModuleVO> moduleVOs = this.moduleService.queryAllChildrenByPid(publishVO.getModuleId());
                ArrayList<Long> moduleIds = new ArrayList<Long>();
                for (ModuleVO vo : moduleVOs) {
                    moduleIds.add(vo.getId());
                }
                HashMap<String, Parameter> params = new HashMap<String, Parameter>();
                params.put("moduleId", new Parameter("in", moduleIds));
                queryParam.setParams(params);
                baseEntities = this.billTypeService.queryList(queryParam, false);
            } else if ("select".equalsIgnoreCase(scope)) {
                if (publishVO.getIdList() != null && publishVO.getIdList().size() > 0) {
                    baseEntities = (List)this.billTypeService.listByIds(publishVO.getIdList());
                } else {
                    return CommonResponse.error((String)"\u672a\u9009\u4e2d\u8981\u53d1\u5e03\u7684\u6570\u636e");
                }
            }
            if (ids == null || ids.isEmpty() || codes == null || codes.isEmpty()) {
                ids = new ArrayList<Long>(baseEntities.size());
                codes = new ArrayList<String>(baseEntities.size());
                for (BillTypeEntity entity : baseEntities) {
                    if (entity.getId() != null) {
                        ids.add(entity.getId());
                    }
                    if (!StringUtils.isNotBlank((CharSequence)entity.getBillCode())) continue;
                    codes.add(entity.getBillCode());
                }
            }
            ArrayList<String> sqls = new ArrayList<String>();
            List<String> deleteSql = this.getDeleteSql(ids, codes);
            List<String> insertSql = this.getInsertSql(baseEntities);
            if (deleteSql != null && !deleteSql.isEmpty()) {
                sqls.addAll(deleteSql);
            }
            if (insertSql != null && !insertSql.isEmpty()) {
                sqls.addAll(insertSql);
            }
            String url = publishVO.getTarget() + "/ejc-support-web/dataTransfer/transferBySql";
            HashMap<String, ArrayList<String>> params = new HashMap<String, ArrayList<String>>();
            params.put("sql", sqls);
            this.gson = new GsonBuilder().disableHtmlEscaping().create();
            String paramterStr = this.gson.toJson(params);
            this.logger.info("\u53d1\u5e03\u6570\u636e\u7684url\uff1a---------------" + url);
            try {
                String result = ReferHttpClientUtils.postByJson((String)url, (String)paramterStr);
                this.logger.info("\u53d1\u5e03\u6570\u636e\u8fd4\u56de\u7684\u7ed3\u679c\uff1a---------------" + result);
                return (CommonResponse)this.gson.fromJson(result, CommonResponse.class);
            }
            catch (Exception e) {
                e.printStackTrace();
                return CommonResponse.error((String)"\u53d1\u5e03\u53c2\u7167\u6570\u636e\u5931\u8d25");
            }
        }
        catch (Exception e) {
            return CommonResponse.error((String)("\u53d1\u5e03\u53c2\u7167\u6570\u636e\u5931\u8d25:" + e.getMessage()));
        }
    }

    private List<String> getDeleteSql(List<Long> ids, List<String> codes) {
        if (ids == null || ids.isEmpty()) {
            return null;
        }
        ArrayList<String> sqlList = new ArrayList<String>();
        String idStr = "";
        for (Long l : ids) {
            idStr = idStr + "'" + l + "',";
        }
        String codeStr = "";
        for (String code : codes) {
            codeStr = codeStr + "'" + code + "',";
        }
        idStr = "(" + idStr.substring(0, idStr.lastIndexOf(",")) + ")";
        codeStr = "(" + codeStr.substring(0, codeStr.lastIndexOf(",")) + ")";
        String string = "ejc_support_billtype";
        String deleteBaseSql = " delete from " + string + " where id in " + idStr + ";";
        String deleteByCodeSql = " delete from " + string + " where dr =1 and bill_code in " + codeStr + ";";
        sqlList.add(deleteBaseSql);
        sqlList.add(deleteByCodeSql);
        return sqlList;
    }

    private List<String> getInsertSql(List<BillTypeEntity> baseEntityList) throws Exception {
        ArrayList<String> retList = new ArrayList<String>();
        List<String> baseInsertSql = DataTransferUtil.getInsertSql(baseEntityList);
        if (baseInsertSql != null && !baseInsertSql.isEmpty()) {
            retList.addAll(baseInsertSql);
        }
        return retList;
    }

    @ResponseBody
    @RequestMapping(value={"/exportSQL"})
    public void exportSQL(HttpServletRequest req, HttpServletResponse response, @RequestBody PublishVO publishVO) {
        try {
            String scope = publishVO.getScope();
            if (StringUtils.isBlank((CharSequence)scope)) {
                throw new BusinessException("\u5bfc\u51fa\u811a\u672c\u5931\u8d25:\u6570\u636e\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            ArrayList<Long> ids = null;
            ArrayList<String> codes = null;
            List baseEntities = null;
            if ("all".equalsIgnoreCase(scope)) {
                QueryParam queryParam = new QueryParam();
                List<ModuleVO> moduleVOs = this.moduleService.queryAllChildrenByPid(publishVO.getModuleId());
                ArrayList<Long> moduleIds = new ArrayList<Long>();
                for (ModuleVO vo : moduleVOs) {
                    moduleIds.add(vo.getId());
                }
                HashMap<String, Parameter> params = new HashMap<String, Parameter>();
                params.put("moduleId", new Parameter("in", moduleIds));
                queryParam.setParams(params);
                baseEntities = this.billTypeService.queryList(queryParam, false);
            } else if ("select".equalsIgnoreCase(scope)) {
                if (publishVO.getIdList() != null && publishVO.getIdList().size() > 0) {
                    baseEntities = (List)this.billTypeService.listByIds(publishVO.getIdList());
                } else {
                    throw new BusinessException("\u672a\u9009\u4e2d\u8981\u5bfc\u51fa\u811a\u672c\u7684\u6570\u636e!");
                }
            }
            if (ids == null || ids.isEmpty() || codes == null || codes.isEmpty()) {
                ids = new ArrayList<Long>(baseEntities.size());
                codes = new ArrayList<String>(baseEntities.size());
                for (BillTypeEntity entity : baseEntities) {
                    if (entity.getId() != null) {
                        ids.add(entity.getId());
                    }
                    if (!StringUtils.isNotBlank((CharSequence)entity.getBillCode())) continue;
                    codes.add(entity.getBillCode());
                }
            }
            ArrayList<String> sqls = new ArrayList<String>();
            List<String> deleteSql = this.getDeleteSql(ids, codes);
            List<String> insertSql = this.getInsertSql(baseEntities);
            if (deleteSql != null && !deleteSql.isEmpty()) {
                sqls.addAll(deleteSql);
            }
            if (insertSql != null && !insertSql.isEmpty()) {
                sqls.addAll(insertSql);
            }
            StringBuffer fileName = new StringBuffer();
            fileName.append("billType.sql");
            response.setContentType("application/octet-stream; charset=utf-8");
            response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(fileName.toString(), "UTF-8"));
            ServletOutputStream out = response.getOutputStream();
            out.write(String.join((CharSequence)"\r\n", sqls).getBytes());
            out.flush();
            out.close();
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            response.setStatus(400);
        }
    }
}

