/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.support.controller.api;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.metadata.api.IMdApi;
import com.ejianc.foundation.metadata.vo.MdReferVO;
import com.ejianc.foundation.support.service.IBillTypeService;
import com.ejianc.foundation.support.vo.BillTypeVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.google.gson.Gson;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/billTypeApi/"})
public class BillTypeApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private Gson gson = new Gson();
    @Autowired
    private IBillTypeService billTypeService;
    @Autowired
    private IMdApi mdApi;

    @GetMapping(value={"getByCode"})
    public CommonResponse<BillTypeVO> getCodeBatchByRuleCode(@RequestParam(value="code") String code) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("billCode", new Parameter("eq", (Object)code));
        IPage pageData = this.billTypeService.queryPage(queryParam, false);
        if (pageData.getTotal() > 0L) {
            BillTypeVO vo = (BillTypeVO)BeanMapper.map(pageData.getRecords().get(0), BillTypeVO.class);
            return CommonResponse.success((Object)vo);
        }
        this.logger.error("\u6839\u636e\u5355\u636e\u7f16\u7801\u83b7\u53d6\u5355\u636e\u4fe1\u606f ---- \u83b7\u53d6\u5931\u8d25code={}", (Object)code);
        return CommonResponse.error((String)"\u83b7\u53d6\u5931\u8d25");
    }

    @GetMapping(value={"getById"})
    public CommonResponse<BillTypeVO> getById(@RequestParam(value="id") Long id) {
        BillTypeVO vo = this.billTypeService.queryDetail(id);
        return CommonResponse.success((Object)vo);
    }

    @RequestMapping(value={"queryMetadataByBillType"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MdReferVO> queryMetadataByBillType(@RequestParam(value="billTypeCode", required=true) String billTypeCode) {
        try {
            CommonResponse<BillTypeVO> back = this.getCodeBatchByRuleCode(billTypeCode);
            if (back.getCode() == 0) {
                this.logger.info("\u6839\u636e\u5355\u636e\u7c7b\u578b\u7f16\u7801\uff1a" + billTypeCode + "");
                if (back.getData() != null && ((BillTypeVO)back.getData()).getMetadataId() != null) {
                    CommonResponse refVO = this.mdApi.queryMetadataById(((BillTypeVO)back.getData()).getMetadataId());
                    if (refVO.getCode() == 0 && refVO.getData() != null) {
                        return CommonResponse.success((Object)refVO.getData());
                    }
                    return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u8be5\u5355\u636e\u7c7b\u578b\u5bf9\u5e94\u7684\u5143\u6570\u636e");
                }
                this.logger.error("\u5355\u636e\u7c7b\u578b\u7f16\u7801\uff1a" + billTypeCode + "\u672a\u4e0e\u5143\u6570\u636e\u5173\u8054");
                return CommonResponse.error((String)"\u8be5\u5355\u636e\u7c7b\u578b\u672a\u4e0e\u5143\u6570\u636e\u5173\u8054");
            }
            this.logger.error("\u6839\u636e\u5355\u636e\u7c7b\u578b\u7f16\u7801\uff1a" + billTypeCode + "\u672a\u67e5\u8be2\u5355\u636e\u7c7b\u578b\u5bf9\u5e94\u7684\u5355\u636e\u5b9e\u4f53");
            return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u8be5\u5355\u636e\u7c7b\u578b\u5bf9\u5e94\u7684\u5355\u636e\u5b9e\u4f53");
        }
        catch (Exception e) {
            this.logger.error("\u7cfb\u7edf\u5f02\u5e38\uff1a" + e.getMessage());
            e.printStackTrace();
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25");
        }
    }

    @GetMapping(value={"checkQuote"})
    public CommonResponse<String> checkQuote(@RequestParam(value="billTypeCode") String billTypeCode, @RequestParam(value="billId") Long billId) {
        return this.billTypeService.checkQuote(billTypeCode, billId);
    }

    @GetMapping(value={"getByRefCode"})
    public CommonResponse<BillTypeVO> getByRefCode(@RequestParam(value="refCode") String refCode) {
        CommonResponse mdReferResp = this.mdApi.queryByRefCode(refCode);
        if (!mdReferResp.isSuccess()) {
            return CommonResponse.error((String)("\u83b7\u53d6refCode\u5bf9\u5e94\u5143\u6570\u636e\u5931\u8d25\uff0c" + mdReferResp.getMsg()));
        }
        BillTypeVO billTypeVO = this.billTypeService.getByMetadataId(((MdReferVO)mdReferResp.getData()).getMetadataId());
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)billTypeVO);
    }

    @GetMapping(value={"queryBillTypeByModuleId"})
    public CommonResponse<List<BillTypeVO>> queryBillTypeByModuleId(@RequestParam(value="moduleId") Long moduleId) {
        QueryWrapper billTypeWrapper = new QueryWrapper();
        billTypeWrapper.eq((Object)"module_id", (Object)moduleId);
        List billTypeEntities = this.billTypeService.list((Wrapper)billTypeWrapper);
        List billTypeVos = BeanMapper.mapList((Iterable)billTypeEntities, BillTypeVO.class);
        return CommonResponse.success((Object)billTypeVos);
    }
}

