/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.support.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.support.mapper.DataTransferMapper;
import com.ejianc.foundation.support.service.IDataTransferService;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.List;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataTransferService
implements IDataTransferService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private DataTransferMapper dataTransferMapper;
    @Autowired
    private SqlSessionTemplate sqlSessionTemplate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommonResponse<String> executeSql(List<String> sqls) {
        this.LOGGER.info("\u5f85\u53d1\u5e03sql:{}", (Object)JSONObject.toJSONString(sqls));
        try (SqlSession session = this.sqlSessionTemplate.getSqlSessionFactory().openSession(ExecutorType.BATCH, false);){
            String sqlUnion = "";
            for (int i = 0; i < sqls.size(); ++i) {
                sqlUnion = sqlUnion + sqls.get(i);
                if (i == 0 || i % 400 != 0 && i != sqls.size() - 1) continue;
                this.dataTransferMapper.executeSql(sqlUnion);
                session.commit();
                session.clearCache();
                this.LOGGER.info("\u53d1\u5e03\u6210\u529f\u7684sql:{}", (Object)sqlUnion);
                sqlUnion = "";
            }
        }
        return CommonResponse.success((String)"\u53d1\u5e03\u6210\u529f");
    }
}

