package com.ejianc.foundation.share.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.billcode.BillCodeException;
import com.ejianc.foundation.share.bean.MaterialEntity;
import com.ejianc.foundation.share.vo.MaterialFuzzyMatchVO;
import com.ejianc.foundation.share.vo.MaterialPlusVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;

import java.util.List;
import java.util.Map;

public interface IMaterialService {

	/**
	 * 根据分类ID查询其下物料
	 *
	 * @param categoryId
	 *
	 * @return
	 */
	List<MaterialVO> queryListByCategoryId(Long categoryId);

	/**
	 * 查询详情
	 *
	 * @param id
	 * @return
	 */
	MaterialVO queryDetail(Long id);

	/**
	 * 修改
	 *
	 * @param uniqueBean
	 */
	void update(MaterialVO uniqueBean);

	/**
	 * 保存
	 *
	 * @param materialVo
	 */
	void save(MaterialVO materialVo);

	/**
	 * 批量保存
	 *
	 * @param materialVo
	 */
	void insertBatch(List<MaterialVO> materialVo);

	/**
	 * 删除
	 *
	 * @param ids
	 */
	void delete(List<Long> ids);

	/**
	 * 查询翻页
	 *
	 * @param queryParam
	 * @return
	 */
	IPage<MaterialEntity> queryPage(QueryParam queryParam);

	/**
	 * 查询是否已经存在
	 *
	 * @param name
	 * @param spec
	 * @param unitName
	 * @return
	 */
	MaterialVO queryExitFlag(String name, String spec, String unitName, Long categoryId);

	/**
	 * 根据code查询物料
	 *
	 * @param code
	 * @return
	 */
	MaterialVO queryByCode(String code);

	/**
	 * 查询列表
	 *
	 * @param queryParam
	 * @return
	 */
	List<MaterialEntity> queryList(QueryParam queryParam);

	/**
	 * 从平台中拷贝
	 */
	void insertMaterialListFromPlatform();

	/**
	 * 查询材料参照
	 *
	 * @param params
	 * @return
	 */
	IPage<MaterialEntity> queryRefMaterialPage(Map<String, Object> params);

	/**
	 * 根据sourceId查询物资详情
	 *
	 * @param sourceId
	 * @return
	 */
	MaterialEntity queryBySourceId(String sourceId);

	/**
	 * 根据ids查询物资列表（包括物资来源id，物资分类来源id）
	 *
	 * @param ids
	 * @return
	 */
	List<MaterialEntity> queryMaterialByIds(List<Long> ids);

	IPage<MaterialEntity> queryZjwjRefMaterialPage(Map<String, Object> params);

	List<MaterialEntity> queryMaterialListByNames(List<String> nameList);

	MaterialVO queryLastMaterialByTime();

	List<MaterialVO> queryMaterialList(String name, String spec, String unitName);

	/**
	 * 校验档案是否存在
	 *
	 * @param materialFuzzyMatchVO 材料设备模糊匹配VO
	 *
	 * @return {@link MaterialFuzzyMatchVO}
	 */
	MaterialFuzzyMatchVO checkArchive(MaterialFuzzyMatchVO materialFuzzyMatchVO);

	/**
	 * 模糊匹配数量
	 *
	 * @param materialFuzzyMatchVO 材料设备模糊匹配VO
	 *
	 * @return {@link MaterialFuzzyMatchVO}
	 */
	MaterialFuzzyMatchVO fuzzyMatchNumber(MaterialFuzzyMatchVO materialFuzzyMatchVO);


	/**
	 * 模糊匹配分页查询
	 *
	 * @param current       当前页码
	 * @param size          条数
	 * @param name          清单名称
	 * @param type          费用类型
	 * @param categoryName  分类名称
	 * @param spec          规格型号
	 * @param unitName      单位名称
	 * @param fuzzyName     清单名称模糊
	 * @param fuzzySpec     规格型号模糊
	 * @param fuzzyUnitName 单位名称模糊
	 *
	 * @return {@link IPage}<{@link MaterialPlusVO}>
	 */
	IPage<MaterialPlusVO> fuzzyMatchQueryPage(long current, long size, String name, Integer type, String categoryName, String spec, String unitName, String fuzzyName, String fuzzySpec, String fuzzyUnitName);


	/**
	 * 批量插入档案
	 *
	 * @param materialVOMap 材料设备VO
	 *
	 * @return {@link CommonResponse}<{@link Map}<{@link String}, {@link MaterialVO}>>
	 *
	 * @throws BillCodeException 单据编码异常
	 */
	CommonResponse<Map<String, MaterialVO>> batchInsertArchive(Map<String, MaterialVO> materialVOMap) throws BillCodeException;

	void enableOrDisable(List<Long> ids, String innerCode, Integer enabled);

	/**
	 * 查询物资到AI向量库
	 *
	 * @param tenantId 租户ID
	 * @param size     条数
	 *
	 * @return {@link List}<{@link MaterialEntity}>
	 */
	List<MaterialEntity> queryMaterialsToAi(Long tenantId,Integer size);
}
