package com.ejianc.foundation.support.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

/**
 * 参照管理显示字段实体
 */
@TableName("ejc_support_refer_showfield")
public class ReferShowfieldEntity extends BaseEntity {

	private static final long serialVersionUID = 1L;
	
	/**
     * 参照定义主表id
     */
    @TableField(value = "refer_id")
    private Long referId;
	
	/**
     * 字段编号
     */
    @TableField(value = "code")
    private String code;
	
	/**
     * 字段名称
     */
    @TableField(value = "name")
    private String name;
	
	/**
     * 字段类型
     */
    @TableField(value = "type")
    private String type;
	
	/**
     * 是否隐藏
     */
    @TableField(value = "hidden")
    private boolean hidden;

	/**
     * 移动端是否显示，默认不显示
     */
    @TableField(value = "mobile_show")
    private boolean mobileShow;
	/**
     * 超链接地址
     */
    @TableField(value = "link_url")
    private String linkUrl;

	/**
	 *	是否搜索字段
	 */
    @TableField(value = "inner_filter")
	private boolean innerFilter;
	
	/**
     * 显示顺序
     */
    @TableField(value = "show_order")
    private Integer showOrder;

	@TableField(value = "format")
	private String format; // 列显示格式(当为时间显示时分秒，小数位的显示数量等等)

	/**
	 * 小数字段显示是否补零
	 */
	@TableField(value = "with_zero")
	private boolean withZero;

	@TableField(value = "align")
	private String align; // 对齐方式

	/**
	 * 列宽
	 */
	@TableField(value = "width")
	private Integer width;

	public Long getReferId() {
		return referId;
	}

	public void setReferId(Long referId) {
		this.referId = referId;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public boolean getHidden() {
		return hidden;
	}

	public void setHidden(boolean hidden) {
		this.hidden = hidden;
	}

	public boolean getMobileShow() {
		return mobileShow;
	}

	public void setMobileShow(boolean mobileShow) {
		this.mobileShow = mobileShow;
	}

	public String getLinkUrl() {
		return linkUrl;
	}

	public void setLinkUrl(String linkUrl) {
		this.linkUrl = linkUrl;
	}

	public Integer getShowOrder() {
		return showOrder;
	}

	public void setShowOrder(Integer showOrder) {
		this.showOrder = showOrder;
	}

	public boolean getInnerFilter() {
		return innerFilter;
	}

	public void setInnerFilter(boolean innerFilter) {
		this.innerFilter = innerFilter;
	}

	public String getFormat() {
		return format;
	}

	public void setFormat(String format) {
		this.format = format;
	}

	public boolean getWithZero() {
		return withZero;
	}

	public void setWithZero(boolean withZero) {
		this.withZero = withZero;
	}

	public String getAlign() {
		return align;
	}

	public void setAlign(String align) {
		this.align = align;
	}

	public Integer getWidth() {
		return width;
	}

	public void setWidth(Integer width) {
		this.width = width;
	}
}
