package com.ejianc.foundation.support.controller;

import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.support.bean.*;
import com.ejianc.foundation.support.service.IDefdocAttrService;
import com.ejianc.foundation.support.vo.*;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.support.service.IDataTransferService;
import com.ejianc.foundation.support.service.IDefdocDetailService;
import com.ejianc.foundation.support.service.IDefdocService;
import com.ejianc.foundation.tenant.api.ITenantApi;
import com.ejianc.foundation.util.DataTransferUtil;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

/**
 * 自定义档案controller
 * 
 * @author guominga
 *
 */
@RestController
@RequestMapping("/defdoc/")
public class DefdocController implements Serializable {

    private Logger logger = LoggerFactory.getLogger(this.getClass());
	private Gson gson = new Gson();

	private static final long serialVersionUID = 1L;
	
	@Value("${oms.tenantid}")
	private String OMS_TENANT;
	
	@Autowired
	private IDefdocService defdocService;
	@Autowired
	private IDefdocDetailService defdocDetailService;
	@Autowired
	private ITenantApi tenantApi;
	@Autowired
	private IDataTransferService dataTransferService;
	@Autowired
	private IDefdocAttrService defdocAttrServiceImpl;

	/**
	 * 新增或者修改
	 * 
	 * @return
	 */
	@RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> saveOrUpdate(@RequestBody DefdocVO defdocVo) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		if(!OMS_TENANT.equals(tenantId.toString())) {
			return CommonResponse.error("您没有权限执行此操作");
		}
		if(defdocVo.getId() != null && defdocVo.getId() > 0) {
			DefdocVO uniqueBean = defdocService.queryDetail(defdocVo.getId());
			List<DefdocVO> list = defdocService.queryByCode(defdocVo.getCode());
			if(list.size()>1 || (list.size() == 1 && !list.get(0).getId().equals(defdocVo.getId()))){
				return CommonResponse.error("修改失败：档案编码与【"+list.get(0).getName()+"】重复！");
			}
			uniqueBean.setCode(defdocVo.getCode());
			uniqueBean.setName(defdocVo.getName());
			uniqueBean.setSequence(defdocVo.getSequence());
			uniqueBean.setDescription(defdocVo.getDescription());
			uniqueBean.setAttrs(defdocVo.getAttrs());
			DefdocEntity defdocEntity = BeanMapper.map(uniqueBean, DefdocEntity.class);
			defdocService.saveOrUpdate(defdocEntity, false);
			return CommonResponse.success("修改成功");
		}else{
			DefdocEntity defdocEntity = BeanMapper.map(defdocVo, DefdocEntity.class);
			List<DefdocVO> list = defdocService.queryByCode(defdocVo.getCode());
			if(!ListUtil.isEmpty(list)){
				return CommonResponse.error("保存失败：档案编码与【"+list.get(0).getName()+"】重复！");
			}
			defdocService.saveOrUpdate(defdocEntity, false);
			return CommonResponse.success("保存成功");
		}
	}
	
	/**
	 * 根据主键ID查询编码规则详情
	 * 
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<DefdocVO> queryDetail(@RequestParam Long id) {
		DefdocVO defdocVo = defdocService.queryDetail(id);
		return CommonResponse.success(defdocVo);
	}
	
	/**
	 * 删除
	 * 
	 * @param ids
	 * @return
	 */
	@RequestMapping(value = "/delete", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> delete(@RequestBody List<Long> ids) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		if(!OMS_TENANT.equals(tenantId.toString())) {
			return CommonResponse.error("您没有权限执行此操作");
		}
		//先判断要删除的自定义档案下面有没有档案项，有档案项不允许删除
		List<DefdocDetailVO> defdocDetails = defdocDetailService.queryListByDefdocId(ids);
		if(defdocDetails != null && defdocDetails.size() > 0) {
			return CommonResponse.error("要删除的自定义档案下有档案项，不允许删除");
		}else{
			defdocService.delete(ids);
			return CommonResponse.success("删除成功");
		}
	}
	
	/**
	 * 查询待分页的列表
	 * 
	 * @param queryParam
	 * @return
	 */
	@RequestMapping(value = "/pageList", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<JSONObject> pageList(@RequestBody QueryParam queryParam) {
		queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, OMS_TENANT));
		queryParam.getOrderMap().put("sequence", QueryParam.ASC);
		IPage<DefdocEntity> pageData = defdocService.queryPage(queryParam, false);
		if(ListUtil.isNotEmpty(pageData.getRecords())){
			queryParam = new QueryParam();
			for (DefdocEntity record : pageData.getRecords()) {
				queryParam.getParams().put("pid",new Parameter(QueryParam.EQ,record.getId()));
				record.setAttrs(defdocAttrServiceImpl.queryList(queryParam));
			}
		}
		JSONObject jsonObject = new JSONObject();
		jsonObject.put("data", pageData);
		return CommonResponse.success(jsonObject);
	}

	/**
	 * @Author mrsir_wxp
	 * @Date 2020/5/12
	 * @Description ref 自定义档案参照查询
	 * @Param [queryParam]
	 * @Return com.ejianc.framework.core.response.CommonResponse<com.alibaba.fastjson.JSONObject>
	 */
	@RequestMapping(value = "/list/ref", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<IPage<DefdocEntity>> ref(@RequestParam Integer pageNumber,
										  @RequestParam Integer pageSize,
										  String searchText) {
		QueryParam queryParam = new QueryParam();
		queryParam.setPageIndex(pageNumber);
		queryParam.setPageSize(pageSize);
		Map<String, Parameter> param = queryParam.getParams();
		param.put("tenantId", new Parameter(QueryParam.EQ, OMS_TENANT));
		if(!StringUtils.isEmpty(searchText)){
			queryParam.setSearchText(searchText);
			queryParam.getFuzzyFields().add("name");
			queryParam.getFuzzyFields().add("code");
		}
		queryParam.getOrderMap().put("sequence", QueryParam.ASC);
		IPage<DefdocEntity> pageData = defdocService.queryPage(queryParam, false);
		return CommonResponse.success("查询数表参照成功", pageData);
	}

	/**
	 * 发布数据
	 * 
	 * @param bo
	 * @return
	 */
	@SuppressWarnings("unchecked")
	@ResponseBody
	@RequestMapping(value = "publish")
	public CommonResponse<String> publish(@RequestBody PublishVO publishVO) {
		try {
			String targetEnv = publishVO.getTarget();
			if (StringUtils.isBlank(targetEnv)) {
				return CommonResponse.error("发布数据失败:目标环境域名不能为空!");
			}
			if (publishVO.getIdList()==null) {
				return CommonResponse.error("发布数据失败:数据不能为空!");
			}
			
			List<Long> ids = null;
			List<String> codes = null;
			List<DefdocEntity> baseEntities = null;
			List<DefdocDetailEntity> detailEntities = null;
			List<DefdocAttrEntity> defdocAttrEntites = new ArrayList<>();

			if(publishVO.getIdList()!=null&&publishVO.getIdList().size()>0){
				baseEntities = (List<DefdocEntity>) defdocService.listByIds(publishVO.getIdList());
				if(ListUtil.isNotEmpty(baseEntities)){
					QueryParam queryParam = new QueryParam();
					for (DefdocEntity record : baseEntities) {
						queryParam.getParams().put("pid",new Parameter(QueryParam.EQ,record.getId()));
						defdocAttrEntites.addAll(defdocAttrServiceImpl.queryList(queryParam));
					}
				}
				List<DefdocDetailVO> vos = defdocDetailService.queryListByDefdocId(publishVO.getIdList());
				if(vos!=null&&vos.size()>0){
					detailEntities = BeanMapper.mapList(vos, DefdocDetailEntity.class);
				}
			}else{
				return CommonResponse.error("未选中要发布的数据");
			}

			if (ids == null || ids.isEmpty() || codes == null || codes.isEmpty()) {
				ids = new ArrayList<Long>(baseEntities.size());
				codes = new ArrayList<String>(baseEntities.size());
				for (DefdocEntity entity : baseEntities) {
					if (entity.getId()!=null) {
						ids.add(entity.getId());
					}
					if (StringUtils.isNotBlank(entity.getCode())) {
						codes.add(entity.getCode());
					}
				}
			}
			/*
			List<String> sqls = new ArrayList<String>();
			List<String> deleteSql = getDeleteSql(ids, codes);
			List<String> insertSql = getInsertSql(baseEntities, detailEntities);
			if (deleteSql != null && !deleteSql.isEmpty()) {
				sqls.addAll(deleteSql);
			}
			if (insertSql != null && !insertSql.isEmpty()) {
				sqls.addAll(insertSql);
			}
			Map<String, Object> params = new HashMap<>();
			params.put("sql", sqls);
			*/
			PublishDataVO publishDataVO = new PublishDataVO();
			if(baseEntities!=null && baseEntities.size()>0){
				baseEntities.forEach(e -> {e.setCreateUserCode(null);e.setCreateTime(null);e.setUpdateUserCode(null);e.setUpdateTime(null);});
			}
			if(detailEntities!=null && detailEntities.size()>0){
				detailEntities.forEach(e -> {e.setCreateUserCode(null);e.setCreateTime(null);e.setUpdateUserCode(null);e.setUpdateTime(null);});
			}
			if(defdocAttrEntites!=null && defdocAttrEntites.size()>0){
				defdocAttrEntites.forEach(e -> {e.setCreateUserCode(null);e.setCreateTime(null);e.setUpdateUserCode(null);e.setUpdateTime(null);});
			}

			publishDataVO.setDefdocEntities(baseEntities);
			publishDataVO.setDefdocDetailEntities(detailEntities);
			publishDataVO.setDefdocAttrEntites(defdocAttrEntites);
			publishDataVO.setIds(ids);
			publishDataVO.setType("defdoc");
			String url = publishVO.getTarget() + DataTransferUtil.DATA_TRANSFER_REST_URL2;
			gson = new GsonBuilder().disableHtmlEscaping().create();
			String paramterStr = gson.toJson(publishDataVO);
			
			logger.info("发布数据的url：---------------"+url);
			try {
				String result = ReferHttpClientUtils.postByJson(url, paramterStr);
				logger.info("发布数据返回的结果：---------------"+result);
				return gson.fromJson(result, CommonResponse.class);
			} catch (Exception e) {
				e.printStackTrace();
				return CommonResponse.error("发布档案数据失败");
			}
		} catch (Exception e) {
			return CommonResponse.error("发布档案数据失败:" + e.getMessage());
		}
	}

	private List<String> getDeleteSql(List<Long> ids, List<String> codes) {
		if (ids == null || ids.isEmpty()) {
			return null;
		}
		List<String> sqlList = new ArrayList<String>();
		String idStr = "";
		for (Long id : ids) {
			idStr = idStr + "'" + id + "',";
		}
		String codeStr = "";
		for (String code : codes) {
			codeStr = codeStr + "'" + code + "',";
		}
		idStr = "(" + idStr.substring(0, idStr.lastIndexOf(",")) + ")";
		codeStr = "(" + codeStr.substring(0, codeStr.lastIndexOf(",")) + ")";
		String baseTableName = "ejc_support_defdoc";
		String detailName = "ejc_support_defdoc_detail";
		String attrName = "ejc_support_defdoc_attribute";
		String attrSql = " delete from " + attrName + " where pid in " + idStr + ";";
		String detailSql = " delete from " + detailName + " where tenant_id = 999999 and defdoc_id in " + idStr + ";";
		String deleteBaseSql = " delete from " + baseTableName + " where id in " + idStr + ";";
		String deleteByCodeSql = " delete from " + baseTableName + " where dr =1 and code in " + codeStr + ";";
		sqlList.add(attrSql);
		sqlList.add(detailSql);
		sqlList.add(deleteBaseSql);
		sqlList.add(deleteByCodeSql);
		return sqlList;
	}
	private List<String> getInsertSql(List<DefdocEntity> baseEntityList, List<DefdocDetailEntity> detailEntities) throws Exception {
		List<String> retList = new ArrayList<String>();
		List<String> baseInsertSql = DataTransferUtil.getInsertSql(baseEntityList);
		List<DefdocAttrEntity> attrEntities = new ArrayList<>();
		for (DefdocEntity defdocEntity : baseEntityList) {
			if(ListUtil.isNotEmpty(defdocEntity.getAttrs())){
				attrEntities.addAll(defdocEntity.getAttrs());
			}
		}
		List<String> attrInsertSql = DataTransferUtil.getInsertSql(attrEntities);
		//由于档案项子表是租户表数据，所以不能调用通用方法，只能自己写了(-> <-!)
		List<String> detailInsertSql = DataTransferUtil.getInsertSql(detailEntities);
		if (baseInsertSql != null && !baseInsertSql.isEmpty()) {
			retList.addAll(baseInsertSql);
		}
		if(ListUtil.isNotEmpty(attrInsertSql)){
			retList.addAll(attrInsertSql);
		}
		if (detailInsertSql != null && !detailInsertSql.isEmpty()) {
			retList.addAll(detailInsertSql);
		}
		return retList;
	}
	
	/**
	 * 抽取SQL脚本
	 * 
	 * @param req
	 *            HTTP头信息
	 * @return
	 */
	@ResponseBody
	@RequestMapping(value = "/exportSQL")
	public void exportSQL(HttpServletRequest req, HttpServletResponse response,
			@RequestBody PublishVO publishVO) {
		try {
			if (publishVO.getIdList()==null) {
				throw new BusinessException("未选中要导出脚本的数据!");
			}
			
			List<Long> ids = null;
			List<String> codes = null;
			List<DefdocEntity> baseEntities = null;
			List<DefdocDetailEntity> detailEntities = null;
			
			if(publishVO.getIdList()!=null&&publishVO.getIdList().size()>0){
				baseEntities = (List<DefdocEntity>) defdocService.listByIds(publishVO.getIdList());
				if(ListUtil.isNotEmpty(baseEntities)){
					QueryParam queryParam = new QueryParam();
					for (DefdocEntity record : baseEntities) {
						queryParam.getParams().put("pid",new Parameter(QueryParam.EQ,record.getId()));
						record.setAttrs(defdocAttrServiceImpl.queryList(queryParam));
					}
				}
				List<DefdocDetailVO> vos = defdocDetailService.queryListByDefdocId(publishVO.getIdList());
				if(vos!=null&&vos.size()>0){
					detailEntities = BeanMapper.mapList(vos, DefdocDetailEntity.class);
				}
			}else{
				throw new BusinessException("未选中要导出脚本的数据!");
			}
			
			if (ids == null || ids.isEmpty() || codes == null || codes.isEmpty()) {
				ids = new ArrayList<Long>(baseEntities.size());
				codes = new ArrayList<String>(baseEntities.size());
				for (DefdocEntity entity : baseEntities) {
					if (entity.getId()!=null) {
						ids.add(entity.getId());
					}
					if (StringUtils.isNotBlank(entity.getCode())) {
						codes.add(entity.getCode());
					}
				}
			}
			List<String> sqls = new ArrayList<String>();
			List<String> deleteSql = getDeleteSql(ids, codes);
			List<String> insertSql = getInsertSql(baseEntities, detailEntities);
			if (deleteSql != null && !deleteSql.isEmpty()) {
				sqls.addAll(deleteSql);
			}
			if (insertSql != null && !insertSql.isEmpty()) {
				sqls.addAll(insertSql);
			}
			
			StringBuffer fileName = new StringBuffer();
			fileName.append("billType.sql");

			response.setContentType("application/octet-stream; charset=utf-8");
			response.setHeader("Content-Disposition",
					"attachment; filename=" + URLEncoder.encode(fileName.toString(), "UTF-8"));
			OutputStream out = response.getOutputStream();
			// 将sql结果list转换为string并换行
			out.write(String.join("\r\n", sqls).getBytes());
			out.flush();
			out.close();
		} catch (Exception e) {
			logger.error(e.getMessage());
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
		}
	}
	
	/**
	 * 同步其他租户
	 * 
	 * @param req
	 *            HTTP头信息
	 * @return
	 */
	@ResponseBody
	@RequestMapping(value = "sysOtherTenant")
	public CommonResponse<String> sysOtherTenant(@RequestBody PublishVO publishVO) {
		try {
			//获取999999租户所有的自定义档案项
			QueryParam queryParam = new QueryParam();
			queryParam .getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
			List<DefdocDetailEntity> detailEntities = defdocDetailService.queryList(queryParam);
			List<String> detailInsertSql = new ArrayList<>();
			List<Long> tenantIds = new ArrayList<>();
			if("other".equals(publishVO.getScope())){
				//选中的租户
				tenantIds = publishVO.getIdList();
			}else{
				//全部租户
				CommonResponse<List<Long>> tenantList = tenantApi.getAllValidTenantId();
				if(tenantList.isSuccess()&&tenantList.getData()!=null){
					tenantIds = tenantList.getData();
				}
			}
			if(tenantIds!=null&&tenantIds.size()>0){
				for(Long tenantId : tenantIds){
					if(tenantId!=999999l){
						for(DefdocDetailEntity detail : detailEntities){
							SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
							String insertSql = " insert ignore into ejc_support_"+tenantId+"_defdoc_detail( tenant_id,sync_es_flag,update_time,create_time,id,update_user_code,create_user_code,`dr`,"
									+ "parent_id,defdoc_id,`code`,`name`,`enabled`,inner_code,sequence,description ) values ("
									+ tenantId + "," + detail.getSyncEsFlag() 
									+ "," + (detail.getUpdateTime()!=null?("'"+sdf.format(detail.getUpdateTime())+"'"):detail.getUpdateTime())
									+ "," + (detail.getCreateTime()!=null?("'"+sdf.format(detail.getCreateTime())+"'"):detail.getCreateTime())
									+ "," + detail.getId()
									+ "," + "''" + "," + "''"
									+ "," + 0
									+ "," + detail.getParentId() + "," + detail.getDefdocId()
									+ "," + (detail.getCode()!=null?("'"+detail.getCode()+"'"):detail.getCode())
									+ "," + (detail.getName()!=null?("'"+detail.getName()+"'"):detail.getName())
									+ "," + detail.getEnabled()
									+ "," + (detail.getInnerCode()!=null?("'"+detail.getInnerCode()+"'"):detail.getInnerCode())
									+ "," + detail.getSequence()
									+ "," + (detail.getDescription()!=null?("'"+detail.getDescription()+"'"):detail.getDescription())
									+ ");";
							detailInsertSql.add(insertSql);
						}
					}
				}
			}
			if (detailInsertSql != null&&detailInsertSql.size()>0) {
				return dataTransferService.executeSql(detailInsertSql);
			}
			return CommonResponse.success("同步成功");
		} catch (Exception e) {
			logger.error(e.getMessage());
			return CommonResponse.error(e.getMessage());
		}
	}
}
