/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.billcode.elemproc;

import com.ejianc.foundation.billcode.BillCodeEngineContext;
import com.ejianc.foundation.billcode.BillCodeException;
import com.ejianc.foundation.billcode.elemproc.itf.IElemProcessor;
import com.ejianc.foundation.billcode.elemproc.result.BillCodeElemInfo;
import com.ejianc.foundation.billcode.elemproc.result.BillCodeInfo;
import com.ejianc.foundation.billcode.elemproc.result.BillCodeSerialNumInfo;
import com.ejianc.foundation.billcode.elemproc.result.BillCodeSysDateInfo;
import com.ejianc.foundation.billcode.model.BillCodeBillVO;
import com.ejianc.foundation.billcode.sngenerator.ISNGenerator;
import com.ejianc.foundation.support.vo.BillCodeRuleAttrVO;
import com.ejianc.foundation.support.vo.BillCodeRuleVO;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class BillCodeElemProcEngine {
    private static BillCodeElemProcEngine elemProcEngine;

    public static BillCodeElemProcEngine getInstance() {
        if (elemProcEngine == null) {
            elemProcEngine = new BillCodeElemProcEngine();
        }
        return elemProcEngine;
    }

    public List<BillCodeRuleAttrVO> sortBillCodeElems(List<BillCodeRuleAttrVO> attrs) {
        attrs.sort(new MyComparator());
        return attrs;
    }

    public BillCodeInfo procElems(BillCodeRuleVO ruleVO, BillCodeBillVO billCodeBillVO) throws BillCodeException {
        BillCodeInfo billCodeInfo = new BillCodeInfo();
        List<BillCodeRuleAttrVO> sortedElemVOs = this.sortBillCodeElems(ruleVO.getAttrs());
        int snElemcnt = 0;
        BillCodeSerialNumInfo snInfo = new BillCodeSerialNumInfo();
        int nowLocation = 0;
        ArrayList<BillCodeSysDateInfo> sysDateInfos = new ArrayList<BillCodeSysDateInfo>();
        List<BillCodeRuleAttrVO> attrs = sortedElemVOs;
        for (BillCodeRuleAttrVO attrVO : attrs) {
            BillCodeElemInfo eleminfo = this.ProcElem(attrVO, billCodeBillVO);
            billCodeInfo.addElemCodeInfo(eleminfo);
            if ("0".equals(attrVO.getElemType())) {
                if (++snElemcnt > 1) {
                    throw new BillCodeException("\u7f16\u7801\u89c4\u5219\u6709\u591a\u4e2a\u6d41\u6c34\u5b57\u6bb5");
                }
                ISNGenerator sysDateInfo = BillCodeEngineContext.getInstance().getSNGeneratorImpl(attrVO.getElemValue());
                snInfo.setSnGenerator(sysDateInfo);
                snInfo.setSnLength(attrVO.getElemLength());
            }
            if (eleminfo.isSysTimeElem() && StringUtils.isNotBlank((CharSequence)eleminfo.getElemSNRefer())) {
                BillCodeSysDateInfo billCodeSysDateInfo = new BillCodeSysDateInfo();
                billCodeSysDateInfo.setStart(nowLocation);
                billCodeSysDateInfo.setEnd(nowLocation + eleminfo.getElemLength());
                billCodeSysDateInfo.setDisplayFormat(attrVO.getDateElemDisplayFormat());
                billCodeSysDateInfo.setElemSNRefer(eleminfo.getElemSNRefer());
                sysDateInfos.add(billCodeSysDateInfo);
            }
            nowLocation += eleminfo.getElemLength();
        }
        billCodeInfo.setSerialNumInfo(snInfo);
        billCodeInfo.setSysDateRefInfos(sysDateInfos);
        return billCodeInfo;
    }

    private BillCodeElemInfo ProcElem(BillCodeRuleAttrVO vo, BillCodeBillVO billCodeBillVO) throws BillCodeException {
        IElemProcessor ElemProcessor = BillCodeEngineContext.getInstance().getElemProcessor(vo.getElemType());
        if (ElemProcessor == null) {
            throw new BillCodeException("\u5143\u7d20\u6ca1\u6709\u5bf9\u5e94\u7684\u5904\u7406\u5668\uff01");
        }
        return ElemProcessor.procElemInfo(vo, billCodeBillVO);
    }

    private class MyComparator
    implements Comparator<BillCodeRuleAttrVO> {
        private MyComparator() {
        }

        @Override
        public int compare(BillCodeRuleAttrVO vo1, BillCodeRuleAttrVO vo2) {
            int elemOrder2;
            int elemOrder1 = vo1.getElemOrder();
            return elemOrder1 > (elemOrder2 = vo2.getElemOrder()) ? 1 : -1;
        }
    }
}

