/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.billcode.engine;

import com.alibaba.fastjson.JSON;
import com.ejianc.foundation.billcode.engine.persistence.IBillCodeEngineService;
import com.ejianc.foundation.billcode.engine.persistence.vo.BillCodeSNVO;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.exceptions.JedisException;

@Component
public class BillcodeSNReferQueue
implements InitializingBean {
    private static final Log logger = LogFactory.getFactory().getInstance(BillcodeSNReferQueue.class);
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private IBillCodeEngineService billCodeEngineService;
    public static final String MESSAGE_KEY = "billcodesnrefer:queue";
    private volatile int count = 0;

    public void afterPropertiesSet() throws Exception {
        BillcodeSNReferThread thread = new BillcodeSNReferThread();
        thread.start();
    }

    private void handle(BillCodeSNVO billCodeSNVO) {
        if (null == billCodeSNVO.getId()) {
            BillCodeSNVO dBBillCodeSNVO = this.billCodeEngineService.querySNVO(billCodeSNVO.getRuleId(), billCodeSNVO.getMarkStr(), billCodeSNVO.getTenantId());
            if (dBBillCodeSNVO == null) {
                this.billCodeEngineService.insertSNVO(billCodeSNVO);
            } else {
                this.billCodeEngineService.updateSNVO(dBBillCodeSNVO.getRuleId(), billCodeSNVO.getMarkStr(), billCodeSNVO.getLastsn(), billCodeSNVO.getTenantId());
            }
        } else {
            this.billCodeEngineService.updateSNVO(billCodeSNVO.getRuleId(), billCodeSNVO.getMarkStr(), billCodeSNVO.getLastsn(), billCodeSNVO.getTenantId());
        }
    }

    public class BillcodeSNReferThread
    extends Thread {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Jedis jedis = null;
            try {
                try {
                    jedis = BillcodeSNReferQueue.this.jedisPool.getResource();
                    while (true) {
                        String message;
                        if ((message = jedis.rpop(BillcodeSNReferQueue.MESSAGE_KEY)) != null) {
                            BillcodeSNReferQueue.this.count++;
                            BillCodeSNVO billCodeSNVO = (BillCodeSNVO)((Object)JSON.parseObject((String)message, BillCodeSNVO.class));
                            logger.error((Object)("\u7b2c" + BillcodeSNReferQueue.this.count + "\u6b21\u5199\u5165\u6570\u636e\u5e93\u6700\u5927\u6d41\u6c34\u53f7"));
                            BillcodeSNReferQueue.this.handle(billCodeSNVO);
                        }
                        Thread.sleep(300L);
                    }
                }
                catch (JedisException e) {
                    throw new JedisException((Throwable)e);
                }
                catch (InterruptedException e) {
                    logger.error((Object)"\u6d41\u6c34\u53f7\u5f02\u6b65\u5165\u5e93\u5931\u8d25", (Throwable)e);
                    if (jedis != null) {
                        jedis.close();
                    }
                }
            }
            catch (Throwable throwable) {
                if (jedis != null) {
                    jedis.close();
                }
                throw throwable;
            }
        }
    }
}

