/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.billcode.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BillCodeProcessUtils {
    private static Logger logger = LoggerFactory.getLogger(BillCodeProcessUtils.class);

    public static String formatDate(Date date, String Format2) {
        SimpleDateFormat sdf = new SimpleDateFormat(Format2.trim());
        return sdf.format(date);
    }

    public static Date getDatebyDateString(String dateString, String Format2) {
        SimpleDateFormat sdf = new SimpleDateFormat(Format2);
        Date date = null;
        try {
            date = sdf.parse(dateString.trim());
        }
        catch (ParseException e) {
            logger.error("\u5b57\u7b26\u4e32\u8f6c\u65e5\u671f\u5f02\u5e38\uff0c", (Throwable)e);
        }
        return date;
    }

    public static String getDateReferString(int referValue) {
        String dateReferString = "";
        if (referValue == 1) {
            dateReferString = "yyyy";
        } else if (referValue == 2) {
            dateReferString = "yyyyMM";
        } else if (referValue == 3) {
            dateReferString = "yyyyMMdd";
        }
        return dateReferString;
    }

    public static String getDateElemSNRefer(int referValue, Date date) {
        String dateElemSNRefer = "";
        String dateReferFromatString = BillCodeProcessUtils.getDateReferString(referValue);
        if (!dateReferFromatString.trim().equals("")) {
            dateElemSNRefer = BillCodeProcessUtils.formatDate(date, dateReferFromatString);
        }
        return dateElemSNRefer;
    }

    public static String formatString(int fillStyle, String fillSign, int length, String originStr) {
        String formatedStr = "";
        if (originStr.trim().length() >= length) {
            formatedStr = originStr.substring(0, length);
        } else {
            StringBuffer sb = new StringBuffer();
            StringBuffer fillSignStr = new StringBuffer();
            for (int i = 0; i < originStr.trim().length(); ++i) {
                fillSignStr.append(fillSign.trim());
            }
            if (fillStyle == 0) {
                sb.append(originStr);
            } else if (fillStyle == 2) {
                sb.append(originStr).append(fillSignStr);
            } else if (fillStyle == 1) {
                sb.append(fillSignStr).append(originStr);
            }
            formatedStr = sb.toString();
        }
        return formatedStr;
    }
}

