/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.dataModel.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.dataModel.bean.DataModelBillEntity;
import com.ejianc.foundation.dataModel.bean.DataModelColumnEntity;
import com.ejianc.foundation.dataModel.bean.DataModelCusEntity;
import com.ejianc.foundation.dataModel.bean.DataModelEntity;
import com.ejianc.foundation.dataModel.service.IDataModelBillService;
import com.ejianc.foundation.dataModel.service.IDataModelColumnService;
import com.ejianc.foundation.dataModel.service.IDataModelCusService;
import com.ejianc.foundation.dataModel.service.IDataModelService;
import com.ejianc.foundation.dataModel.vo.DataModelVO;
import com.ejianc.foundation.dataModel.vo.PublishVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"dataModel"})
public class DataModelController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IDataModelColumnService dataModelColumnService;
    @Autowired
    private IDataModelBillService dataModelBillService;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IDataModelService service;
    @Autowired
    private IDataModelCusService iDataModelCusService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<DataModelVO> saveOrUpdate(@RequestBody DataModelVO saveOrUpdateVO) {
        DataModelEntity entity = (DataModelEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, DataModelEntity.class));
        QueryParam param = new QueryParam();
        param.getParams().put("code", new Parameter("eq", (Object)saveOrUpdateVO.getCode()));
        param.getParams().put("id", new Parameter("ne", (Object)saveOrUpdateVO.getId()));
        if (ListUtil.isNotEmpty((List)this.service.queryList(param))) {
            return CommonResponse.error((String)"\u7f16\u7801\u91cd\u590d\uff01");
        }
        this.service.saveOrUpdate((Object)entity, false);
        DataModelVO vo = (DataModelVO)BeanMapper.map((Object)((Object)entity), DataModelVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/saveOrUpdateCus"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<DataModelVO> saveOrUpdateCus(@RequestBody DataModelVO saveOrUpdateVO) {
        DataModelCusEntity cusEntity = this.iDataModelCusService.queryCusModelByModelId(saveOrUpdateVO.getId());
        if (cusEntity != null) {
            cusEntity.setName(saveOrUpdateVO.getName());
        } else {
            cusEntity = new DataModelCusEntity();
            cusEntity.setModelId(saveOrUpdateVO.getId());
            cusEntity.setName(saveOrUpdateVO.getName());
            cusEntity.setTenantId(InvocationInfoProxy.getTenantid());
        }
        this.iDataModelCusService.saveOrUpdate((Object)cusEntity, false);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)saveOrUpdateVO);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<DataModelVO> queryDetail(Long id) {
        DataModelEntity entity = (DataModelEntity)((Object)this.service.selectById(id));
        DataModelVO vo = (DataModelVO)BeanMapper.map((Object)((Object)entity), DataModelVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetailCus"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<DataModelVO> queryDetailCus(Long id) {
        DataModelEntity entity = (DataModelEntity)((Object)this.service.selectById(id));
        DataModelVO vo = (DataModelVO)BeanMapper.map((Object)((Object)entity), DataModelVO.class);
        DataModelCusEntity cusEntity = this.iDataModelCusService.queryCusModelByModelId(id);
        if (cusEntity != null) {
            vo.setName(cusEntity.getName());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> vos) {
        this.service.removeByIds(vos, false);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<DataModelVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getOrderMap().put("sequence", "asc");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), DataModelVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryCusList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<DataModelVO>> queryCusList(@RequestBody QueryParam param) {
        param.getOrderMap().put("sequence", "asc");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        for (DataModelEntity record : page.getRecords()) {
            DataModelCusEntity cusEntity = this.iDataModelCusService.queryCusModelByModelId(record.getId());
            if (cusEntity == null) continue;
            record.setName(cusEntity.getName());
        }
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), DataModelVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("DataModel-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refDataModelData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<DataModelVO>> refDataModelData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), DataModelVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @PostMapping(value={"queryDataModelDataByBill"})
    @ResponseBody
    public CommonResponse<List<JSONObject>> saveOrQueryDataModelDataByBill(@RequestBody JSONObject jsonObject, HttpServletRequest request) {
        if (jsonObject == null) {
            return CommonResponse.error((String)"\u53c2\u6570\u9519\u8bef\uff01");
        }
        String billTypeCode = jsonObject.getString("billTypeCode");
        JSONObject bill = jsonObject.getJSONObject("bill");
        if (StringUtils.isEmpty((CharSequence)billTypeCode)) {
            return CommonResponse.error((String)"\u5355\u636e\u7c7b\u578b\u7f16\u7801\u4e3a\u7a7a\uff0c\u8bf7\u5728\u6570\u636e\u6a21\u578b\u4e2d\u6dfb\u52a0\u5355\u636e\u7c7b\u578b\uff01");
        }
        if (bill == null) {
            return CommonResponse.error((String)"\u672a\u83b7\u53d6\u5230\u5355\u636e\u7684\u6570\u636e\uff01");
        }
        return this.service.saveOrQueryDataModelDataByBill(jsonObject, request);
    }

    @GetMapping(value={"queryDataModelExist"})
    @ResponseBody
    public CommonResponse<List<Long>> queryDataModelExist(@RequestParam String billTypeCode) {
        if (StringUtils.isEmpty((CharSequence)billTypeCode)) {
            return CommonResponse.error((String)"\u5355\u636e\u7c7b\u578b\u7f16\u7801\u4e3a\u7a7a\uff0c\u8bf7\u5728\u6570\u636e\u6a21\u578b\u4e2d\u6dfb\u52a0\u5355\u636e\u7c7b\u578b\uff01");
        }
        return this.service.queryDataModelExist(billTypeCode);
    }

    @RequestMapping(value={"/publishDataModel"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> publishDataModel(@RequestBody PublishVO publishVO) {
        this.logger.info(JSONObject.toJSONString((Object)publishVO));
        if (ListUtil.isEmpty((List)publishVO.getIds())) {
            return CommonResponse.error((String)"\u53d1\u5e03\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)publishVO.getTarget())) {
            return CommonResponse.error((String)"\u53d1\u5e03\u76ee\u6807\u73af\u5883\u670d\u52a1\u5668\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        QueryParam param = new QueryParam();
        param.getParams().put("id", new Parameter("in", (Object)publishVO.getIds()));
        List dataSetEntities = this.service.queryList(param);
        if (ListUtil.isEmpty((List)dataSetEntities)) {
            return CommonResponse.error((String)"\u53d1\u5e03\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        for (DataModelEntity modelEntity : dataSetEntities) {
            param = new QueryParam();
            param.getParams().put("modelId", new Parameter("eq", (Object)modelEntity.getId()));
            modelEntity.setColumnEntities(this.dataModelColumnService.queryList(param));
            param = new QueryParam();
            param.getParams().put("dataModelId", new Parameter("eq", (Object)modelEntity.getId()));
            modelEntity.setBillEntities(this.dataModelBillService.queryList(param));
        }
        try {
            String res = HttpTookit.postByJson((String)(publishVO.getTarget() + "/ejc-support-web/dataModel/receiveDataModel"), (String)JSONObject.toJSONString((Object)dataSetEntities));
            if (StringUtils.isEmpty((CharSequence)res)) {
                return CommonResponse.error((String)"\u53d1\u5e03\u5931\u8d25\uff01\u76ee\u6807\u670d\u52a1\u5668\u54cd\u5e94\u6570\u636e\u4e3a\u7a7a\uff01");
            }
            CommonResponse response = (CommonResponse)JSONObject.parseObject((String)res, CommonResponse.class);
            return response;
        }
        catch (Exception e) {
            e.printStackTrace();
            return CommonResponse.error((String)"\u53d1\u5e03\u5931\u8d25\uff01");
        }
    }

    @RequestMapping(value={"/receiveDataModel"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> receiveDataModel(@RequestBody List<DataModelEntity> dataSetEntities) {
        this.logger.info(JSONObject.toJSONString(dataSetEntities));
        if (ListUtil.isEmpty(dataSetEntities)) {
            return CommonResponse.success((String)"\u53d1\u5e03\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        String ids = StringUtils.join((Iterable)dataSetEntities.stream().map(BaseEntity::getId).collect(Collectors.toList()), (String)",");
        this.service.deleteByIds(ids);
        this.service.saveOrUpdateBatch(dataSetEntities);
        for (DataModelEntity modelEntity : dataSetEntities) {
            List<DataModelColumnEntity> columnEntities = modelEntity.getColumnEntities();
            this.dataModelColumnService.deleteByModelId(modelEntity.getId());
            if (ListUtil.isNotEmpty(columnEntities)) {
                this.dataModelColumnService.saveOrUpdateBatch(columnEntities);
            }
            List<DataModelBillEntity> billEntities = modelEntity.getBillEntities();
            this.dataModelBillService.deleteByModelId(modelEntity.getId());
            if (!ListUtil.isNotEmpty(billEntities)) continue;
            this.dataModelBillService.saveOrUpdateBatch(billEntities);
        }
        return CommonResponse.success((String)"\u53d1\u5e03\u6210\u529f\uff01");
    }
}

