/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.foundation.billcode.BillCodeException;
import com.ejianc.foundation.share.bean.SupplierCategoryEntity;
import com.ejianc.foundation.share.service.ISupplierCategoryService;
import com.ejianc.foundation.share.service.ISupplierService;
import com.ejianc.foundation.share.vo.SupplierCategoryVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.service.IBillCodeGenerator;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ResultAsTree;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/supplier/category/"})
public class SupplierCategoryController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String SUPPLIER_CATEGORY_BILL_CODE = "SUPPORT_SUPPLIER_CATEGORY";
    @Autowired
    private ISupplierCategoryService supplierCategoryService;
    @Autowired
    private ISupplierService supplierService;
    @Autowired
    private IBillCodeGenerator generator;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveOrUpdate(@RequestBody SupplierCategoryVO supplierCategoryVo) throws BillCodeException {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (supplierCategoryVo.getId() != null && supplierCategoryVo.getId() > 0L) {
            SupplierCategoryEntity uniqueBean = this.supplierCategoryService.queryDetail(supplierCategoryVo.getId());
            uniqueBean.setCode(supplierCategoryVo.getCode());
            uniqueBean.setName(supplierCategoryVo.getName());
            uniqueBean.setSequence(supplierCategoryVo.getSequence());
            uniqueBean.setDescription(supplierCategoryVo.getDescription());
            this.supplierCategoryService.saveOrUpdate((Object)uniqueBean, false);
            return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f");
        }
        String billCode = this.generator.generateBillCodeById(SUPPLIER_CATEGORY_BILL_CODE, tenantId);
        supplierCategoryVo.setCode(billCode);
        SupplierCategoryEntity supplierCategoryEntity = (SupplierCategoryEntity)((Object)BeanMapper.map((Object)supplierCategoryVo, SupplierCategoryEntity.class));
        supplierCategoryEntity.setId(IdWorker.getId());
        if (supplierCategoryEntity.getParentId() != null && supplierCategoryEntity.getParentId() > 0L) {
            SupplierCategoryEntity uniqueBean = this.supplierCategoryService.queryDetail(supplierCategoryEntity.getParentId());
            supplierCategoryEntity.setInnerCode(uniqueBean.getInnerCode() + "|" + supplierCategoryEntity.getId());
        } else {
            supplierCategoryEntity.setInnerCode(supplierCategoryEntity.getId().toString());
        }
        this.supplierCategoryService.saveOrUpdate((Object)supplierCategoryEntity, false);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SupplierCategoryVO> queryDetail(@RequestParam Long id) {
        SupplierCategoryEntity entity = this.supplierCategoryService.queryDetail(id);
        if (entity != null) {
            return CommonResponse.success((Object)BeanMapper.map((Object)((Object)entity), SupplierCategoryVO.class));
        }
        return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u53c2\u6570\u9519\u8bef\uff01");
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> delete(@RequestParam Long id) {
        List<SupplierCategoryVO> children = this.supplierCategoryService.queryListByPid(id);
        if (children != null && children.size() > 0) {
            return CommonResponse.error((String)"\u8be5\u5206\u7c7b\u6709\u5b50\u8282\u70b9\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        List<SupplierVO> supplierList = this.supplierService.queryListByCategoryId(id);
        if (supplierList != null && supplierList.size() > 0) {
            return CommonResponse.error((String)"\u8be5\u5206\u7c7b\u4e0b\u5df2\u6709\u4f9b\u65b9\u4fe1\u606f\uff0c\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        this.supplierCategoryService.delete(id);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam queryParam) {
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getOrderMap().put("sequence", "asc");
        List dataList = this.supplierCategoryService.queryList(queryParam, false);
        List resultMapList = BeanMapper.mapList((Iterable)dataList, Map.class);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", (Object)ResultAsTree.createTreeData((List)resultMapList));
        return CommonResponse.success((Object)jsonObject);
    }

    @RequestMapping(value={"/querySupplierRefTree"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> querySupplierRefTree(@RequestParam(required=false) String searchText) {
        try {
            QueryParam queryParam = new QueryParam();
            if (StringUtils.isNotBlank((CharSequence)searchText)) {
                queryParam.getParams().put("name", new Parameter("like", (Object)searchText));
            }
            queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
            queryParam.getOrderMap().put("sequence", "asc");
            List dataList = this.supplierCategoryService.queryList(queryParam, false);
            ArrayList resultMapList = new ArrayList();
            HashMap<String, Object> map = null;
            for (SupplierCategoryEntity entity : dataList) {
                map = new HashMap<String, Object>();
                map.put("id", entity.getId());
                map.put("key", entity.getId());
                map.put("name", entity.getName());
                map.put("title", entity.getName());
                map.put("parentId", entity.getParentId());
                resultMapList.add(map);
            }
            List result = ResultAsTree.createTreeData(resultMapList);
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }
}

