/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.support.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.support.bean.DefdocDetailEntity;
import com.ejianc.foundation.support.service.IDefdocDetailService;
import com.ejianc.foundation.support.service.IDefdocService;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.foundation.support.vo.DefdocVO;
import com.ejianc.foundation.util.DefdocDetailAsTree;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.support.idworker.util.IdWorker;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/defdocdetail/"})
public class DefdocDetailController
implements Serializable {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final long serialVersionUID = 1L;
    @Value(value="${oms.tenantid}")
    private String OMS_TENANT;
    @Autowired
    private IDefdocDetailService defdocDetailService;
    @Autowired
    private IDefdocService defdocService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveOrUpdate(@RequestBody DefdocDetailVO defdocDetailVo) {
        if (defdocDetailVo.getId() != null && defdocDetailVo.getId() > 0L) {
            DefdocDetailVO uniqueBean = this.defdocDetailService.queryDetail(defdocDetailVo.getId());
            List<DefdocDetailVO> detailVOS = this.defdocDetailService.queryListByDefdocId(Collections.singletonList(uniqueBean.getDefdocId()));
            ArrayList num = new ArrayList();
            if (!ListUtil.isEmpty(detailVOS)) {
                detailVOS.forEach(e -> {
                    if (e.getCode().equals(defdocDetailVo.getCode()) && !e.getId().equals(defdocDetailVo.getId())) {
                        num.add(e);
                    }
                });
            }
            if (num.size() > 0) {
                throw new BusinessException("\u4fee\u6539\u5931\u8d25\uff0c\u6863\u6848\u9879\u7f16\u7801\u4e0e\u3010" + ((DefdocDetailVO)num.get(0)).getName() + "\u3011\u91cd\u590d\uff01");
            }
            uniqueBean.setCode(defdocDetailVo.getCode());
            uniqueBean.setName(defdocDetailVo.getName());
            uniqueBean.setSequence(defdocDetailVo.getSequence());
            uniqueBean.setDescription(defdocDetailVo.getDescription());
            uniqueBean.setAttrCode(defdocDetailVo.getAttrCode());
            uniqueBean.setAttrId(defdocDetailVo.getAttrId());
            uniqueBean.setAttrName(defdocDetailVo.getAttrName());
            DefdocDetailEntity defdocDetailEntity = (DefdocDetailEntity)((Object)BeanMapper.map((Object)uniqueBean, DefdocDetailEntity.class));
            defdocDetailEntity.setUpdateUserCode(InvocationInfoProxy.getUsercode());
            defdocDetailEntity.setUpdateTime(new Date());
            defdocDetailEntity.setSyncEsFlag(0);
            this.defdocDetailService.updateDetail(defdocDetailEntity);
            return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f");
        }
        DefdocDetailEntity defdocDetailEntity = (DefdocDetailEntity)((Object)BeanMapper.map((Object)defdocDetailVo, DefdocDetailEntity.class));
        List<DefdocDetailVO> detailVOS = this.defdocDetailService.queryListByDefdocId(Collections.singletonList(defdocDetailEntity.getDefdocId()));
        if (!ListUtil.isEmpty(detailVOS)) {
            detailVOS.forEach(e -> {
                if (e.getCode().equals(defdocDetailEntity.getCode())) {
                    throw new BusinessException("\u4fdd\u5b58\u62a5\u9519\uff0c\u6863\u6848\u9879\u7f16\u7801\u4e0e\u3010" + e.getName() + "\u3011\u91cd\u590d\uff01");
                }
            });
        }
        defdocDetailEntity.setId(IdWorker.getId());
        if (defdocDetailEntity.getParentId() != null && defdocDetailEntity.getParentId() > 0L) {
            DefdocDetailVO uniqueBean = this.defdocDetailService.queryDetail(defdocDetailEntity.getParentId());
            defdocDetailEntity.setEnabled(uniqueBean.getEnabled());
            defdocDetailEntity.setInnerCode(uniqueBean.getInnerCode() + "|" + defdocDetailEntity.getId());
        } else {
            defdocDetailEntity.setInnerCode(defdocDetailEntity.getId().toString());
            defdocDetailEntity.setEnabled(1);
        }
        defdocDetailEntity.setCreateUserCode(InvocationInfoProxy.getUsercode());
        defdocDetailEntity.setCreateTime(new Date());
        defdocDetailEntity.setDr(0);
        defdocDetailEntity.setSyncEsFlag(0);
        this.defdocDetailService.saveDetail(defdocDetailEntity);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<DefdocDetailVO> queryDetail(@RequestParam Long id) {
        DefdocDetailVO defdocDetailVo = this.defdocDetailService.queryDetail(id);
        return CommonResponse.success((Object)defdocDetailVo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> delete(@RequestParam Long id) {
        List<DefdocDetailVO> defdocDetails = this.defdocDetailService.queryListByPid(id);
        if (defdocDetails != null && defdocDetails.size() > 0) {
            return CommonResponse.error((String)"\u8be5\u6863\u6848\u9879\u6709\u5b50\u8282\u70b9\uff0c\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        this.defdocDetailService.delete(id);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam queryParam) {
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List<DefdocDetailEntity> dataList = this.defdocDetailService.queryList(queryParam);
        List resultMapList = BeanMapper.mapList(dataList, Map.class);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", (Object)ResultAsTree.createTreeData((List)resultMapList));
        return CommonResponse.success((Object)jsonObject);
    }

    @GetMapping(value={"/no_auth/detailListByDefdocCode"})
    @ResponseBody
    public CommonResponse<List<Map<String, Object>>> queryDetailListByDefDocCode(@RequestParam String defdocTypeCode, @RequestParam(value="range", required=false) String range, @RequestParam(value="condition", required=false) String condition) {
        return this.queryDetailListByDefdocCode(defdocTypeCode, range, condition);
    }

    @GetMapping(value={"/detailListByDefdocCode"})
    @ResponseBody
    public CommonResponse<List<Map<String, Object>>> queryDetailListByDefdocCode(@RequestParam String defdocTypeCode, @RequestParam(value="range", required=false) String range, @RequestParam(value="condition", required=false) String condition) {
        QueryParam queryParam = new QueryParam();
        DefdocVO defdocVo = this.defdocService.queryUniqueByCode(defdocTypeCode);
        List<String> detailIds = null;
        List docIds = null;
        if (null == defdocVo) {
            return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", new ArrayList());
        }
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (tenantId == null) {
            tenantId = Long.parseLong(this.OMS_TENANT);
        }
        this.logger.info("detailListByDefdocCode ==== condition-----" + condition);
        if (StringUtils.isNotBlank((String)condition) && !"null".equals(condition)) {
            JSONObject jsonParam = JSONObject.parseObject((String)condition);
            if (null != jsonParam.get((Object)"tenantId")) {
                tenantId = Long.valueOf(jsonParam.get((Object)"tenantId").toString());
            }
            if (StringUtils.isNotEmpty((String)jsonParam.getString("attrCode"))) {
                queryParam.getParams().put("attrCode", new Parameter("eq", (Object)jsonParam.getString("attrCode")));
            }
            if (StringUtils.isNotEmpty((String)jsonParam.getString("detailIds"))) {
                detailIds = Arrays.asList(jsonParam.getString("detailIds").split(","));
            }
            if (StringUtils.isNotEmpty((String)jsonParam.getString("docCodes"))) {
                QueryParam docParam = new QueryParam();
                docParam.getParams().put("code", new Parameter("in", (Object)jsonParam.getString("docCodes")));
                List entities = this.defdocService.queryList(docParam, false);
                if (ListUtil.isNotEmpty((List)entities)) {
                    docIds = entities.stream().map(BaseEntity::getId).collect(Collectors.toList());
                }
            }
        }
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)tenantId));
        if (ListUtil.isNotEmpty(docIds)) {
            queryParam.getParams().put("docIds", new Parameter("in", docIds));
        } else {
            queryParam.getParams().put("defdocId", new Parameter("eq", (Object)defdocVo.getId()));
        }
        if (ListUtil.isNotEmpty(detailIds)) {
            queryParam.getParams().put("detailIds", new Parameter("in", detailIds));
        }
        if (!StringUtils.isNotBlank((String)range) || !"all".equals(range)) {
            queryParam.getParams().put("enabled", new Parameter("eq", (Object)1));
        }
        List<DefdocDetailEntity> dataList = this.defdocDetailService.queryList(queryParam);
        List resultMapList = BeanMapper.mapList(dataList, Map.class);
        return CommonResponse.success((Object)ResultAsTree.createTreeData((List)resultMapList));
    }

    @RequestMapping(value={"/enabled/update"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> updateEnabled(@RequestBody DefdocDetailVO defdocDetailVo) {
        this.defdocDetailService.updateEnabled(defdocDetailVo);
        return CommonResponse.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @RequestMapping(value={"/queryListByCode"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryListByCode(@RequestParam String defdocCode) {
        DefdocVO defdocVo = this.defdocService.queryUniqueByCode(defdocCode);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("defdocId", new Parameter("eq", (Object)defdocVo.getId()));
        queryParam.getParams().put("enabled", new Parameter("eq", (Object)1));
        List<DefdocDetailEntity> dataList = this.defdocDetailService.queryList(queryParam);
        ArrayList resultMapList = new ArrayList();
        for (DefdocDetailEntity entity : dataList) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            resultMap.put("id", entity.getId());
            resultMap.put("text", entity.getName());
            resultMap.put("value", entity.getCode());
            resultMap.put("parentId", entity.getParentId());
            resultMapList.add(resultMap);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", (Object)ResultAsTree.createTreeData(resultMapList));
        return CommonResponse.success((Object)jsonObject);
    }

    @RequestMapping(value={"/queryTreeList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryTreeList(@RequestParam String defdocCode, @RequestParam(value="tenantId", required=false) Long tenantId) {
        DefdocVO defdocVo = this.defdocService.queryUniqueByCode(defdocCode);
        if (null == tenantId) {
            tenantId = InvocationInfoProxy.getTenantid();
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)tenantId));
        queryParam.getParams().put("defdocId", new Parameter("eq", (Object)defdocVo.getId()));
        queryParam.getParams().put("enabled", new Parameter("eq", (Object)1));
        List<DefdocDetailEntity> dataList = this.defdocDetailService.queryList(queryParam);
        ArrayList resultMapList = new ArrayList();
        for (DefdocDetailEntity entity : dataList) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            resultMap.put("id", entity.getId());
            resultMap.put("key", entity.getId());
            if (entity.getParentId() != null && entity.getParentId() > 0L) {
                resultMap.put("label", entity.getName() + "(" + entity.getCode() + ")");
                resultMap.put("title", entity.getName() + "(" + entity.getCode() + ")");
                resultMap.put("value", entity.getName() + "(" + entity.getCode() + ")");
            } else {
                resultMap.put("label", entity.getName());
                resultMap.put("title", entity.getName());
                resultMap.put("value", entity.getName());
            }
            resultMap.put("parentId", entity.getParentId());
            resultMapList.add(resultMap);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", (Object)ResultAsTree.createTreeData(resultMapList));
        return CommonResponse.success((Object)jsonObject);
    }

    @RequestMapping(value={"queryReferList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage> queryReferList(@RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=false) String searchText, @RequestParam(required=false) String condition) {
        Page page = new Page();
        try {
            JSONObject json = JSONObject.parseObject((String)condition);
            String defCode = "";
            Long tenantId = InvocationInfoProxy.getTenantid();
            if (json == null || json.get((Object)"defCode") == null) {
                return CommonResponse.error((String)"\u6863\u6848\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7arefCode");
            }
            defCode = json.get((Object)"defCode").toString();
            if (null != json && json.get((Object)"tenantId") != null) {
                tenantId = Long.valueOf(json.getString("tenantId"));
            }
            DefdocVO defdocVo = this.defdocService.queryUniqueByCode(defCode);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenantId", new Parameter("eq", (Object)tenantId));
            queryParam.getParams().put("defdocId", new Parameter("eq", (Object)defdocVo.getId()));
            queryParam.getParams().put("enabled", new Parameter("eq", (Object)1));
            queryParam.getParams().put("searchText", new Parameter("eq", (Object)searchText));
            queryParam.setPageIndex(pageNumber);
            queryParam.setPageSize(pageSize);
            List<DefdocDetailEntity> dataList = this.defdocDetailService.queryList(queryParam);
            List vos = BeanMapper.mapList(dataList, DefdocDetailVO.class);
            page.setCurrent((long)pageNumber);
            page.setRecords(vos);
            page.setSize((long)pageSize);
            page.setTotal((long)vos.size());
        }
        catch (Exception e) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25");
        }
        return CommonResponse.success((Object)page);
    }

    @RequestMapping(value={"queryDefDocReferTree"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> queryDefDocReferTree(@RequestParam(required=false) String searchText, @RequestParam(required=false) String condition) {
        ArrayList<Map<String, Object>> vos = new ArrayList();
        try {
            JSONObject json = JSONObject.parseObject((String)condition);
            String defCode = "";
            Long tenantId = InvocationInfoProxy.getTenantid();
            if (json == null || json.get((Object)"defCode") == null) {
                throw new BusinessException("\u6863\u6848\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7arefCode");
            }
            defCode = json.get((Object)"defCode").toString();
            if (json.get((Object)"tenantId") != null) {
                tenantId = Long.valueOf(json.getString("tenantId"));
            }
            DefdocVO defdocVo = this.defdocService.queryUniqueByCode(defCode);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenantId", new Parameter("eq", (Object)(tenantId == null ? 999999L : tenantId)));
            queryParam.getParams().put("defdocId", new Parameter("eq", (Object)defdocVo.getId()));
            queryParam.getParams().put("enabled", new Parameter("eq", (Object)1));
            queryParam.getParams().put("searchText", new Parameter("eq", (Object)searchText));
            List<DefdocDetailEntity> dataList = this.defdocDetailService.queryList(queryParam);
            ArrayList resultMapList = new ArrayList();
            for (DefdocDetailEntity entity : dataList) {
                HashMap<String, Object> resultMap = new HashMap<String, Object>();
                resultMap.put("id", entity.getId());
                resultMap.put("text", entity.getName());
                resultMap.put("name", entity.getName());
                resultMap.put("value", entity.getCode());
                resultMap.put("parentId", entity.getParentId());
                resultMapList.add(resultMap);
            }
            vos = ResultAsTree.createTreeData(resultMapList);
        }
        catch (Exception e) {
            throw new BusinessException("\u67e5\u8be2\u5931\u8d25");
        }
        return vos;
    }

    @RequestMapping(value={"/sync"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> syncDefdocDetails() {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (this.OMS_TENANT.equals(tenantId.toString())) {
            return CommonResponse.error((String)"\u5e73\u53f0\u8fd0\u8425\u4eba\u5458\u4e0d\u80fd\u64cd\u4f5c\u6b64\u529f\u80fd");
        }
        return CommonResponse.success((String)"\u540c\u6b65\u6210\u529f");
    }

    @RequestMapping(value={"/queryReferTree"}, method={RequestMethod.GET})
    @ResponseBody
    public List<DefdocDetailEntity> queryOrgTree(@RequestParam(required=false) String searchText, @RequestParam(required=true) String condition) {
        JSONObject json = JSONObject.parseObject((String)condition);
        String defCode = "";
        String detailCodes = null;
        if (json == null || json.get((Object)"defCode") == null) {
            throw new BusinessException("\u6863\u6848\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7arefCode");
        }
        defCode = json.get((Object)"defCode").toString();
        detailCodes = json.getString("detailCodes");
        DefdocVO defdocVo = this.defdocService.queryUniqueByCode(defCode);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("defdocId", new Parameter("eq", (Object)defdocVo.getId()));
        queryParam.getParams().put("enabled", new Parameter("eq", (Object)1));
        List<Object> dataList = Lists.newArrayList();
        if (StringUtils.isNotBlank((String)detailCodes)) {
            String[] codes;
            for (String code : codes = detailCodes.split(",")) {
                List<DefdocDetailEntity> resultList;
                queryParam.getParams().put("code", new Parameter("eq", (Object)code));
                List<DefdocDetailEntity> detailPList = this.defdocDetailService.queryList(queryParam);
                if (!ListUtil.isNotEmpty(detailPList)) continue;
                DefdocDetailEntity detailP = detailPList.get(0);
                queryParam.getParams().remove("code");
                queryParam.getParams().put("innerCode", new Parameter("like", (Object)detailP.getInnerCode()));
                if (StringUtils.isNotBlank((String)searchText)) {
                    queryParam.getParams().put("searchText", new Parameter("like", (Object)searchText));
                }
                if (ListUtil.isNotEmpty(resultList = this.defdocDetailService.queryList(queryParam))) {
                    dataList.addAll(resultList);
                }
                queryParam.getParams().remove("innerCode");
                queryParam.getParams().remove("searchText");
            }
        } else {
            if (StringUtils.isNotBlank((String)searchText)) {
                queryParam.getParams().put("searchText", new Parameter("like", (Object)searchText));
            }
            dataList = this.defdocDetailService.queryList(queryParam);
        }
        return DefdocDetailAsTree.createTreeData((List<DefdocDetailEntity>)dataList);
    }

    @RequestMapping(value={"/initDefdoc"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> initDefdoc() {
        this.defdocDetailService.initDefdoc();
        return CommonResponse.success();
    }
}

