/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.support.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.billcode.BillCodeException;
import com.ejianc.foundation.support.bean.ParamRegisterEntity;
import com.ejianc.foundation.support.service.IBillCodeGenerator;
import com.ejianc.foundation.support.service.IParamRegisterService;
import com.ejianc.foundation.support.vo.ParamRegisterVO;
import com.ejianc.foundation.support.vo.PublishVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"paramRegister"})
public class ParamRegisterController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeGenerator generator;
    @Autowired
    private IParamRegisterService service;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ParamRegisterVO> saveOrUpdate(@RequestBody ParamRegisterVO saveorUpdateVO) throws BillCodeException {
        ParamRegisterEntity entity = (ParamRegisterEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, ParamRegisterEntity.class));
        if (InvocationInfoProxy.getTenantid() != 999999L) {
            return CommonResponse.error((String)"\u975e\u6cd5\u79df\u6237\uff0c\u65e0\u6cd5\u521b\u5efa\u53c2\u6570");
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            String billCode = this.generator.generateBillCodeById("param-register-001", InvocationInfoProxy.getTenantid());
            entity.setCode(billCode);
        }
        entity.setTenantId(999999L);
        this.service.saveOrUpdate((Object)entity, false);
        ParamRegisterVO vo = (ParamRegisterVO)BeanMapper.map((Object)((Object)entity), ParamRegisterVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ParamRegisterVO> queryDetail(Long id) {
        ParamRegisterEntity entity = (ParamRegisterEntity)((Object)this.service.selectById(id));
        ParamRegisterVO vo = (ParamRegisterVO)BeanMapper.map((Object)((Object)entity), ParamRegisterVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/configTenantParam"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Boolean> configTenantParam(Long id) {
        return this.service.configTenantParam(id);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ParamRegisterVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ParamRegisterVO>> queryList(@RequestBody QueryParam param) {
        param.getParams().put("tenantId", new Parameter("eq", (Object)999999));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ParamRegisterVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/publishParamConfig"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> publishParamConfig(@RequestBody PublishVO publishVO) {
        return this.service.publishParamConfig(publishVO);
    }
}

