package com.ejianc.foundation.billcode.elemproc;

import com.ejianc.foundation.billcode.BillCodeEngineContext;
import com.ejianc.foundation.billcode.BillCodeException;
import com.ejianc.foundation.billcode.elemproc.itf.IElemProcessor;
import com.ejianc.foundation.billcode.elemproc.result.BillCodeElemInfo;
import com.ejianc.foundation.billcode.elemproc.result.BillCodeInfo;
import com.ejianc.foundation.billcode.elemproc.result.BillCodeSerialNumInfo;
import com.ejianc.foundation.billcode.elemproc.result.BillCodeSysDateInfo;
import com.ejianc.foundation.billcode.model.BillCodeBillVO;
import com.ejianc.foundation.billcode.sngenerator.ISNGenerator;
import com.ejianc.foundation.support.vo.BillCodeRuleAttrVO;
import com.ejianc.foundation.support.vo.BillCodeRuleVO;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class BillCodeElemProcEngine {

    private static BillCodeElemProcEngine elemProcEngine;

    public static BillCodeElemProcEngine getInstance() {
        if(elemProcEngine == null) {
            elemProcEngine = new BillCodeElemProcEngine();
        }

        return elemProcEngine;
    }

    public List<BillCodeRuleAttrVO> sortBillCodeElems(List<BillCodeRuleAttrVO> attrs) {
        attrs.sort(new BillCodeElemProcEngine.MyComparator());
        return attrs;
    }

    public BillCodeInfo procElems(BillCodeRuleVO ruleVO, BillCodeBillVO billCodeBillVO) throws BillCodeException {
        BillCodeInfo billCodeInfo = new BillCodeInfo();
        List<BillCodeRuleAttrVO> sortedElemVOs = this.sortBillCodeElems(ruleVO.getAttrs());
        int snElemcnt = 0;
        BillCodeSerialNumInfo snInfo = new BillCodeSerialNumInfo();
        int nowLocation = 0;
        List<BillCodeSysDateInfo> sysDateInfos = new ArrayList<>();
        List<BillCodeRuleAttrVO> attrs = sortedElemVOs;

        for(BillCodeRuleAttrVO attrVO : attrs) {
            BillCodeElemInfo eleminfo = this.ProcElem(attrVO, billCodeBillVO);
            billCodeInfo.addElemCodeInfo(eleminfo);
            if(BillCodeRuleAttrVO.ELEM_TYPE_SN.equals(attrVO.getElemType())) {
                if(++snElemcnt > 1) {
                    throw new BillCodeException("编码规则有多个流水字段");
                }

                ISNGenerator sysDateInfo = BillCodeEngineContext.getInstance()
                        .getSNGeneratorImpl(attrVO.getElemValue());
                snInfo.setSnGenerator(sysDateInfo);
                snInfo.setSnLength(attrVO.getElemLength());
            }

            if(eleminfo.isSysTimeElem() && StringUtils.isNotBlank(eleminfo.getElemSNRefer())) {
                BillCodeSysDateInfo billCodeSysDateInfo = new BillCodeSysDateInfo();
                billCodeSysDateInfo.setStart(nowLocation);
                billCodeSysDateInfo.setEnd(nowLocation + eleminfo.getElemLength());
                billCodeSysDateInfo.setDisplayFormat(attrVO.getDateElemDisplayFormat());
                billCodeSysDateInfo.setElemSNRefer(eleminfo.getElemSNRefer());
                sysDateInfos.add(billCodeSysDateInfo);
            }

            nowLocation += eleminfo.getElemLength();
        }

        billCodeInfo.setSerialNumInfo(snInfo);
        billCodeInfo.setSysDateRefInfos(sysDateInfos);
        return billCodeInfo;
    }

    private BillCodeElemInfo ProcElem(BillCodeRuleAttrVO vo, BillCodeBillVO billCodeBillVO) throws BillCodeException {
        IElemProcessor ElemProcessor = BillCodeEngineContext.getInstance().getElemProcessor(vo.getElemType());
        if (ElemProcessor == null) {
            throw new BillCodeException("元素没有对应的处理器！");
        } else {
            return ElemProcessor.procElemInfo(vo, billCodeBillVO);
        }
    }

    private class MyComparator implements Comparator<BillCodeRuleAttrVO> {
        private MyComparator() {
        }
        @Override
        public int compare(BillCodeRuleAttrVO vo1, BillCodeRuleAttrVO vo2) {
            int elemOrder1 = vo1.getElemOrder();
            int elemOrder2 = vo2.getElemOrder();
            return elemOrder1 > elemOrder2 ? 1 : -1;
        }
    }
}
