package com.ejianc.foundation.billcode.elemproc.impl;

import com.ejianc.foundation.billcode.BillCodeException;
import com.ejianc.foundation.billcode.elemproc.itf.IElemProcessor;
import com.ejianc.foundation.billcode.elemproc.result.BillCodeElemInfo;
import com.ejianc.foundation.billcode.model.BillCodeBillVO;
import com.ejianc.foundation.support.vo.BillCodeRuleAttrVO;

/**
 * 元素处理器--流水号
 */
public class SerialNumElemProcessor implements IElemProcessor {
    @Override
    public int getCanProcElemType() {
        return 0;
    }

    @Override
    public BillCodeElemInfo procElemInfo(BillCodeRuleAttrVO elemvo, BillCodeBillVO billCodeBillVO) throws BillCodeException {
        BillCodeElemInfo eleminfo = new BillCodeElemInfo();
        eleminfo.setElemValue("##SN##");
        eleminfo.setElemLength(elemvo.getElemLength());
        return eleminfo;
    }
}
