package com.ejianc.foundation.billcode.service.engine;

import com.ejianc.foundation.billcode.engine.persistence.IBillCodeEngineService;
import com.ejianc.foundation.billcode.engine.persistence.vo.BillCodeReternVO;
import com.ejianc.foundation.billcode.engine.persistence.vo.BillCodeSNVO;
import com.ejianc.foundation.billcode.engine.persistence.vo.PreCodeVO;
import com.ejianc.foundation.billcode.entity.BillCodeReturnEntity;
import com.ejianc.foundation.billcode.entity.BillCodeSNEntity;
import com.ejianc.foundation.billcode.entity.PreCodeEntity;
import com.ejianc.foundation.billcode.service.IBcrSnService;
import com.ejianc.foundation.billcode.service.IBillCodeReturnService;
import com.ejianc.foundation.billcode.service.IPreCodeService;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

@Service("billCodeEngineService")
public class BillCodeEngineServiceImp implements IBillCodeEngineService {

    @Autowired
    private IBcrSnService bcrSnService;

    @Autowired
    private IPreCodeService preCodeService;

    @Autowired
    private IBillCodeReturnService billCodeReturnService;

    @Override
    public BillCodeSNVO querySNVO(String ruleId, String markStr, Long tenantId) {
        BillCodeSNVO resp = null;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("rule_id", new Parameter(QueryParam.EQ, ruleId));
        queryParam.getParams().put("mark_str", new Parameter(QueryParam.EQ, markStr));
        queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ, tenantId));
        List<BillCodeSNEntity> eList =  bcrSnService.queryList(queryParam, false);
        if(CollectionUtils.isNotEmpty(eList)) {
            resp = BeanMapper.map(eList.get(0), BillCodeSNVO.class);
        }

        return resp;
    }

    @Override
    public void insertSNVO(BillCodeSNVO billCodeSNVO) {
        bcrSnService.saveOrUpdate(BeanMapper.map(billCodeSNVO, BillCodeSNEntity.class), false);
    }

    @Override
    public void updateSNVO(String ruleId, String markStr, String lastsn, Long tenantId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("rule_id", new Parameter(QueryParam.EQ, ruleId));
        queryParam.getParams().put("mark_str", new Parameter(QueryParam.EQ, markStr));
        queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ, tenantId));
        List<BillCodeSNEntity> eList =  bcrSnService.queryList(queryParam, false);
        if(CollectionUtils.isNotEmpty(eList)) {
            BillCodeSNEntity updateEntity = eList.get(0);
            updateEntity.setLastsn(lastsn);
            bcrSnService.saveOrUpdate(updateEntity, false);
        }
    }

    @Override
    public List<BillCodeReternVO> queryRtnVO(String ruleId, String markStr, Long tenantId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("rule_id", new Parameter(QueryParam.EQ, ruleId));
        queryParam.getParams().put("mark_str", new Parameter(QueryParam.EQ, markStr));
        queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ, tenantId));
        List<BillCodeReturnEntity> eList = billCodeReturnService.queryList(queryParam, false);

        return BeanMapper.mapList(eList, BillCodeReternVO.class);
    }

    @Override
    public void insertPreCode(PreCodeVO precode) {
        preCodeService.saveOrUpdate(BeanMapper.map(precode, PreCodeEntity.class), false);
    }

    @Override
    public void deletRtnCodeBatch(List<BillCodeReternVO> delList) {
        List<Long> delIds = delList.stream().map(r -> r.getId()).collect(Collectors.toList());
        billCodeReturnService.removeByIds(delIds, false);
    }
}
