package com.ejianc.foundation.dataModel.controller;

import java.io.Serializable;

import com.ejianc.foundation.dataModel.bean.*;
import com.ejianc.foundation.dataModel.service.IDataModelBillService;
import com.ejianc.foundation.dataModel.service.IDataModelColumnService;
import com.ejianc.foundation.dataModel.service.IDataModelCusService;
import com.ejianc.foundation.dataModel.vo.PublishVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.HttpTookit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.foundation.dataModel.service.IDataModelService;
import com.ejianc.foundation.dataModel.vo.DataModelVO;

/**
 * 数据模型主表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("dataModel")
public class DataModelController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IDataModelColumnService dataModelColumnService;
    @Autowired
    private IDataModelBillService dataModelBillService;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IDataModelService service;

    @Autowired
    private IDataModelCusService iDataModelCusService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<DataModelVO> saveOrUpdate(@RequestBody DataModelVO saveOrUpdateVO) {
    	DataModelEntity entity = BeanMapper.map(saveOrUpdateVO, DataModelEntity.class);
    	QueryParam param = new QueryParam();
    	param.getParams().put("code",new Parameter(QueryParam.EQ,saveOrUpdateVO.getCode()));
    	param.getParams().put("id",new Parameter(QueryParam.NE,saveOrUpdateVO.getId()));
    	if(ListUtil.isNotEmpty(service.queryList(param))){
    	    return CommonResponse.error("编码重复！");
        }
    	service.saveOrUpdate(entity, false);
    	DataModelVO vo = BeanMapper.map(entity, DataModelVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description saveOrUpdate 修改客户自定义名称
     */
    @RequestMapping(value = "/saveOrUpdateCus", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<DataModelVO> saveOrUpdateCus(@RequestBody DataModelVO saveOrUpdateVO) {
        DataModelCusEntity cusEntity = iDataModelCusService.queryCusModelByModelId(saveOrUpdateVO.getId());
        if(cusEntity!=null){
            cusEntity.setName(saveOrUpdateVO.getName());
        }else {
            cusEntity = new DataModelCusEntity();
            cusEntity.setModelId(saveOrUpdateVO.getId());
            cusEntity.setName(saveOrUpdateVO.getName());
            cusEntity.setTenantId(InvocationInfoProxy.getTenantid());
        }
        iDataModelCusService.saveOrUpdate(cusEntity,false);
    	return CommonResponse.success("保存或修改单据成功！",saveOrUpdateVO);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DataModelVO> queryDetail(Long id) {
    	DataModelEntity entity = service.selectById(id);
    	DataModelVO vo = BeanMapper.map(entity, DataModelVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetailCus", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DataModelVO> queryDetailCus(Long id) {
    	DataModelEntity entity = service.selectById(id);
    	DataModelVO vo = BeanMapper.map(entity, DataModelVO.class);
        DataModelCusEntity cusEntity = iDataModelCusService.queryCusModelByModelId(id);
        if(cusEntity!=null){
            vo.setName(cusEntity.getName());
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> vos) {
        service.removeByIds(vos,false);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<DataModelVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getOrderMap().put("sequence",QueryParam.ASC);
        IPage<DataModelEntity> page = service.queryPage(param,false);
        IPage<DataModelVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), DataModelVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryCusList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<DataModelVO>> queryCusList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        param.getOrderMap().put("sequence",QueryParam.ASC);
        IPage<DataModelEntity> page = service.queryPage(param,false);
        IPage<DataModelVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        for (DataModelEntity record : page.getRecords()) {
            DataModelCusEntity cusEntity = iDataModelCusService.queryCusModelByModelId(record.getId());
            if(cusEntity!=null){
                record.setName(cusEntity.getName());
            }
        }
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), DataModelVO.class));
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<DataModelEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("DataModel-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refDataModelData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<DataModelVO>> refDataModelData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<DataModelEntity> page = service.queryPage(param,false);
        IPage<DataModelVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), DataModelVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }


    /**
     * 根据单据数据 ，查询该单据的数据模型数据
     * @param jsonObject
     *  {
     *  billTypeCode 单据类型编码
     *  bill  单据数据
     *  type   1、查询 2、保存查询
     *  }
     * @return
     */
     @PostMapping("queryDataModelDataByBill")
     @ResponseBody
     public CommonResponse<List<JSONObject>> saveOrQueryDataModelDataByBill(@RequestBody JSONObject jsonObject, HttpServletRequest request){

        if(jsonObject == null){
            return CommonResponse.error("参数错误！");
        }
        String billTypeCode = jsonObject.getString("billTypeCode");
        JSONObject bill = jsonObject.getJSONObject("bill");
        if(StringUtils.isEmpty(billTypeCode)){
            return CommonResponse.error("单据类型编码为空，请在数据模型中添加单据类型！");
        }
        if(bill == null){
            return CommonResponse.error("未获取到单据的数据！");
        }
        return service.saveOrQueryDataModelDataByBill(jsonObject,request);
     }

    /**
     * 根据单据类型，查询其是否挂载数据模型
     * @param billTypeCode
     */
     @GetMapping("queryDataModelExist")
     @ResponseBody
     public CommonResponse<List<Long>> queryDataModelExist(@RequestParam String billTypeCode){
        if(StringUtils.isEmpty(billTypeCode)){
            return CommonResponse.error("单据类型编码为空，请在数据模型中添加单据类型！");
        }
        return service.queryDataModelExist(billTypeCode);
     }

    /**
     * @Description publishDataset 发布数据模型到其他环境
     * @param publishVO
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/publishDataModel", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> publishDataModel(@RequestBody PublishVO publishVO) {
        logger.info(JSONObject.toJSONString(publishVO));
        if(ListUtil.isEmpty(publishVO.getIds())){
            return CommonResponse.error("发布数据不能为空！");
        }
        if(StringUtils.isEmpty(publishVO.getTarget())){
            return CommonResponse.error("发布目标环境服务器地址不能为空！");
        }
        QueryParam param = new QueryParam();
        param.getParams().put("id",new Parameter(QueryParam.IN,publishVO.getIds()));
        List<DataModelEntity> dataSetEntities = service.queryList(param);
        if(ListUtil.isEmpty(dataSetEntities)){
            return CommonResponse.error("发布数据不能为空！");
        }

        for (DataModelEntity modelEntity : dataSetEntities) {
            param = new QueryParam();
            param.getParams().put("modelId",new Parameter(QueryParam.EQ,modelEntity.getId()));
            modelEntity.setColumnEntities(dataModelColumnService.queryList(param));
            param = new QueryParam();
            param.getParams().put("dataModelId",new Parameter(QueryParam.EQ,modelEntity.getId()));
            modelEntity.setBillEntities(dataModelBillService.queryList(param));
        }
        try {
            String res = HttpTookit.postByJson(publishVO.getTarget()+"/ejc-support-web/dataModel/receiveDataModel",JSONObject.toJSONString(dataSetEntities));
            if(StringUtils.isEmpty(res)){
                return CommonResponse.error("发布失败！目标服务器响应数据为空！");
            }
            CommonResponse<String> response = JSONObject.parseObject(res, CommonResponse.class);
            return response;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return CommonResponse.error("发布失败！");
    }

    /**
     * @Description publishDataset 从主环境接收数据模型到本环境保存
     * @param dataSetEntities
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/receiveDataModel", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> receiveDataModel(@RequestBody List<DataModelEntity> dataSetEntities) {
        logger.info(JSONObject.toJSONString(dataSetEntities));
        if(ListUtil.isEmpty(dataSetEntities)){
            return CommonResponse.success("发布数据为空！");
        }
        String ids = StringUtils.join(dataSetEntities.stream().map(DataModelEntity::getId).collect(Collectors.toList()),",");
        service.deleteByIds(ids);
        service.saveOrUpdateBatch(dataSetEntities);
        for (DataModelEntity modelEntity : dataSetEntities) {
            List<DataModelColumnEntity> columnEntities = modelEntity.getColumnEntities();
            dataModelColumnService.deleteByModelId(modelEntity.getId());
            if(ListUtil.isNotEmpty(columnEntities)){
                dataModelColumnService.saveOrUpdateBatch(columnEntities);
            }
            List<DataModelBillEntity> billEntities = modelEntity.getBillEntities();
            dataModelBillService.deleteByModelId(modelEntity.getId());
            if(ListUtil.isNotEmpty(billEntities)){
                dataModelBillService.saveOrUpdateBatch(billEntities);
            }
        }
        return CommonResponse.success("发布成功！");
    }
}
